/*
 * Created on 2005. 7. 23
 */
package pluto.dbutil;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsByteArrayOutputStream;
import pluto.util.PlutoLinkedList;
import pluto.util.convert.BASE64;

/**
 * @author 이상근
 */
@Slf4j
public class ResultSetFileReader {

	private String						sBaseFileName		= null;

	private int							iMakeSeq			= 0;

	protected String					READ_CHAR_SET		= null;

	protected BufferedInputStream		stream				= null;

	protected byte[]					DEC_INT_SOURCE		= new byte[4];

	protected byte[]					DEC_INT_TARGET		= new byte[3];

	protected byte[]					LINE_SKIP_DUMMY		= null;

	protected PlutoLinkedList			HEADER_LIST			= null;

	protected eMsByteArrayOutputStream	bufferByteStream	= null;

	protected byte[]					readByteArray		= new byte[256];
	
	protected static final byte[]	LINE_DELIM			= new byte[] {
			'\r', '\n'								};
	
	protected static final int		LINE_DELIM_LENGTH	= LINE_DELIM.length;

	public ResultSetFileReader(String base_name, String charset) throws Exception {
		this.sBaseFileName = base_name;
		this.iMakeSeq = 0;
		this.READ_CHAR_SET = charset;
		this.HEADER_LIST = new PlutoLinkedList();
		this.LINE_SKIP_DUMMY = new byte[LINE_DELIM_LENGTH];

		// 파일을 준비해야한다.
		if( !openNextFile() ) {
			throw new RuntimeException("MISSING FILE");
		}
	}

	public void close() {
		eMsByteArrayOutputStream.recycleInstance(this.bufferByteStream);

		if( this.stream != null ) {
			try {
				this.stream.close();
			}
			catch(Exception e) {
				// ignore
			}
		}
	}

	private final boolean openNextFile() throws Exception {
		// 먼저 열린거 닫고.
		close();
		File f = new File(this.sBaseFileName + "." + String.valueOf(this.iMakeSeq));
		if( f.exists() && f.isFile() ) {
			FileInputStream fis = new FileInputStream(f);
			GZIPInputStream gis = new GZIPInputStream(fis);
			this.stream = new BufferedInputStream(gis);
			this.iMakeSeq++;
			this.bufferByteStream = eMsByteArrayOutputStream.getInstance();
			return true;
		}

		return false;
	}

	private final void skipLine() throws Exception {
		int skipResult = this.stream.read(this.LINE_SKIP_DUMMY);
		
		if(skipResult < 0){
			log.error("SKIP FAIL");
		}
	}

	public boolean next(Properties prop) throws Exception {
		while (true) {
			int type = this.stream.read();

			switch (type) {
				// 파일을 다 읽었으면 다음 파일이 있는지 알아봐야 한다.
				case ResultSetControlConstant.EOF: {
					if( openNextFile() ) {
						break;
					}
					throw new RuntimeException("MISSING NEXT FILE");
				}

				case ResultSetControlConstant.TYPE_END: {
					if (log.isDebugEnabled()) {
						log.debug("#END");
					}
					return false;
				}

				// 헤더라면
				case ResultSetControlConstant.TYPE_HEADER: {
					if (log.isDebugEnabled()) {
						log.debug("#HEADER");
					}
					// 먼저있던 녀석들은 다 날려버리고.
					this.HEADER_LIST.clear();
					int colcount = readNumericType();
					if (log.isDebugEnabled()) {
						log.debug("#HEADER COLUMN COUNT : " + colcount);
					}
					for (int i = colcount; i > 0; i--) {
						// 다음 사이즈
						int col_length = readNumericType();
						if (log.isDebugEnabled()) {
							log.debug("#READ byte: " + col_length);
						}
						// 그만큼의 스트링
						String col_value = readString(col_length);
						// 리스트에 더하고
						if (log.isDebugEnabled()) 
							log.debug("#PRINT : " + col_value);
						this.HEADER_LIST.addLast(col_value);
					}
					// 다 읽었으면 넘어가야쥐
					skipLine();
					break;
				}

				case ResultSetControlConstant.TYPE_BODY: {
					if (log.isDebugEnabled()) 
						log.debug("#BODY");
					int colcount = readNumericType();
					if (log.isDebugEnabled()) {
						log.debug("#COLUMN COUNT : " + colcount);
					}
					if( colcount != this.HEADER_LIST.size() ) {
						throw new RuntimeException("INVALID COL COUNT HEADER: " + this.HEADER_LIST.size() + " DATA: " + colcount);
					}
					int i = 0;
					for (Iterator iter = HEADER_LIST.iterator(); iter.hasNext();) {
						// 다음 사이즈
						int col_length = readNumericType();
						if (log.isDebugEnabled()) {
							System.out.print(String.valueOf(col_length) + "/");
						}

						// 그만큼의 스트링
						String col_value = col_length > 0 ? readString(col_length) : "";
						if (log.isDebugEnabled()) {
							System.out.print("\\");
						}
						// 리스트에 더하고
						prop.setProperty(iter.next().toString(), col_value);
						if (log.isDebugEnabled()) {
							log.debug(String.valueOf(++i) + ".");
						}
					}
					if (log.isDebugEnabled()) {
						log.debug("#SET RESULT : " + prop.toString());
					}
					skipLine();
					return true;
				}

				default: {
					throw new RuntimeException("INVALID TYPE:" + type);
				}
			}
		}
	}

	protected synchronized String readString(int size) throws IOException {
		byte[] buffer = this.readByteArray;

		if( size < 256 ) {
			if( this.stream.read(buffer, 0, size) != size ) {
				throw new RuntimeException("INVALID LENGTH");
			}
			if (log.isDebugEnabled()) {
				System.out.print("-");
			}
			return new String(buffer, 0, size, this.READ_CHAR_SET);
		}

		this.bufferByteStream.reset();

		if( size > 10000 ) {
			log.debug("KEK");
		}

		while (size > 0) {
			int i = this.stream.read(buffer, 0, size > 256 ? 256 : size);

			if( i <= 0 ) {
				break;
			}
			if (log.isDebugEnabled()) {
				String a = new String(buffer, 0, i, this.READ_CHAR_SET);
				log.debug(a);
			}
			this.bufferByteStream.write(buffer, 0, i);

			if (log.isDebugEnabled()) {
				System.out.print("=");
			}

			size = size - i;
		}

		if (log.isDebugEnabled()) {
			System.out.print("*:" + String.valueOf(this.bufferByteStream.size()));
		}
		return this.bufferByteStream.toString(this.READ_CHAR_SET);
	}

	protected synchronized int readNumericType() throws IOException {
		int returnValue = -1;

		if( this.stream.read(this.DEC_INT_SOURCE) != 4 ) {
			throw new RuntimeException("INVALID FORMAT");
		}

		BASE64.decode_sep(this.DEC_INT_SOURCE, this.DEC_INT_TARGET);

		returnValue = ((this.DEC_INT_TARGET[0] & 0xFF) << 16) + ((this.DEC_INT_TARGET[1] & 0xFF) << 8) + ((this.DEC_INT_TARGET[2] & 0xFF) << 0);

		return returnValue;
	}
}
