/*
 * Created on 2005. 7. 25
 */
package pluto.dbutil;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import pluto.util.PlutoLinkedList;
import pluto.util.StringConvertUtil;

/**
 * @author 이상근
 */
@Slf4j
public class HashPreparedStatement {

	public static final char			STRING_PARAM_INDEX		= '\'';

	public static final short			STRING_TYPE_PARAMETER	= 1;

	public static final short			NUMERIC_TYPE_PARAMETER	= 2;

	private java.sql.PreparedStatement	ps						= null;

	private String						ORIGINAL_QUERY			= null;

	private String						CONVERT_QUERY			= null;

	private PlutoLinkedList				PARAMETER_INFOS			= null;

	private CharConvertor				convertor				= null;

	/** Creates a new instance of eMsPreparedStatement */
	public HashPreparedStatement(String src, String START_INDEX, String END_INDEX) throws Exception {
		this.ORIGINAL_QUERY = src;
		StringBuffer buffer = null;
		try {
			buffer = new StringBuffer(512);
			buffer.setLength(0);
			convertSql(buffer, START_INDEX, END_INDEX);
			this.CONVERT_QUERY = buffer.toString();
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			buffer = null;
		}
	}

	public void connectTo(Connection conn, CharConvertor tcon) throws java.sql.SQLException {
		close();
		this.convertor = tcon;
		ps = conn.prepareStatement(CONVERT_QUERY);

	}

	public void close() {
		if( ps != null ) {
			try {
				ps.close();
			}
			catch(Exception e) {
				// empty
			}
			ps = null;
		}
	}

	public int executeUpdate(Map map) throws java.sql.SQLException {
		try {
			setParameter(map);
			return ps.executeUpdate();
		}
		catch(java.sql.SQLException e) {
			throw e;
		}
		finally {
			// empty
		}
	}

	public ResultSet executeQuery(Map map) throws java.sql.SQLException {
		try {
			setParameter(map);
			return ps.executeQuery();
		}
		catch(java.sql.SQLException e) {
			throw e;
		}
		finally {
			// empty
		}
	}

	/**
	 * 파라미터를세팅한다.
	 * 
	 * @param map
	 *            세팅할 Hash
	 * @param convertor
	 *            세팅할때 변환이 필요하다면..
	 * @throws java.sql.SQLException
	 *             파라미터 세팅하다가 에러가 발생하면.
	 */
	private synchronized void setParameter(Map map) throws java.sql.SQLException {
		if (log.isDebugEnabled()) {
			log.debug("INSERT PARAMETER", map.toString());
		}
		int idx = 1;
		for (Iterator iter = PARAMETER_INFOS.iterator(); iter.hasNext();) {
			PreparedParameter param = (PreparedParameter) iter.next();
			Object value = map.get(param.getIndex());
			switch (param.getType()) {
				case STRING_TYPE_PARAMETER: {
					if (log.isDebugEnabled()) {
						log.debug("STRING_TYPE_PARAMETER set:" + param.getIndex(), "[" + value.toString() + "]");
					}
					if( value == null ) {
						ps.setString(idx, " ");
					}
					else if( value instanceof Throwable ) {
						//ps.setString(idx, this.convertor.encode(StringConvertUtil.exToString(value)));
						ps.setString(idx, this.convertor.encode(StringConvertUtil.exToString((Throwable)value)));
					}
					else {
						ps.setString(idx, this.convertor.encode(value.toString()));
					}
					break;
				}

				case NUMERIC_TYPE_PARAMETER: {
					if( value == null ) {
						throw new RuntimeException("CAN'T SET NUMERIC TO NULL:" + param.getIndex());
					}
					if (log.isDebugEnabled()) {
						log.debug("NUMERIC_TYPE_PARAMETER set:" + param.getIndex(), "[" + value.toString() + "]");
					}
					ps.setInt(idx, Integer.parseInt(value.toString()));
					break;
				}

				default: {
					throw new RuntimeException("UNKNOWN TYPE:" + String.valueOf(param.getType()));
				}
			}
			idx++;
		}
	}

	protected void convertSql(StringBuffer myBuffer, String START_INDEX, String END_INDEX) throws Exception {
		if( this.ORIGINAL_QUERY == null ) {
			throw new RuntimeException("TARGET QUERY IS NULL");
		}

		PARAMETER_INFOS = new PlutoLinkedList();

		String source = this.ORIGINAL_QUERY.concat("             ");

		int idx1 = 0;
		int idx2 = 0;
		int idx3 = 0;

		while (true) {
			idx1 = source.indexOf(START_INDEX, idx3);

			if( idx1 < 0 )
				break;

			idx2 = source.indexOf(END_INDEX, idx1);

			if( idx2 < 0 ) {
				throw new RuntimeException("PARSE ERROR NEAR=>" + source.substring(idx1 - 3));
			}

			/**
			 * String Type & Numeric Type 구분
			 */
			if( source.charAt(idx1 - 1) == STRING_PARAM_INDEX && source.charAt(idx2 + END_INDEX.length()) == STRING_PARAM_INDEX ) {
				/**
				 * 스트링 타입의 파라미터 추가
				 */
				PARAMETER_INFOS.addLast(new PreparedParameter(STRING_TYPE_PARAMETER, source.substring(idx1 + 2, idx2)));
				if (log.isDebugEnabled()) 
					log.debug("STRING_TYPE_PARAMETER", source.substring(idx1 + START_INDEX.length(), idx2) + " ADDED");

				myBuffer.append(source.substring(idx3, idx1 - 1));
				myBuffer.append("?");
				idx3 = idx2 + END_INDEX.length() + 1;
			}
			else if( source.charAt(idx1 - 1) != STRING_PARAM_INDEX && source.charAt(idx2 + END_INDEX.length()) != STRING_PARAM_INDEX ) {
				/**
				 * 스트링 타입의 파라미터 추가
				 */
				PARAMETER_INFOS.addLast(new PreparedParameter(NUMERIC_TYPE_PARAMETER, source.substring(idx1 + 2, idx2)));
				if (log.isDebugEnabled()) 
					log.debug("NUMERIC_TYPE_PARAMETER", source.substring(idx1 + START_INDEX.length(), idx2) + " ADDED");

				myBuffer.append(source.substring(idx3, idx1));
				myBuffer.append("?");
				idx3 = idx2 + END_INDEX.length();
			}
			else {
				throw new RuntimeException("PARSE ERROR NEAR=>" + source.substring(idx1 - 3));
			}
		}

		myBuffer.append(source.substring(idx3));

		return;
	}

	/**
	 * 혹시라도 ps를 닫지 않았다면 ...
	 */
	protected void finalize() throws Throwable {
		close();
	}

	static class PreparedParameter {
		short	type;

		String	index;

		PreparedParameter(short t, String i) {
			type = t;
			index = i;
		}

		public short getType() {
			return type;
		}

		public String getIndex() {
			return index;
		}

		public String toString() {
			switch (type) {
				case STRING_TYPE_PARAMETER: {
					return "STRING_TYPE_PARAMETER:".concat(index);
				}
				case NUMERIC_TYPE_PARAMETER: {
					return "NUMERIC_TYPE_PARAMETER:".concat(index);
				}
				default: {
					return "UNKNOWN TYPE";
				}
			}
		}
	}

}
