/*
 * Created on 2005. 7. 22
 */
package pluto.dbutil;

import java.lang.reflect.Method;

import lombok.extern.slf4j.Slf4j;

/**
 * @author 이상근
 */
@Slf4j
public class DBUtil {
	public synchronized static final void close(Object obj) {
		if( obj == null ) {
			return;
		}
		
		Class classObj = obj.getClass();
		Method method = null;
		try {
			method = classObj.getMethod("close", null);
		}
		catch(Throwable thw) {
			log.error("close error", thw);
		}

		try {
			if(method != null) {
				method.invoke(obj, null);
			}
		}
		catch(Throwable thw) {
			// ignore
			log.error("method invoke error", thw);
		}
	}
}
