/*
 * Created on 2005. 7. 22
 */
package pluto.dbutil;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

import lombok.extern.slf4j.Slf4j;

/**
 * @author 이상근
 */
@Slf4j
public class ConnectionFactory {

	static String					loadClassName	= " ";

	public synchronized static final void registDriver(ConnInfo info) throws Exception {
		if( loadClassName.indexOf(info.getDriver()) > 0 ) {
			return;
		}

		Class.forName(info.getDriver());

		loadClassName = loadClassName.concat(" ").concat(info.getDriver());
	}

	public synchronized static final Connection getConnection(ConnInfo info) throws Exception {
		Connection conn = null;
		Statement stmt = null;
		//여기까지 왔다면 위에서 에러가 발생한 것이므로 다시한번 해보구 이때 발생하는 Exception은 그냥 위로 보낸다.
		if( info.getId() == null ) {
			conn = DriverManager.getConnection(info.getUrl());
		}
		else {
			conn = DriverManager.getConnection(info.getUrl(), info.getId(), info.getPasswd());
		}

		try {
			if( info.getInitQuery() != null ) {
				if (log.isDebugEnabled()) {
					log.debug("EXEC INIT QUERY : {}", info.getInitQuery());
				}
				stmt = conn.createStatement();
				stmt.execute(info.getInitQuery());
			}
			if (log.isDebugEnabled()) {
				log.debug("NotPooledConnection ensureOpen #4-3 CHECK STATEMENT OK");
			}
		}
		catch(Exception e) {
			log.error("CONNECTION CHECK QUERY EXEC ERROR", e);
		}
		finally {
			DBUtil.close(stmt);
		}
		
		return conn;
	}
}
