/*
 * Created on 2005. 7. 22
 */
package pluto.dbutil;

/**
 * @author 이상근
 */
public class CharConvertor {
	String	base;

	String	in;

	String	out;

	boolean	inConvertSkip	= false;

	boolean	outConvertSkip	= false;

	public CharConvertor(String base, String in, String out) {
		this.base = base;
		this.in = in;
		this.out = out;

		if( this.base == null ) {
			return;
		}

		inConvertSkip = this.in == null ? true : this.base.equalsIgnoreCase(this.in);
		outConvertSkip = this.out == null ? true : this.base.equalsIgnoreCase(this.out);
	}
	
	/**
	 * 데이터 베이스로 String 전송할때 케릭터셋 변환
	 * 
	 * @param src
	 *            변환할 String
	 * @return 변환된 String
	 */
	public String encode(String src) {
		if( src == null )
			return "";

		if( this.inConvertSkip )
			return src;

		try {
			return new String(src.getBytes(this.base), this.in);
		}
		catch(Exception e) {
			return src;
		}
	}

	/**
	 * 데이터 베이스로부터 String 전송 받을때 케릭터셋 변환
	 * 
	 * @param src
	 *            변환할 String
	 * @return 변환된 String
	 */
	public String decode(String src) {
		if( src == null )
			return "";

		if( this.outConvertSkip )
			return src;

		try {
			return new String(src.getBytes(this.out), this.base);
		}
		catch(Exception e) {
			return src;
		}
	}
}
