/*
 * eMsStatement.java
 *
 * Created on 2004년 2월 21일 (토), 오후 2:29
 */

package pluto.db;

import java.sql.ResultSet;

import lombok.extern.slf4j.Slf4j;
import pluto.util.StringConvertUtil;

/**
 * 
 * @author Administrator
 */
@Slf4j
public class eMsStatement implements eMsStatementInterface {
	

	// 5.0엔진에서 없는 부분이어서 DataLoad 구현하면서 추가함. kckim 2005Sep01
	public static final void releaseStmt(eMsStatement stmt) {
		if( stmt == null ) {
			return;
		} else {
			try {
				stmt.close();
			} catch(Exception e) {
				log.error(e.getMessage());
			}
		}
	}

	private java.sql.Statement	stmt			= null;

	private eMsConnection		EMS_CONNECTION	= null;

	/** Creates a new instance of eMsStatement */
	protected eMsStatement() {
		// empty
	}

	public void connectTo(eMsConnection conn) throws java.sql.SQLException {
		if( stmt != null ) {
			try {
				stmt.close();
			}
			catch(Exception e) {
				log.error(e.getMessage());
			}
		}
		EMS_CONNECTION = conn;
		stmt = EMS_CONNECTION.createInnerStatement();
	}

	public void close() {
		if( stmt != null ) {
			try {
				stmt.close();
			}
			catch(Exception e) {
				log.error(e.getMessage());
			}
		}
	}

	public boolean check(String query) {
		if( stmt == null ) {
			return false;
		}
		ResultSet rs = null;
		try {
			rs = this.stmt.executeQuery(query);
			rs.next();
		}
		catch(Exception e) {
			return false;
		}
		finally {
			try {
				if(rs != null)
					rs.close();
			}
			catch(Exception e) {
				log.error(e.getMessage());
			}
		}

		return true;
	}

	public int executeUpdate(String query, Object info, String start, String end) throws Exception {
		return executeUpdate(query, info, start, end, 600);
	}

	public int executeUpdate(String query, Object info, String start, String end, int sec) throws Exception {
		StringBuffer buffer = null;
		try {
			buffer = new StringBuffer(512);
			StringConvertUtil.ConvertString(buffer, query, info, start, end, true, false);
			return executeUpdate(buffer.toString(), sec);
		}
		finally {
			buffer = null;
		}
	}

	public int executeUpdate(String query) throws java.sql.SQLException {
		return executeUpdate(query, 600);
	}

	public int executeUpdate(String query, int sec) throws java.sql.SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(sec);
			return stmt.executeUpdate(EMS_CONNECTION.encode(query));
		}
		catch(java.sql.SQLException e) {
			log.error("EXEC ERROR", query);
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public eMsResultSet executeQuery(String query, Object info, String start, String end) throws Exception {
		return executeQuery(query, info, start, end, 600);
	}

	public eMsResultSet executeQuery(String query, Object info, String start, String end, int sec) throws Exception {
		StringBuffer buffer = null;
		try {
			buffer = new StringBuffer(1024);
			StringConvertUtil.ConvertString(buffer, query, info, start, end, true, false);
			return executeQuery(buffer.toString(), sec);
		}
		finally {
			buffer = null;
		}
		//return executeQuery( StringUtil.ConvertQueryString( query , info ,
		// start , end ) , sec );
	}

	public eMsResultSet executeQuery(String query) throws java.sql.SQLException {
		return executeQuery(query, 600);
	}
	
	public eMsResultSet executeQuery(String query, String dbType) throws java.sql.SQLException {
		return executeQuery(query, dbType, 600);
	}
	
	public eMsResultSet executeQuery(String query, String dbType,int sec) throws java.sql.SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(sec);
			return new eMsResultSet(EMS_CONNECTION, stmt.executeQuery(EMS_CONNECTION.encode(query)), dbType);
		}
		catch(java.sql.SQLException e) {
			log.error("EXEC ERROR", query);
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public eMsResultSet executeQuery(String query, int sec) throws java.sql.SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(sec);
			return new eMsResultSet(EMS_CONNECTION, stmt.executeQuery(EMS_CONNECTION.encode(query)));
		}
		catch(java.sql.SQLException e) {
			log.error("EXEC ERROR", query);
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public boolean checkResultTargetQuery(String query, int sec) throws java.sql.SQLException {
		ResultSet tmprs = null;
		try {
			EMS_CONNECTION.setIdleLimitTime(sec);
			if (log.isDebugEnabled()) 
				log.debug("rs check exec=>" + query.substring(0, query.length() > 30 ? 30 : query.length()));
			tmprs = stmt.executeQuery(EMS_CONNECTION.encode(query));

			if( tmprs.next() ) {
				return true;
			}

			return false;
		}
		catch(java.sql.SQLException e) {
			log.error("SQL EXEC ERROR", query);
			throw e;
		}
		finally {
			if( tmprs != null ) {
				try {
					tmprs.close();
				}
				catch(Exception e) {
					//e.printStackTrace();
					log.error(e.getMessage());
				}
			}
			EMS_CONNECTION.releaseIdleLimitTime();
			if (log.isDebugEnabled()) 
				log.debug("exec end");
		}
	}

	////
	public boolean execute(String query, Object info, String start, String end) throws Exception {
		return execute(query, info, start, end, 600);
	}

	public boolean execute(String query, Object info, String start, String end, int sec) throws Exception {
		return execute(StringConvertUtil.ConvertString(query, info, start, end, true, false), sec);
	}

	public boolean execute(String query) throws java.sql.SQLException {
		return execute(query, 600);
	}

	public boolean execute(String query, int sec) throws java.sql.SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(sec);
			return stmt.execute(EMS_CONNECTION.encode(query));
		}
		catch(java.sql.SQLException e) {
			log.error("EXEC ERROR", query);
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public eMsResultSet getResultSet() throws java.sql.SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(600);
			return new eMsResultSet(EMS_CONNECTION, stmt.getResultSet());
		}
		catch(java.sql.SQLException e) {
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public int getUpdateCount() throws java.sql.SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(600);
			return stmt.getUpdateCount();
		}
		catch(java.sql.SQLException e) {
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}
	//for 대용량 타게팅처리
	public void setFetchSize(int rows) throws java.sql.SQLException {
		stmt.setFetchSize(rows);
	}
}
