/*
 * eMsResultSet.java
 *
 * Created on 2004년 2월 23일 (월), 오후 3:29
 */
package pluto.db;

import java.io.InputStream;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Map;

import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsFileWriter;
import pluto.lang.ByteArrayContainer;
import pluto.lang.CharArrayContainer;
import lombok.extern.slf4j.Slf4j;
import pluto.util.convert.DelimConvertor;
import pluto.lang.eMsLocale;

/**
 * 
 * @author Administrator
 */
@Slf4j
public class eMsResultSet {

	private eMsConnection			EMS_CONNECTION	= null;

	private ResultSet				rs				= null;

	private ResultSetMetaData		rsmt			= null;

	private int						colcount		= -1;

	private String					HEADER_MAP		= null;

	//private StringBuffer __INNER_STRING_BUFFER__ = null;
	/** Creates a new instance of eMsResultSet */
	public eMsResultSet(eMsConnection conn, ResultSet result) throws SQLException {
		this.EMS_CONNECTION = conn;
		this.rs = result;
		this.rsmt = this.rs.getMetaData();
		this.colcount = this.rsmt.getColumnCount();

		StringBuffer buffer = null;

		try {
			buffer = new StringBuffer(256);
			buffer.setLength(0);
			for (int i = 1; i <= colcount; i++) {
				if( "mysql".equals(eMsLocale.DB_TYPE) ){					
					buffer.append(rsmt.getColumnLabel(i).toUpperCase());
				}else{					
					buffer.append(rsmt.getColumnName(i).toUpperCase());
				}				
				buffer.append("|");
			}

			/**
			 * 마지막 구분자를 지우고
			 */
			buffer.setLength(buffer.length() - 1);

			HEADER_MAP = buffer.toString();
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			buffer = null;
		}
	}
	
	public eMsResultSet(eMsConnection conn, ResultSet result, String dbType) throws SQLException {
		this.EMS_CONNECTION = conn;
		this.rs = result;
		this.rsmt = this.rs.getMetaData();
		this.colcount = this.rsmt.getColumnCount();

		StringBuffer buffer = null;

		try {
			buffer = new StringBuffer(256);
			buffer.setLength(0);
			for (int i = 1; i <= colcount; i++) {
				if( "mysql".equals(dbType) ){					
					buffer.append(rsmt.getColumnLabel(i).toUpperCase());
				}else{					
					buffer.append(rsmt.getColumnName(i).toUpperCase());
				}				
				buffer.append("|");
			}

			/**
			 * 마지막 구분자를 지우고
			 */
			buffer.setLength(buffer.length() - 1);

			HEADER_MAP = buffer.toString();
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			buffer = null;
		}
	}

	// 5.0에는 없어서 이 함수를 추가함. kckim 2005Sep01
	public ResultSet getResultSet() {
		return this.rs;
	}

	public String getHeaderString() {
		return this.HEADER_MAP;
	}

	public ResultSetMetaData getMetaData() throws SQLException {
		return this.rsmt;
	}

	public int getColumnCount() {
		return this.colcount;
	}

	public final String getIN_CHARSET() {
		return this.EMS_CONNECTION.getIN_CHARSET();
	}

	public final String getOUT_CHARSET() {
		return this.EMS_CONNECTION.getOUT_CHARSET();
	}

	public final String getBASE_CHARSET() {
		return this.EMS_CONNECTION.getBASE_CHARSET();
	}

	/**
	 * try{ EMS_CONNECTION.setIdleLimitTime( 600 ); } catch( SQLException e ){
	 * throw e; } finally{ EMS_CONNECTION.releaseIdleLimitTime(); }
	 */
	public boolean next() throws SQLException {
		try {
			EMS_CONNECTION.setIdleLimitTime(600);
			return this.rs.next();
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public void close() {
		try {
			this.rs.close();
		}
		catch(Exception e) {
			// empty
		}
	}

	public String getString(int idx) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return EMS_CONNECTION.decode(this.rs.getString(idx));
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public String getString(String name) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );

			return EMS_CONNECTION.decode(this.rs.getString(name));
		}
		catch(SQLException e) {
			log.error(e.getMessage());
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public byte[] getStringAsByteArray(int idx) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return EMS_CONNECTION.decodeByteArray(this.rs.getString(idx));
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public byte[] getStringAsByteArray(String name) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return EMS_CONNECTION.decodeByteArray(this.rs.getString(name));
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public int getInt(int idx) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return this.rs.getInt(idx);
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public int getInt(String name) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return this.rs.getInt(name);
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}
	
	public Timestamp getTimestamp(int idx) throws SQLException {
		try {
			
			return this.rs.getTimestamp(idx);
		} catch (SQLException e) {
			// TODO: handle exception
			throw e;
		}finally{
			
		}
	}

	public InputStream getBinaryStream(int idx) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return this.rs.getBinaryStream(idx);
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public InputStream getBinaryStream(String name) throws SQLException {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return this.rs.getBinaryStream(name);
		}
		catch(SQLException e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public String getBinaryStreamAsString(int idx) throws Exception {
		return getBinaryStreamAsString(idx, null);
	}

	public String getBinaryStreamAsString(int idx, String charset) throws Exception {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return ConvertBinaryStreamToString(this.rs.getBinaryStream(idx), charset);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	public String getBinaryStreamAsString(String name) throws Exception {
		return getBinaryStreamAsString(name, null);
	}

	public String getBinaryStreamAsString(String name, String charset) throws Exception {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			return ConvertBinaryStreamToString(this.rs.getBinaryStream(name), charset);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	protected final String ConvertBinaryStreamToString(InputStream in, String charset) throws Exception {
		if( in == null )
			return "";
		eMsByteArrayOutputStream __BUFFER__ = null;

		byte[] buffer = null;

		try {
			__BUFFER__ = eMsByteArrayOutputStream.getInstance();
			//받아온 버퍼를 청소한다.
			__BUFFER__.flush();
			__BUFFER__.reset();

			buffer = ByteArrayContainer.getInstance();

			while (true) {
				int bytes = in.read(buffer);
				if( bytes < 0 )
					break;

				__BUFFER__.write(buffer, 0, bytes);
			}

			__BUFFER__.flush();

			return __BUFFER__.toString(charset == null ? EMS_CONNECTION.getOUT_CHARSET() : charset);
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				in.close();
			}
			catch(Exception e) {
				// empty
			}
			ByteArrayContainer.recycleInstance(buffer);
			eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
		}
	}

	public String getCharStreamAsString(int idx) throws Exception {
		try {
			//EMS_CONNECTION.setIdleLimitTime( 600 );
			switch (this.rsmt.getColumnType(idx)) {
				case Types.CLOB:
				case Types.LONGVARCHAR: {
					if (log.isDebugEnabled()) {
						log.debug("======= " + idx + " ==========");
						log.debug("CLOB");
					}
					return ConvertCharStreamToString(this.rs.getCharacterStream(idx));
				}

				case Types.BLOB: {
					if (log.isDebugEnabled()) {
						log.debug("======= " + idx + " ==========");
						log.debug("BLOB");
					}
					return ConvertBinaryStreamToString(this.rs.getBinaryStream(idx));
				}

				default: {
					if (log.isDebugEnabled()) {
						log.debug("======= " + idx + " ==========");
						log.debug("DEFAULT STRING");
					}
					return EMS_CONNECTION.decode(this.rs.getString(idx));
				}
			}

		}
		catch(Exception e) {
			throw e;
		}
		finally {
			//EMS_CONNECTION.releaseIdleLimitTime();
		}
	}

	//
	//	public String getCharStreamAsString(String name) throws Exception {
	//		try {
	//			//EMS_CONNECTION.setIdleLimitTime( 600 );
	//			return ConvertCharStreamToString(this.rs.getCharacterStream(name));
	//		}
	//		catch(Exception e) {
	//			throw e;
	//		}
	//		finally {
	//			//EMS_CONNECTION.releaseIdleLimitTime();
	//		}
	//	}

	protected final String ConvertBinaryStreamToString(InputStream in) throws Exception {
		if( in == null )
			return "";

		eMsByteArrayOutputStream __BUFFER__ = null;

		byte[] buffer = null;

		try {
			__BUFFER__ = eMsByteArrayOutputStream.getInstance();
			buffer = ByteArrayContainer.getInstance();

			while (true) {
				int bytes = in.read(buffer);
				if( bytes < 0 )
					break;

				__BUFFER__.write(buffer, 0, bytes);
			}

			//return __BUFFER__.toString( EMS_CONNECTION.getOUT_CHARSET() );
			return __BUFFER__.toString(EMS_CONNECTION.getIN_CHARSET());
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				in.close();
			}
			catch(Exception e) {
				// empty
			}
			ByteArrayContainer.recycleInstance(buffer);
			eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
		}
	}

	protected final String ConvertCharStreamToString(Reader in) throws Exception {
		if( in == null )
			return "";

		StringBuffer __BUFFER__ = null;

		char[] buffer = null;

		try {
			__BUFFER__ = new StringBuffer(256);
			//받아온 버퍼를 청소한다.
			__BUFFER__.setLength(0);

			buffer = CharArrayContainer.getInstance();

			while (true) {
				int bytes = in.read(buffer);
				if( bytes < 0 )
					break;

				__BUFFER__.append(buffer, 0, bytes);
			}

			//return __BUFFER__.toString( EMS_CONNECTION.getOUT_CHARSET() );
			return EMS_CONNECTION.decode(__BUFFER__.toString());
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				in.close();
			}
			catch(Exception e) {
				// empty
			}
			CharArrayContainer.recycleInstance(buffer);
			__BUFFER__ = null;
		}
	}

	public synchronized void putToMap(Map data, boolean attach_full) throws Exception {
		
		StringBuffer buffer = null;
		
		try {
			if( attach_full ) {
				buffer = new StringBuffer(1024);
				buffer.setLength(0);
			}

			for (int i = 1; i <= colcount; i++) {
				if (log.isDebugEnabled()) {
					log.debug("source:" + rs.getString(i));
					log.debug("target:" + this.EMS_CONNECTION.decode(rs.getString(i)));
				}
				
				if( "mysql".equals(eMsLocale.DB_TYPE) ){					
					data.put(rsmt.getColumnLabel(i).toUpperCase(), this.EMS_CONNECTION.decode(rs.getString(i)));
				}else{					
					data.put(rsmt.getColumnName(i).toUpperCase(), this.EMS_CONNECTION.decode(rs.getString(i)));
				}				

				if( attach_full ) {
					DelimConvertor.encodeToBuffer(buffer, this.EMS_CONNECTION.decode(rs.getString(i)));
					//__INNER_STRING_BUFFER__.append( DelimConvertor.encode_(
					// this.EMS_CONNECTION.decode( rs.getString( i ) ) ) );
					buffer.append("|");
				}
			}

			/**
			 * 마지막 구분자를 지우고
			 */
			if( attach_full ) {
				buffer.setLength(buffer.length() - 1);
				data.put("TOTAL_SPOOL_LINE", buffer.toString());
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			if( attach_full )
				buffer = null;
		}
	}
	
	public synchronized void putToMap(Map data, boolean attach_full, String dbType) throws Exception {
		
		StringBuffer buffer = null;
		
		try {
			if( attach_full ) {
				buffer = new StringBuffer(1024);
				buffer.setLength(0);
			}

			for (int i = 1; i <= colcount; i++) {
				if (log.isDebugEnabled()) {
					log.debug("source:" + rs.getString(i));
					log.debug("target:" + this.EMS_CONNECTION.decode(rs.getString(i)));
				}
				
				if( "mysql".equals(dbType) ){					
					data.put(rsmt.getColumnLabel(i).toUpperCase(), this.EMS_CONNECTION.decode(rs.getString(i)));
				}else{					
					data.put(rsmt.getColumnName(i).toUpperCase(), this.EMS_CONNECTION.decode(rs.getString(i)));
				}				

				if( attach_full ) {
					DelimConvertor.encodeToBuffer(buffer, this.EMS_CONNECTION.decode(rs.getString(i)));
					//__INNER_STRING_BUFFER__.append( DelimConvertor.encode_(
					// this.EMS_CONNECTION.decode( rs.getString( i ) ) ) );
					buffer.append("|");
				}
			}

			/**
			 * 마지막 구분자를 지우고
			 */
			if( attach_full ) {
				buffer.setLength(buffer.length() - 1);
				data.put("TOTAL_SPOOL_LINE", buffer.toString());
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			if( attach_full )
				buffer = null;
		}
	}

	public synchronized void putToMapAndStringBuffer(StringBuffer __INNER_STRING_BUFFER__, Map data) throws Exception {
		for (int i = 1; i <= colcount; i++) {

			if( "mysql".equals(eMsLocale.DB_TYPE) ){					
				data.put(rsmt.getColumnLabel(i).toUpperCase(), this.EMS_CONNECTION.decode(rs.getString(i)));
			}else{					
				data.put(rsmt.getColumnName(i).toUpperCase(), this.EMS_CONNECTION.decode(rs.getString(i)));
			}				
			
			DelimConvertor.encodeToBuffer(__INNER_STRING_BUFFER__, this.EMS_CONNECTION.decode(rs.getString(i)));
			//__INNER_STRING_BUFFER__.append( DelimConvertor.encode_(
			// this.EMS_CONNECTION.decode( rs.getString( i ) ) ) );
			__INNER_STRING_BUFFER__.append("|");
		}

		/**
		 * 마지막 구분자를 지우고
		 */
		__INNER_STRING_BUFFER__.setLength(__INNER_STRING_BUFFER__.length() - 1);
	}

	public synchronized void putToString(StringBuffer data) throws Exception {
		try {
			for (int i = 1; i <= colcount; i++) {
				data.append("[");

				if( "mysql".equals(eMsLocale.DB_TYPE) ){					
					data.append(rsmt.getColumnLabel(i).toUpperCase());
				}else{					
					data.append(rsmt.getColumnName(i).toUpperCase());
				}				
				
				data.append("|");
				data.append(this.EMS_CONNECTION.decode(rs.getString(i)));
				data.append("]");
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			// empty
		}
	}

	public synchronized void putToWriter(eMsFileWriter out) throws Exception {
		putToWriter(out, "\t", false);
	}

	public synchronized void putToWriter(eMsFileWriter out, String delim) throws Exception {
		putToWriter(out, delim, false);
	}

	public synchronized void putToWriter(eMsFileWriter out, String delim, boolean addTT) throws Exception {
		if( addTT )
			out.write("\"");
		out.write(DelimConvertor.encode(getString(1)));
		if( addTT )
			out.write("\"");
		for (int i = 2; i <= colcount; i++) {
			out.write(delim);
			if( addTT )
				out.write("\"");
			out.write(DelimConvertor.encode(getString(i)));
			if( addTT )
				out.write("\"");
		}
		out.println();
	}
}
