/*
 * ConnectionPoolImpl.java
 *
 * Created on 2003년 10월 28일 (화), 오전 9:13
 */

package pluto.db;

import java.util.Properties;
/**
 *
 * @author  Administrator
 */
public interface ConnectionPoolImpl {
	
	/** Connection이 생성되면서 invoke된다.<br>
	 * 초기화 로직을 삽입하면 되며 각 Instance별로 실행된다.
	 * @param prop 초기화 파라미터
	 */
	public void inner_init( Properties prop ) throws Exception;
	
	/** EMS내부적으로 사용하는 Connection을 반환한다.
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 */
	public eMsConnection get() throws Exception;
	
	/** 지정된 ConnectInfo의 Connection을 Default 이름으로 생성하여 반환한다.
	 * @param info 연결 정보
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 */
	public eMsConnection get( ConnectInfo info ) throws Exception;
}
