/*
 * ConnectionPool.java
 *
 * Created on 2003년 3월 12일 수, 오전 11:50
 */

package pluto.db;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
/** DB Connection을 관리한다.
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public class ConnectionPool {
	
	
	//private static Class TargetClass = null;
	
	private static ConnectionPoolImpl innerConnectionPool = null;
	
	/** 기본적인 eMsConnection implement Class이름
	 */
	public static final String DEFAULT_CLASS_NAME = "pluto.common.db.DirectConnectionPool";
	
	/** Creates new ConnectionPool
	 */
	protected ConnectionPool() {
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** 초기화한다.<br>
	 * 일단 eMsConnection.init( Object )를 invoke한다.<br>
	 * pool.class : 커넥션 생성/Recycling 을 구현한 ConnectionPool Class<br>
	 * @param tmp 초기화 파라미터
	 * @throws Exception 초기화에러
	 * @see kr.co.amail.db.eMsConnection#init( Object )
	 */
	public synchronized static void init(Object tmp) throws Exception {
		Properties prop = (Properties)tmp;
		
		/**eMsConnection을 초기화 한다.
		 */
		eMsConnection.init( tmp );
		
		String class_name = prop.getProperty( "pool.class" , ConnectionPool.DEFAULT_CLASS_NAME );
		
		innerConnectionPool = ( ConnectionPoolImpl )( Class.forName( class_name ).newInstance() );
		innerConnectionPool.inner_init( prop );
	}
	
	/** EMS내부적으로 사용하는 Connection을 반환한다.
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 * @see kr.co.amail.db.ConnectionPool#get()
	 */
	public synchronized static eMsConnection getConnection() throws Exception {
		return innerConnectionPool.get();
	}
	
	/** 지정된 ConnectInfo의 Connection을 Default 이름으로 생성하여 반환한다.
	 * @param info 연결 정보
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 * @see kr.co.amail.db.ConnectionPool#get( ConnectInfo )
	 */
	public synchronized static eMsConnection getConnection( ConnectInfo info ) throws Exception {
		if( innerConnectionPool == null ) {
			innerConnectionPool = ( ConnectionPoolImpl )( Class.forName( ConnectionPool.DEFAULT_CLASS_NAME ).newInstance() );
		}
		return innerConnectionPool.get(info);
	}
}
