/*
 * ConnectInfo.java
 *
 * Created on 2003년 3월 11일 화, 오후 1:28
 */

package pluto.db;

import java.io.Serializable;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;

/**
 * 데이터 베이스 접속정보 / 케릭터셋정보 / 패치시 NULL 처리 등의 정보를 포함
 * 
 * @author Administrator
 * @version
 */
@Slf4j
public class ConnectInfo implements Cloneable, Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6948470693231114524L;

	public static final String	EMS_QUERY_DELIM			= "#ems_sql_sep#";

	public static final int		SIZE_OF_EMS_QUERY_DELIM	= EMS_QUERY_DELIM.length();

	/**
	 * Holds value of property DB_URL.
	 */
	private String				DB_URL;

	/** Holds value of property DB_UID. */
	private String				DB_UID;

	/** Holds value of property DB_PASS. */
	private String				DB_PASS;

	/** Holds value of property QUERY. */
	private String				QUERY;

	private String				QUERY_TYPE;
	
	private String				QUERY_SEQ;
	
	/** Holds value of property DB_NAME. */
	private String				DB_NAME;

	/** Holds value of property APPEND_NULL. */
	private boolean				APPEND_NULL				= false;

	/** Holds value of property DB_ID. */
	private String				DB_ID;

	/** Holds value of property DB_INIT_QUERY. */
	private String				DB_INIT_QUERY;

	/** Holds value of property DB_BASE_CHARSET. */
	private String				DB_BASE_CHARSET;

	/** Holds value of property DB_OUT_CHARSET. */
	private String				DB_OUT_CHARSET;

	/** Holds value of property DB_CHARSET. */
	private String				DB_IN_CHARSET;

	/** Holds value of property DRIVER. */
	private String				DRIVER;

	private String				ENCRYPT_YN;
	
	/**
	 * Creates new QueryInfo Instance
	 */
	public ConnectInfo() {
		// empty
	}

	/**
	 * Getter for property 데이터 베이스 접속 URL.
	 * 
	 * @return Value of property 데이터 베이스 접속 URL.
	 */
	public String getDB_URL() {
		return DB_URL;
	}

	/**
	 * Setter for property 데이터 베이스 접속 URL.
	 * 
	 * @param DB_URL
	 *            New value of property 데이터 베이스 접속 URL.
	 */
	public void setDB_URL(String DB_URL) {
		this.DB_URL = DB_URL;
	}

	/**
	 * Getter for property 데이터 베이스 접속 ID.
	 * 
	 * @return Value of property 데이터 베이스 접속 ID.
	 */
	public String getDB_UID() {
		return DB_UID;
	}

	/**
	 * Setter for property 데이터 베이스 접속 ID.
	 * 
	 * @param DB_UID
	 *            New value of property 데이터 베이스 접속 ID.
	 */
	public void setDB_UID(String DB_UID) {
		this.DB_UID = DB_UID;
	}

	/**
	 * Getter for property 데이터 베이스 접속 PassWord.
	 * 
	 * @return Value of property 데이터 베이스 접속 PassWord.
	 */
	public String getDB_PASS() {
		return DB_PASS;
	}

	/**
	 * Setter for property 데이터 베이스 접속 PassWord.
	 * 
	 * @param DB_PASS
	 *            New value of property 데이터 베이스 접속 PassWord.
	 */
	public void setDB_PASS(String DB_PASS) {
		this.DB_PASS = DB_PASS;
	}

	/**
	 * Getter for property 데이터 베이스 실행 Query.
	 * 
	 * @return Value of property 데이터 베이스 실행 Query.
	 */
	public String getQUERY() {
		return QUERY;
	}

	/**
	 * Setter for property 데이터 베이스 실행 Query.
	 * 
	 * @param QUERY
	 *            New value of property 데이터 베이스 실행 Query.
	 */
	public void setQUERY(String QUERY) {
		if( QUERY == null )
			return;

		int idx = QUERY.indexOf(EMS_QUERY_DELIM);

		if( idx > 0 ) {
			this.QUERY = QUERY.substring(0, idx);
			this.CHECK_QUERY = QUERY.substring(idx + SIZE_OF_EMS_QUERY_DELIM);
		}
		else {
			this.QUERY = QUERY;
		}
	}

	/**
	 * Getter for property 데이터 베이스 케릭터셋.
	 * 
	 * @return Value of property 데이터 베이스 케릭터셋.
	 */
	public String getDB_IN_CHARSET() {
		return DB_IN_CHARSET == null ? eMsLocale.CHAR_SET : DB_IN_CHARSET;
	}

	/**
	 * Setter for property 데이터 베이스 케릭터셋.
	 * 
	 * @param DB_IN_CHARSET
	 *            New value of property 데이터 베이스 케릭터셋.
	 */
	public void setDB_IN_CHARSET(String DB_IN_CHARSET) {
		this.DB_IN_CHARSET = DB_IN_CHARSET;
	}

	/**
	 * Getter for property 데이터 베이스 이름.
	 * 
	 * @return Value of property 데이터 베이스 이름.
	 */
	public String getDB_NAME() {
		return DB_NAME;
	}

	/**
	 * Setter for property 데이터 베이스 이름.
	 * 
	 * @param DB_NAME
	 *            New value of property 데이터 베이스 이름.
	 */
	public void setDB_NAME(String DB_NAME) {
		this.DB_NAME = DB_NAME;
	}

	/**
	 * 동일한 QueryInfo의 복사본을 반환한다. <br>
	 * 동일 레퍼런스를 가지는 것이 아니라 같은 정보를 가진 Instance를 반환
	 * 
	 * @throws Exception
	 *             메모리 할당을 받지 못하거나 <br>
	 *             기타에러시
	 * @return 복사본
	 */
	public ConnectInfo getClone() throws Exception {
		return (ConnectInfo) clone();
	}

	/**
	 * 자동발송에서 사용하는 파라미터로 리스트 생성시에 결과 셋이 없을때 <br>
	 * 리스트에서 제외할지 / 그냥 공백으로 채울지에 대한 설정을 반환
	 * 
	 * @return true : 공백을 채움 <br>
	 *         false : 리스트에서 제외
	 */
	public boolean isAPPEND_NULL() {
		return APPEND_NULL;
	}

	/**
	 * 자동발송에서 사용하는 파라미터로 리스트 생성시에 결과 셋이 없을때 <br>
	 * 리스트에서 제외할지 / 그냥 공백으로 채울지에 대한 설정
	 * 
	 * @param APPEND_NULL
	 *            리스트에서 제외할지( false )<br>
	 *            그냥 공백으로 채울지( true )
	 */
	public void setAPPEND_NULL(boolean APPEND_NULL) {
		this.APPEND_NULL = APPEND_NULL;
	}

	/**
	 * Getter for property QueryInfoManager상의 인식 ID.
	 * 
	 * @return Value of property QueryInfoManager상의 인식 ID.
	 */
	public String getDB_ID() {
		return DB_ID;
	}

	/**
	 * Setter for property QueryInfoManager상의 인식 ID.
	 * 
	 * @param DB_ID
	 *            New value of property QueryInfoManager상의 인식 ID.
	 */
	public void setDB_ID(String DB_ID) {
		this.DB_ID = DB_ID;
	}

	/**
	 * Getter for property 초기 실행 쿼리. <br>
	 * 
	 * <PRE>
	 * 
	 * Connection 연결시 기본실행 쿼리
	 * 
	 * </PRE>
	 * 
	 * @return Value of property 초기 실행 쿼리.
	 */
	public String getDB_INIT_QUERY() {
		return DB_INIT_QUERY;
	}

	/**
	 * Setter for property 초기 실행 쿼리.
	 * 
	 * @param DB_INIT_QUERY
	 *            New value of property 초기 실행 쿼리.
	 */
	public void setDB_INIT_QUERY(String DB_INIT_QUERY) {
		this.DB_INIT_QUERY = DB_INIT_QUERY;
	}

	/**
	 * Getter for property DB_BASE_CHARSET.
	 * 
	 * @return Value of property DB_BASE_CHARSET.
	 */
	public String getDB_BASE_CHARSET() {
		return DB_BASE_CHARSET == null ? eMsLocale.CHAR_SET : DB_BASE_CHARSET;
	}

	/**
	 * Setter for property DB_BASE_CHARSET.
	 * 
	 * @param DB_BASE_CHARSET
	 *            New value of property DB_BASE_CHARSET.
	 */
	public void setDB_BASE_CHARSET(String DB_BASE_CHARSET) {
		this.DB_BASE_CHARSET = DB_BASE_CHARSET;
	}

	/**
	 * Getter for property DB_OUT_CHARSET.
	 * 
	 * @return Value of property DB_OUT_CHARSET.
	 */
	public String getDB_OUT_CHARSET() {
		return DB_OUT_CHARSET == null ? eMsLocale.CHAR_SET : DB_OUT_CHARSET;
	}

	/**
	 * Setter for property DB_OUT_CHARSET.
	 * 
	 * @param DB_OUT_CHARSET
	 *            New value of property DB_OUT_CHARSET.
	 */
	public void setDB_OUT_CHARSET(String DB_OUT_CHARSET) {
		this.DB_OUT_CHARSET = DB_OUT_CHARSET;
	}

	/**
	 * Getter for property DRIVER.
	 * 
	 * @return Value of property DRIVER.
	 */
	public String getDRIVER() {
		return DRIVER;
	}

	/**
	 * Setter for property DRIVER.
	 * 
	 * @param DRIVER
	 *            New value of property DRIVER.
	 */
	public void setDRIVER(String DRIVER) {
		this.DRIVER = DRIVER;
	}

	String			name	= null;

	/** Holds value of property CHECK_QUERY. */
	private String	CHECK_QUERY;

	public String toString() {
		if( name != null )
			return this.name;

		StringBuffer buffer = null;

		try {
			buffer = new StringBuffer(512);
			buffer.append("DRIVER:");
			buffer.append(this.DRIVER);
			buffer.append("\r\n");
			buffer.append("URL:");
			buffer.append(this.DB_URL);
			buffer.append("\r\n");
			buffer.append("ID:");
			buffer.append(this.DB_UID);
			buffer.append("\r\n");
			buffer.append("PASS:");
			buffer.append(this.DB_PASS);
			buffer.append("\r\n");
			buffer.append("BASE:");
			buffer.append(this.DB_BASE_CHARSET);
			buffer.append("\r\n");
			buffer.append("IN:");
			buffer.append(this.DB_IN_CHARSET);
			buffer.append("\r\n");
			buffer.append("OUT:");
			buffer.append(this.DB_OUT_CHARSET);
			buffer.append("\r\n");

			this.name = buffer.toString();
		}
		catch(Exception e) {
			log.error("ConnectInfo", e);
			this.name = "INIT ERROR";
		}
		finally {
			buffer = null;
		}
		return this.name;
	}

	/**
	 * Getter for property CHECK_QUERY.
	 * 
	 * @return Value of property CHECK_QUERY.
	 */
	public String getCHECK_QUERY() {
		return this.CHECK_QUERY;
	}

	public String getQUERY_TYPE() {
		return QUERY_TYPE;
	}

	public void setQUERY_TYPE(String qUERYTYPE) {
		QUERY_TYPE = qUERYTYPE;
	}

	public String getQUERY_SEQ() {
		return QUERY_SEQ;
	}

	public void setQUERY_SEQ(String qUERYSEQ) {
		QUERY_SEQ = qUERYSEQ;
	}

	public String getENCRYPT_YN() {
		return ENCRYPT_YN;
	}

	public void setENCRYPT_YN(String eNCRYPT_YN) {
		ENCRYPT_YN = eNCRYPT_YN;
	}

}
