/*
 * eMsSystem.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:07
 */

package pluto.config;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;

/**
 * 시스템 전체에서 사용하는 파라미터를 관리한다. eMsActivator에서 초기화한다. 아마도 다음 정리된 버젼에서는 사라질 녀석이기도 하다
 * <br>
 * 
 * <B>PARAM </B> 섹션에서 <B>ext </B> 테그의 <B>name </B>과 <B>value </B>로 <br>
 * Property를 설정하고 기타 Class에서는 <br>
 * 
 * <PRE>
 * 
 * String value = eMsSystem.getProperty( "aa" );
 * 
 * </PRE>
 * 
 * 라면 value는 name이 "aa" 인 ext 테그의 값을 반환하게 된다.
 * 
 * @author Administrator
 * @version
 */
public class eMsSystem extends Object {
	private static Properties	__INNER_INFOM__	= null;

	static {
		__INNER_INFOM__ = new Properties();
	}

	/**
	 * 기본생성자
	 */
	public eMsSystem() {
		// empty
	}

	/**
	 * eMsActivator에서 초기화를 위해 호출 하는 부분
	 * 
	 * @param Config
	 *            설정에서 넘어오는 Property
	 * @throws Exception
	 *             에러가 나면
	 */
	public synchronized static void init(Object prop) throws Exception {
		if( prop instanceof String ) {
			String ConfigFilename = (String) prop;
			File ConfigFile = new File(ConfigFilename);
			__INNER_INFOM__.load(new FileInputStream(ConfigFile));
		}
		else if( prop instanceof Map ) {
			__INNER_INFOM__.putAll((Map) prop);
		}
	}

	/**
	 * 외부 Class에서 호출되며 내부 파라미터를 참조한다.
	 * 
	 * @param key
	 *            참조하는 KEY
	 * @return KEY에 해당하는 Property값
	 */
	public static String getProperty(String key) {
		return __INNER_INFOM__.getProperty(key);
	}

	/**
	 * getProperty( String... ) 과 동일하며 만일 값이 정의되지 않았을 경우 <br>
	 * 기본 값을 반환하는 부분이 다르다.
	 * 
	 * @param key
	 *            참조 KEY
	 * @param defaultValue
	 *            KEY가 설정되어 있지 않을 경우의 기본값
	 * @return KEY에 해당하는 Property
	 */
	public static String getProperty(String key, String defaultValue) {
		return __INNER_INFOM__.getProperty(key, defaultValue);
	}

	/**
	 * Property의 setProperty와 동일하게 기능을 하며 기본 설정 파일에서 설정된 <br>
	 * 파라미터 이외에 내부 Class에서 환경변수를 넣을때 사용한다. <br>
	 * 한번 설정되면 엔진이 종료될때 까지 지속된다.
	 * 
	 * @param key
	 *            Property KEY
	 * @param value
	 *            Property VALUE
	 */
	public static void setProperty(String key, String value) {
		__INNER_INFOM__.setProperty(key, value);
	}

	/**
	 * 설정된 모든 Property를 {@link java.io.Properties}형태로 반환한다.
	 * 
	 * @return 설정된 Property
	 */
	public static Properties getAll() {
		return __INNER_INFOM__;
	}
}
