/*
 * SqlManager.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:24
 */

package pluto.config;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import lombok.extern.slf4j.Slf4j;
import pluto.util.PlutoLinkedList;
import pluto.util.StringConvertUtil;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;

/** 쿼리 정보 파일을 관리하며 각 모듈에서 필요로 하는 쿼리를 반환해준다.
 * 초기화는 Activator에서 초기화해준다.
 * @author  Administrator
 * @version
 */
@Slf4j
public class SqlManager {
	
	
	public static final char TAB = '\t';
	public static final char CR = '\r';
	public static final char LF = '\n';
	public static final char BLANK = ' ';
	
	public static String name = "SqlManager";
	
	public static String SERVER_ID = null;
	
	private static Hashtable MAP_OF_QUERY = new Hashtable();
	/** 이름 반환용
	 * @return 이름을 반환한다.
	 */
	public static String getName() {
		return name;
	}
	
	/** Activator에서 호출함
	 * Manager를 초기화한다. <br>
	 * var name="<B>target.file</B>" <B>value</B>="${base}/conf/auto2k_mssql_sql.xml
	 * @param prop 쿼리 정보파일 경로 KEY를 가진 Property
	 * @throws Exception 파일이 없거나 파싱하다 에러나면
	 */
	public synchronized static void init(Object prop) throws Exception {
		Properties tmp = (Properties)prop;
		String filename = tmp.getProperty( "target.file" );
		
		/**서버아이디 설정
		 * 이미 설정이 되어 있으면, 그대로 사용한다.
		 * 다른 모듈에서도 사용되는 부분이 있어서 같은 서버 아이디를 사용하게 한다.
		 */
		if(SERVER_ID == null){
			SERVER_ID = tmp.getProperty( "ems.server.id" , "01" );
		} 
		
		log.info( getName() + " is init from " + filename );
		
		Document sqlDoc = DOMParser.getDocumentFromUrl(filename);
		Element __ROOT = (Element)sqlDoc.getElementsByTagName("QUERY").item(0);
		
		NodeList __PROGRAM_LIST = __ROOT.getElementsByTagName( "PROGRAM" );
		int __PROGRAM_LIST_LENGTH = __PROGRAM_LIST.getLength();
		
		StringBuffer buffer = null;
		
		try{
			buffer = new StringBuffer(1024);
			
			for( int __PROGRAM_INDEX = 0 ; __PROGRAM_INDEX < __PROGRAM_LIST_LENGTH ; __PROGRAM_INDEX++ ) {
				Element __PROGRAM_ELEMENT = (Element)__PROGRAM_LIST.item( __PROGRAM_INDEX );
				String __PROGRAM_NAME = __PROGRAM_ELEMENT.getAttribute("NAME");
				
				/** PROGRAM에 포함된 sql 노드를 점검해 나간다.
				 */
				NodeList __QUERY_LIST = __PROGRAM_ELEMENT.getElementsByTagName( "sql" );
				int __QUERY_LIST_LENGTH = __QUERY_LIST.getLength();
				
				for( int __SQL_INDEX = 0 ; __SQL_INDEX < __QUERY_LIST_LENGTH ; __SQL_INDEX++ ) {
					Element __SQL_ELEMENT = (Element)__QUERY_LIST.item( __SQL_INDEX );
					
					String __SQL_ID = __SQL_ELEMENT.getAttribute("ID");
					
					List __TARGET_QUERY = XMLUtil.getMultiCDATA_SECTION( __SQL_ELEMENT );
					PlutoLinkedList __INSERT_LIST = new PlutoLinkedList();
					for( Iterator iter = __TARGET_QUERY.iterator() ; iter.hasNext() ; ){
						String value = iter.next().toString();
						if( value.trim().length() < 1 ){
							iter.remove();
						}
						else{
							buffer.setLength( 0 );
							StringConvertUtil.ConvertString( buffer , ConvertEscapeCharactor( value.trim() ) , "##SERVER_ID##" , SERVER_ID );
							
							__INSERT_LIST.add( buffer.toString() );
						}
					}
					
					/**프로그램 이름과 SQL 노드의 값을 알았으니 등록한다.
					 */
					if (log.isDebugEnabled())  log.debug( "[" + __PROGRAM_NAME.concat("_").concat( __SQL_ID ) + "] SET" );
					MAP_OF_QUERY.put( __PROGRAM_NAME.concat("_").concat( __SQL_ID ) , __INSERT_LIST  );
				}
			}
		}
		finally{
			buffer = null;
		}
	}
	
	/** 쿼리 정보파일에 기록된 쿼리를 반환한다.
	 * @param Program 쿼리 인덱스 #1
	 * @param ID 쿼리 인덱스 #2
	 * @return 인덱스 #1-#2 에 해당하는 쿼리
	 * 해당사항이 없다면 null을 반환한다.
	 */
	public synchronized static String getQuery( String __PROGRAM_NAME , String __SQL_ID ) {
		Object returnValue = MAP_OF_QUERY.get( __PROGRAM_NAME.concat("_").concat( __SQL_ID ) );
		
		if( returnValue == null ){
			log.error( __PROGRAM_NAME + "|" + __SQL_ID + "NOT IN SQL XML" );
			return null;
		}
		
		List __TARGET_LIST = ( List )returnValue;
		
		if( __TARGET_LIST.size() < 1 ) return "";
		
		return __TARGET_LIST.iterator().next().toString();
	}
	
	/** 쿼리 정보파일에 기록된 쿼리를 반환한다.
	 * @param Program 쿼리 인덱스 #1
	 * @param ID 쿼리 인덱스 #2
	 * @return 인덱스 #1-#2 에 해당하는 쿼리
	 * 해당사항이 없다면 null을 반환한다.
	 */
	public synchronized static List getMultiQuery( String __PROGRAM_NAME , String __SQL_ID ) {
		if (log.isDebugEnabled())  log.debug("search:" + __PROGRAM_NAME.concat("_").concat( __SQL_ID ) );
		
		Object returnValue = MAP_OF_QUERY.get( __PROGRAM_NAME.concat("_").concat( __SQL_ID ) );
		
		if( returnValue == null ){
			log.error( __PROGRAM_NAME + "|" + __SQL_ID , "NOT IN SQL XML" );
			return null;
		}
		
		return ( List )returnValue;
	}
	
	public static String ConvertEscapeCharactor( String src ) throws Exception{
		if( src == null )  return "";
		
		return src.replace( TAB , BLANK ).replace( CR , BLANK ).replace( LF , BLANK );
	}
}
