/*
 * ReportMessageManager.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:23
 */

package pluto.config;

import java.io.FileInputStream;
import java.util.Properties;

import pluto.util.eMsProperties;

/**에러메일 레포트를 할때 메세지를 관리한다.
 * @author  Administrator
 * @version
 */
public class ReportMessageManager {
	/** 메세지 설정을 가진 Property
	 */
	private static Properties __INNER_INFOM__ = null;
	
	/** Property 초기화
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public synchronized static void init( Object  prop ) throws Exception {
		__INNER_INFOM__ = new eMsProperties();
		__INNER_INFOM__.putAll( (Properties)prop );
		String __TARGET_FILE__ = __INNER_INFOM__.getProperty( "info.file");
		
		if( __TARGET_FILE__ == null ) return;
		
		__INNER_INFOM__.load( new FileInputStream( __TARGET_FILE__ ) );
	}
	
	/** 경우에 해당하는 메세지를 출력
	 * @param key Property에 등록된 메세지 key
	 * @return key에 해당하는 메세지
	 */
	public synchronized static String getProperty( String key ) {
		return __INNER_INFOM__.getProperty( key , "NO MESSAGE");
	}
}
