/*
 * CodeAnalizer.java
 *
 * Created on 2003년 3월 5일 수, 오후 9:04
 */

package pluto.config;

import java.io.FileInputStream;
import java.util.Properties;

import pluto.util.StringUtil;

/** 통신시 수신메일서버로 부터 오는 코드를 EMS에러코드로 매핑시킨다.<br>
 * 초기에 코드가 저장된 Property파일을 로드하여 정보를 지정한다.
 * @author  Administrator
 * @version
 */
public class CodeAnalizer extends Object {
	/** 수신 코드와 내부 코드의 매칭테이블을 저장
	 */
	private static Properties __INNER_INFOM__ = null;
	
	/** 코드매핑 테이블이 저장된 Property파일의 경로를 받아 <br>
	 * 내부 Property 파라미터를 초기화한다.<br>
	 * 초기화 설정에서
	 * <B>var</B> name="<B>target.file</B>" value="[파일경로]"<br>
	 * 에 지정된 파일을 읽어 초기화 한다.
	 * @param prop Property파일의 경로
	 * @throws Exception 입력파라미터 오류나 경로가 틀렸을 경우
	 */
	public synchronized static void init(Object prop) throws Exception {
		__INNER_INFOM__ = new Properties();
		__INNER_INFOM__.putAll( (Properties)prop );
		String __TARGET_FILE__ = __INNER_INFOM__.getProperty( "info.file");
		
		if( __TARGET_FILE__ == null ) return;
		
		__INNER_INFOM__.load( new FileInputStream( __TARGET_FILE__ ) );
	}
	
	/** 수신 문자열에서 수신 코드를 분리한다.
	 * @param Response 수신 메세지
	 * @return 수신코드
	 */
	private static final String getHeader(String Response) {
		return  Response.substring(0,3).trim();
	}
	
	/** 실제적으로 SMTP Agent에서 호출하는 부분으로 통신한 도메인의 메세지를 구별한다.
	 * @param Step SMTP 프로토콜 단계를 지정한다.
	 * @param Response 수신서버로 부터 받은 메세지
	 * @param Domain 수신서버 도메인
	 * @return 해당 단계의 메세지의 정의 코드
	 */
	public static final String searchReturnCode(String Step, String Response, String Domain) {
		if( Response.length() < 3 ) {
			return null;
		}
		
		if( Response.charAt(3) == '-' ) {
			return "continue";
		}
		
		String tmpValue = getHeader( Response );
		
		/**코드로 오지않고 메세지로 오면 장애로 처리한다.
		 */
		if( !StringUtil.isPureDigit( tmpValue ) ){
			return "70";
		}
		
		String key = Step + "." + tmpValue + "." + Domain.toLowerCase();
		String ReturnValue = __INNER_INFOM__.getProperty( key );
		
		if( ReturnValue != null ) {
			return ReturnValue;
		}
		
		key = Step + "." + tmpValue + ".default";
		return __INNER_INFOM__.getProperty( key );
	}
}
