/*
 * Created on 2005. 11. 27
 */
package pluto.common.task;

import lombok.extern.slf4j.Slf4j;
import pluto.schedule.Task;

/**
 * @author 이상근
 */
@Slf4j
public class MemoryMonitorTask extends Task {
	protected Runtime __RUNTIME__ = Runtime.getRuntime();

	/** Creates a new instance of MemoryMonitorTask */
	public MemoryMonitorTask() {
		super(TYPE_INTERVAL, 1);
		this.setName("MemoryMonitorTask");
		this.setTaskID("MemoryMonitorTask");
	}

	/**
	 * 실제적인 일을 처리하는 비지니스로직
	 * 
	 * @return true : 성공적인 수행 <br>
	 *         false : 수행 실패
	 */
	public void execute() throws Exception {
		log.debug(String.valueOf(__RUNTIME__.totalMemory()).concat("\t").concat(String.valueOf(this.__RUNTIME__.freeMemory())));
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(getName(), thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
	}

}
