package pluto.common.task;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.reporter.Reporter;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;

@Slf4j
public class HardBounceFilterTask extends pluto.schedule.Task {

	

	private static String	QUERY_SELECT_ERROR_LIST_INFO = null;
	private static Hashtable HT_ERROR_LIST = null;
	


	/**
	 * 구동에 필요한 기본 static 변수의 초기화
	 */
	static {
		try {
			QUERY_SELECT_ERROR_LIST_INFO = SqlManager.getQuery("ERROR_LIST_INFO", "QUERY_SELECT_ERROR_LIST_INFO");
			
			HT_ERROR_LIST = new Hashtable();
		}
		catch(Exception e) {
			log.error("Exception",e);
			System.exit(1);
		}
	}

	protected eMsConnection		EMS_CONNECTION						= null;

	protected eMsStatement		__SELECT_STATEMENT__				= null;


	
	/**
	 * 초기화
	 * ems_targeting_conf.xml 에서 사용한 변수로 초기화 
	 */
	public static void init(Object tmp) throws Exception {
		
	}

	/** Creates a new instance of ScheduleCheckTask */
	public HardBounceFilterTask() {
		// 60초마다 실행
		//super(TYPE_INTERVAL, 60000);
		this.setName("HardBounceFilterTask_at_".concat(Cal.getSerialDate()));
		this.setTaskID("HardBounceFilterTask");
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("HardBounceFilterTask_at_".concat(Cal.getSerialDate()));
		EMS_CONNECTION = ConnectionPool.getConnection();
		__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
		//__TGT_UPDATE_STATEMENT__ = EMS_CONNECTION.createStatement();
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(" Request Connection Error");
		log.error(getName(), thw);

		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		if( !(thw instanceof SQLException) ) {
			Reporter.report("common", getName(), "HardBounceFilterTask.init.err", thw);
		}
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
			EMS_CONNECTION.recycle();
		}
	}

	/**
	 * 처리 
	 */
	public void execute() throws Exception {
		
		eMsResultSet ERR_LIST = null;
		HT_ERROR_LIST.clear();

		try{
			ERR_LIST = __SELECT_STATEMENT__.executeQuery(QUERY_SELECT_ERROR_LIST_INFO);
			while(ERR_LIST.next()){
				Properties LIST = new Properties();
				ERR_LIST.putToMap(LIST, false);
				
				HT_ERROR_LIST.put(CryptoUtil.deEmailAddr(LIST.getProperty("ERR_EMAIL")), CryptoUtil.deEmailAddr(LIST.getProperty("ERR_EMAIL")));
			}
			
		}catch(Exception e){
			log.error("Exception",e);
		}finally{
			if( EMS_CONNECTION != null ) {
				EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
				EMS_CONNECTION.recycle();
			}
		}
	}
	
	/**
	 * 필터링 체크 
	 * @param email
	 * @return
	 */
	public synchronized static boolean checkErrEmail(String email){
		
		boolean b_chk = true;
		
		
		
		Object o_Tmp = HT_ERROR_LIST.get(email);

		if(o_Tmp == null){
			b_chk = false;
		}

		return b_chk;
	}

	
	
}


