/*
 * TimeStampLogChannel.java
 *
 * Created on 2003년 11월 27일 (목), 오후 5:2
 */

package pluto.common.log;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.Element;

import lombok.extern.slf4j.Slf4j;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import pluto.util.Cal;
import pluto.util.xml.XMLUtil;

/**
 * 
 * @author t??
 */
@Slf4j
public class TimeStampLogChannel extends pluto.log.LogChannel {

	protected Date					DATE_INSTANCE		= new Date();

	protected String				BASE_DIRECTORY		= null;

	protected String				FILE_NAME_PREFIX	= null;

	protected String				FILE_NAME_SURFIX	= null;

	protected String				TIME_STAMP			= null;

	protected SimpleDateFormat		TIME_STAMP_INSTANCE	= null;

	protected String				CURRENT_DATE		= "^^";

	protected eMsFileWriter			WRITER_INSTANCE		= null;

	protected String				CURRENT_FILENAME	= "^^";

	protected boolean				CREATE_SUB_DIR		= false;

	protected boolean				SYS_ECHO_FLAG		= false;

	protected boolean				THREAD_ECHO_FLAG	= false;

	protected boolean				TIME_ECHO_FLAG		= false;

	protected long					NEXT_CHECK_TIME		= 0;

	/** Creates a new instance of TimeStampLogChannel */
	public TimeStampLogChannel() {
		this.NEXT_CHECK_TIME = System.currentTimeMillis() - 60 * 60 * 24 * 1000;
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	/**
	 * 초기화
	 */
	protected void setRule(Object info) throws Exception {
		Element LOGGER_ELEMENT = (Element) info;

		this.SYS_ECHO_FLAG = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "SYS-ECHO", "value").equals("true");
		this.THREAD_ECHO_FLAG = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "THREAD-ECHO", "value").equals("true");
		this.TIME_ECHO_FLAG = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "TIME-ECHO", "value").equals("true");

		this.BASE_DIRECTORY = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "DIRECTORY", "value");
		this.CREATE_SUB_DIR = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "DIRECTORY", "subdir").equals("true");
		this.FILE_NAME_PREFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "PREFIX", "value");
		this.FILE_NAME_SURFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "SURFIX", "value");
		this.TIME_STAMP = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "TIMESTAMP", "value");
		this.TIME_STAMP_INSTANCE = new SimpleDateFormat(this.TIME_STAMP);
	}

	/**
	 * 로그를 기록
	 */
	public synchronized void write(String obj) throws Exception {
		try {
			setTargetFile();
			if( TIME_ECHO_FLAG ) {
				String time = Cal.getDate();
				this.WRITER_INSTANCE.write(time);
				this.WRITER_INSTANCE.write("\t");
			}
			if( THREAD_ECHO_FLAG ) {
				this.WRITER_INSTANCE.write("[");
				this.WRITER_INSTANCE.write(Thread.currentThread().getName());
				this.WRITER_INSTANCE.write("]");
			}
			this.WRITER_INSTANCE.println(obj);
		}
		catch(Exception e) {
			log.error("error", e);
		}
	}

	/**
	 * 시간을 체크해서 파일을 toggle한다.
	 */
	protected void setTargetFile() throws Exception {
		if( this.NEXT_CHECK_TIME > System.currentTimeMillis() ) {
			return;
		}

		// 매번 체크하는거 보다는 분당 한번 체크해서 바꾸는 것이 조금은 도움이 될거 같다.
		this.NEXT_CHECK_TIME = System.currentTimeMillis() + 60 * 1000;

		this.DATE_INSTANCE.setTime(System.currentTimeMillis());
		// 바뀔일이 없다면 그냥 지나가기
		if( this.CURRENT_DATE.equals(this.TIME_STAMP_INSTANCE.format(DATE_INSTANCE)) ) {
			return;
		}

		if( this.WRITER_INSTANCE != null ) {
			// 파일 쓰던거를 닫고.
			try {
				this.WRITER_INSTANCE.close();
			}
			catch(Exception e) {
				// do nothing
				//e.printStackTrace();
				log.error(e.getMessage());
			}

			//			CURRENT_FILENAME
		}

		this.CURRENT_DATE = this.TIME_STAMP_INSTANCE.format(DATE_INSTANCE);

		if( this.CREATE_SUB_DIR ) {
			this.CURRENT_FILENAME = FileElement.CheckSubDirectory(this.BASE_DIRECTORY, Cal.getDayDate()) + "/" + this.FILE_NAME_PREFIX
					+ this.CURRENT_DATE + this.FILE_NAME_SURFIX;
		}
		else {
			this.CURRENT_FILENAME = this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + this.CURRENT_DATE + this.FILE_NAME_SURFIX;
		}
		this.WRITER_INSTANCE = new eMsFileWriter(this.CURRENT_FILENAME, true);
	}
}
