/*
 * TargetSelectResultUpdator.java
 *
 * Created on 2004년 7월 20일 (화), 오후 2:18
 */

package pluto.common.log;

import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import pluto.db.eMsResultSet;

/**QUERY_TARGET_CHECK를 실행하여 결과값이 나올 경우에 이 결과를 Log 맵에 세팅하고 그 결과로 
 * QUERY_UPDATE_LIST_RESULT_QUERYS / QUERY_UPDATE_COMMON_RESULT_QUERYS 를 업데이트하는 기능을 한다.
 *
 * @author  EMS
 */
@Slf4j
public class TargetSelectResultUpdator extends LogUpdatorImpl {
	
	
	protected String QUERY_TARGET_CHECK = null;
	
	protected List QUERY_UPDATE_LIST_RESULT_QUERYS = null;
	protected List QUERY_UPDATE_COMMON_RESULT_QUERYS = null;
	
	/** Creates a new instance of TargetSelectResultUpdator */
	public TargetSelectResultUpdator() {
		super();
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {
		eMsResultSet RS = null;
		
		try{
			RS = executeQuery( QUERY_TARGET_CHECK , obj );
			
			if( RS.next() ){
				RS.putToMap( ( Map )obj , false );
			}
			else{
				return "CONDITION FAIL";
			}
		}
		catch( Exception e ){
			log.error(getName(), e);
		}
		finally{
			if( RS != null ) RS.close();
		}
		
		/**업데이트 할 쿼리들의 Iterator
		 */
		if( QUERY_UPDATE_LIST_RESULT_QUERYS != null ){
			executeUpdateList( QUERY_UPDATE_LIST_RESULT_QUERYS , obj );
		}
		
		if( QUERY_UPDATE_COMMON_RESULT_QUERYS != null ){
			executeUpdateList( QUERY_UPDATE_COMMON_RESULT_QUERYS , obj );
		}
		
		return "OK";
	}
	
}
