/*
 * TargetSecondCheckSwitchUpdator.java
 *
 * Created on 2004년 2월 5일 (목), 오전 12:43
 */

package pluto.common.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import pluto.common.bean.PlanBean;
import pluto.common.db.NotPooledConnection;
import pluto.config.SqlManager;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import lombok.extern.slf4j.Slf4j;
import pluto.log.Log;
import pluto.util.StringUtil;
/**
 *
 * @author  
 */
/**
 *
 * @author  
 */
@Slf4j
public class TargetSecondCheckSwitchUpdator extends LogUpdatorImpl {
	
	
	private static CustChannelStat custChannelStat;
	
	protected String QUERY_FIRST_CHECK = null;
	protected String QUERY_FIRST_CHECK_LOG_INSERT = null;
	protected String QUERY_SECOND_CHECK = null;
	
	
	protected List QUERY_UPDATE_FIRST_OK_COMMON_INFO = null;
	protected List QUERY_INSERT_FIRST_OK_LIST_INFO = null;
	
	protected List QUERY_UPDATE_SECOND_OK_COMMON_INFO = null;
	protected List QUERY_UPDATE_SECOND_OK_LIST_INFO = null;
	
	protected List QUERY_UPDATE_FINAL_COMMON_INFO = null;
	protected List QUERY_UPDATE_FINAL_LIST_INFO = null;
	
	protected String QUERY_UPDATE_MEMBER_INFO = null;
	protected List QUERY_INSERT_MEMBER_INFO = null;
	
	
	
	protected String QUERY_FIRST_CHECK_MOBILE = null;
	protected String QUERY_SECOND_CHECK_MOBILE = null;
	
	protected List QUERY_UPDATE_FIRST_OK_COMMON_INFO_MOBILE = null;
	protected List QUERY_UPDATE_FIRST_OK_LIST_INFO_MOBILE = null;
	
	protected List QUERY_UPDATE_SECOND_OK_COMMON_INFO_MOBILE = null;
	protected List QUERY_UPDATE_SECOND_OK_LIST_INFO_MOBILE = null;
	
	protected List QUERY_UPDATE_FINAL_COMMON_INFO_MOBILE = null;
	protected List QUERY_UPDATE_FINAL_LIST_INFO_MOBILE = null;
	
	
	protected String UPDATE_OPEN_LIST = null;
	protected String INSERT_OPEN_LIST = null;	
	protected String UPDATE_CLICK_LIST = null;
	protected String INSERT_CLICK_LIST = null;
	protected String INSERT_OPEN_OPTIMIZ = null;
	protected String INSERT_CLICK_OPTIMIZ = null;
	
	//flow plan data -------------------------------------------------------------------
	private static eMsPreparedStatement PPS_SELECT_FLOW_DATA = null;
	private static eMsPreparedStatement PPS_INSERT_FLOW_DATA = null;
	
	private static String QUERY_SELECT_PLAN_INFO             = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
	private static String QUERY_INSERT_FLOW_DATA             = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");
	//----------------------------------------------------------------------------------
	
	/** Creates a new instance of TargetSecondCheckSwitchUpdator */
	public TargetSecondCheckSwitchUpdator() {
		super();

//2013.09 옵티마이저 고객분석 추가 (강석원)
		custChannelStat = new CustChannelStatImpl(this);
		
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {

		String msg = "";
		Properties SQL_PARAM = (Properties) obj;
		
		// TMS CHANNEL_TYPE 생성~~~~~!!!
		String ListTable = SQL_PARAM.getProperty("LIST_TABLE");
		String clickTable = "";
		boolean autoFlag = false;
		boolean clickFlag = false;
		String channelType = "";
		int clickUpdateCnt = 0;
		int openUpdateCnt = 0;
		
		
		if(ListTable.indexOf("AUTO") > 0){
			autoFlag = true;
		}
		
		if(!SQL_PARAM.getProperty("CID","").equals("") || UPDATE_CLICK_LIST != null){
			clickFlag = true;
		}
		
		//자동메일 
		if(autoFlag){
			channelType = SQL_PARAM.getProperty("LIST_TABLE").substring(9, 11);
			clickTable = "TMS_AUTO_CLICK_LIST_"+ListTable.substring(ListTable.length()-2, ListTable.length());
		// 캠페인 메일
		}else{
			channelType = SQL_PARAM.getProperty("LIST_TABLE").substring(4, 6);
			clickTable = "TMS_CAMP_CLICK_LIST_"+ListTable.substring(ListTable.length()-2, ListTable.length());
		}
		if("O".equals(SQL_PARAM.getProperty("KIND"))){
			SQL_PARAM.setProperty("OPEN_OR_CLICK", "OPEN");
		}else if("C".equals(SQL_PARAM.getProperty("KIND"))){
			SQL_PARAM.setProperty("OPEN_OR_CLICK", "CLICK");
		}
		SQL_PARAM.setProperty("CHANNEL_TYPE",channelType);
		SQL_PARAM.setProperty("CLICK_TABLE", clickTable);
		
		boolean firstFlag = false;
		
		//
		String device = "";
		if(SQL_PARAM.containsKey("MOBILE_CODE")){
			SQL_PARAM.setProperty("DEVICE", "MOBILE");
			device = "MOBILE";
		}else{
			SQL_PARAM.setProperty("DEVICE", "PC");
			device = "PC";
		}
		
		StringBuffer bffr = null;
		//log.debug("QUERY_FIRST_CHECK --> "+StringUtil.ConvertString(bffr,QUERY_FIRST_CHECK, SQL_PARAM));
		
//TODO 2013.07.22
//		OPEN, CLICK TABLE 에 INSERT 하는 것을 막어놓는다. 해당 쿼리가 없음.
//		int count0 = executeUpdate( QUERY_FIRST_CHECK_LOG_INSERT, SQL_PARAM );
///////////////////////////////////////////////////////////////////////////////		
		
		int count = executeUpdate( QUERY_FIRST_CHECK , SQL_PARAM );
		
		if( count > 0 ){		//처음
									
			executeUpdateList( QUERY_UPDATE_FIRST_OK_COMMON_INFO , SQL_PARAM );	//통계테이블 건수업데이트
			
			executeUpdate( INSERT_OPEN_LIST , SQL_PARAM );		//오픈테이블 INSERT
			executeUpdate( INSERT_OPEN_OPTIMIZ , SQL_PARAM );	//옵티마이징 오픈통계 INSERT
			
						
			//click 리스트 인서트 /업데이트
			if(clickFlag){
				executeUpdate( INSERT_CLICK_LIST , SQL_PARAM );
				executeUpdate( INSERT_CLICK_OPTIMIZ , SQL_PARAM );	//옵티마이징 클릭통계 INSERT			
			}
			
			firstFlag = true;
			msg = "1st OK";

		} else {				//중복

			count = executeUpdate( QUERY_SECOND_CHECK , SQL_PARAM );

			if( count > 0 ){
				executeUpdateList( QUERY_UPDATE_SECOND_OK_COMMON_INFO , SQL_PARAM );
				
				openUpdateCnt = executeUpdate(UPDATE_OPEN_LIST , SQL_PARAM );
				
				//click 리스트 인서트 /업데이트
				if(clickFlag){
					clickUpdateCnt = executeUpdate(UPDATE_CLICK_LIST , SQL_PARAM );
				
					if(clickUpdateCnt == 0){
						clickUpdateCnt = executeUpdate(INSERT_CLICK_LIST , SQL_PARAM );
					}
				}
				msg = device+" 2nd OK";
				
			} else {
				executeUpdateList( QUERY_UPDATE_FINAL_LIST_INFO , SQL_PARAM );
				
				//click 리스트 인서트 /업데이트
				if(clickFlag){
					clickUpdateCnt = executeUpdate(UPDATE_CLICK_LIST , SQL_PARAM );
				
					if(clickUpdateCnt == 0){
						clickUpdateCnt = executeUpdate(INSERT_CLICK_LIST , SQL_PARAM );
					}
				}
				
				msg = device+" final OK";
			}
			
		}
		
		// ### auto flow plan ###
		if(firstFlag && autoFlag ){ //오픈과 클릭은 최초 한번만 진행한다.
			String flowResult = insertFlowPlanData( (Properties)SQL_PARAM );
			if(log.isDebugEnabled()){
				log.debug("[flowResult]"+flowResult);
			}
		}else{
			if(log.isDebugEnabled()){
				log.debug("[no flow action] msg :"+msg);
			}
		}
		// ######################
		
		
		return msg;
	}
	
	/*
	[table : PLAN_ACT_LIST]
	
	create table PLAN_ACT_LIST(
			SRC_WORKDAY       varchar(8) NOT NULL, 
			SRC_SEQNO         decimal(9,0) NOT NULL,
			SRC_MEMBER_ID     varchar(20) NOT NULL,
			SRC_MEMBER_ID_SEQ varchar(10) NOT NULL,
			SRC_LIST_TABLE    varchar(100) DEFAULT NULL,
			MSG_TYPE          varchar(3) NOT NULL,
			MSG_TYPE_SEQ      varchar(3) NOT NULL,
			PLAN_STATUS       varchar(2) NOT NULL,
			PLAN_DAY          varchar(5) ,
			PLAN_HOUR         varchar(10) ,
			T_DATE            datetime,  -- 로그 일시
			ACT_DATE          datetime,  -- 작업할 일시
			REG_DATE          datetime,  -- 등록일시
			SEND_FLAG_DATE    datetime   -- 발송 완료시 update
	)
	*/
	/**
	 * 
	 * @param target
	 * @return
	 * @throws Exception 
	 */
	protected String insertFlowPlanData(Object target) throws Exception{
		Properties propLogData = ( Properties )target;
		
		String trKind 	 = propLogData.getProperty( Log.LOG_TR_KIND );
		String postId    = propLogData.getProperty( Log.LOG_MAIL_ID );
		
//		String workday   = propLogData.getProperty( Log.LOG_WORKDAY );
//		String seqNo     = propLogData.getProperty( Log.LOG_SEQNO );
//		String mId       = propLogData.getProperty( Log.LOG_MEMBER_ID );
//		String mIdSeq    = propLogData.getProperty( Log.LOG_MEMBER_ID_SEQ );
//		String listTable = propLogData.getProperty( Log.LOG_LIST_TABLE );
		
		String actType   = "SKIP";
		
		if(trKind.equals("O")){
			actType = "OPEN";
		}else if(trKind.equals("C")){
			actType = "CLICK";
		}else{
			return "SKIP";
		}
		
		//static hashtable에서 post_id에 해당하는 bean을 가져옴
		PlanBean bean = PlanBean.getPlanBean(postId);
		if(bean == null){
			bean = new PlanBean();
			/*
			SELECT B.MSG_TYPE     AS MSG_TYPE,
				   B.MSG_TYPE_SEQ AS MSG_TYPE_SEQ,
				   B.PLAN_DAY     AS PLAN_DAY,
				   B.PLAN_HOUR    AS PLAN_HOUR,
				   B.PLAN_STATUS  AS PLAN_STATUS
			  FROM TMS_AUTO_SCHD_INFO A, 
			       TMS_AUTO_MSG_INFO B
			 WHERE A.WORKDAY = '${WORKDAY}'
			   AND A.SEQNO = '${SEQNO}'
			   AND A.MSG_TYPE = B.PLAN_PARENT_MSG_TYPE
			   AND A.MSG_TYPE_SEQ = B.PLAN_PARENT_MSG_TYPE_SEQ
			   AND B.CHANNEL_TYPE = 'EM' 
			 */
			//preparedStatement를 생성
			if(PPS_SELECT_FLOW_DATA == null){
				PPS_SELECT_FLOW_DATA = EMS_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO,"${","}");
			}
			
			eMsResultSet rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
			
			ArrayList    arrTarget  = new ArrayList();
			
			while(rsFlowData.next()){
				Properties prop = new Properties();
				
				prop.setProperty("MSG_TYPE",    rsFlowData.getString("MSG_TYPE"));
				prop.setProperty("MSG_TYPE_SEQ",rsFlowData.getString("MSG_TYPE_SEQ"));
				prop.setProperty("PLAN_DAY",    rsFlowData.getString("PLAN_DAY"));
				prop.setProperty("PLAN_HOUR",   rsFlowData.getString("PLAN_HOUR"));
				prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
				
				arrTarget.add(prop);
			}
			
			bean.setPostId(postId);
			bean.setArrTarget(arrTarget);
			
			//static hashtable에 저장
			PlanBean.setPlanBean(bean);
		}
		
		//plan 이 아닐경우 skip
		if(!bean.isPlanYn()){
			if(log.isDebugEnabled()){
				log.debug("[SKIP] no Plan");
			}
			return "SKIP";
		}

		ArrayList<Properties> dataList = bean.getArrTarget();
		
		int    dataCnt    = dataList.size();
		String msgType    = "";
		String msgTypeSeq = "";
		String planStatus = "";
		String planDay    = "";
		String planHour   = "";
		
		boolean actFlag   = false;
		
		//insert
		for(int i=0; i< dataCnt; i++){
			Properties propPlanData = dataList.get(i);
			
			msgType    = propPlanData.getProperty("MSG_TYPE");
			msgTypeSeq = propPlanData.getProperty("MSG_TYPE_SEQ");
			planStatus = propPlanData.getProperty("PLAN_STATUS");
			planDay    = propPlanData.getProperty("PLAN_DAY");
			planHour   = propPlanData.getProperty("PLAN_HOUR");
			
			/*
			 * 유효데이터인지 검증
			 */
			if(log.isDebugEnabled()){
				log.debug("[planStatus]"+planStatus+"[actType]"+actType);
			}
			
			if( "O".equals(planStatus)){ //오픈
				if( "OPEN".equals(actType) ){
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:OPEN> OPEN");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:OPEN> SKIP: no OPEN type");
					}
					continue;
				}
			}else if( "C".equals(planStatus)){ //클릭
				if( "CLICK".equals(actType) ){
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:CLICK> CLICK");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:CLICK> SKIP: no CLICK type");
					}
					continue;
				}
			}else{
				if(log.isDebugEnabled()){
					log.debug("[TARGET_AREA]<no Type> SKIP");
				}
				continue;
			}
						
			propLogData.setProperty("MSG_TYPE",     msgType);
			propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
			propLogData.setProperty("PLAN_STATUS",  planStatus);
			propLogData.setProperty("PLAN_DAY",     StringUtil.isNull(planDay)?"0":planDay );
			propLogData.setProperty("PLAN_HOUR",    StringUtil.isNull(planHour)?"0":planHour);

			/*
			INSERT INTO PLAN_ACT_LIST(
				SRC_WORKDAY, SRC_SEQNO, SRC_MEMBER_ID, SRC_MEMBER_ID_SEQ, SRC_LIST_TABLE,
				MSG_TYPE, MSG_TYPE_SEQ,
				PLAN_STATUS, PLAN_DAY, PLAN_HOUR,
				T_DATE, 
				ACT_DATE, 
				REG_DATE )
			VALUES (
				'${WORKDAY}','${SEQNO}','${M_ID}','${M_ID_SEQ}','${LIST_TABLE}',
				'${MSG_TYPE}','${MSG_TYPE_SEQ}',
				'${PLAN_STATUS}','${PLAN_DAY}','${PLAN_HOUR}',
				DATE_FORMAT( '${T_DATE}' , '%Y-%m-%d %H:%i:%S' ),
				DATE_SUB(DATE_SUB(DATE_FORMAT( '${T_DATE}', '%Y-%m-%d %H:%i:%S' ), INTERVAL (-1*${PLAN_DAY}) DAY), INTERVAL (-1*${PLAN_HOUR}) HOUR),
				NOW() )
			 */
			//preparedStatement를 생성
			if(PPS_INSERT_FLOW_DATA == null){
				PPS_INSERT_FLOW_DATA = EMS_CONNECTION.prepareStatement(this.QUERY_INSERT_FLOW_DATA,"${","}");
			}
			
			int cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData);
			if(cnt_insert != 1){
				log.debug("[ERROR] insert fail <FLOW_DATA> "+propLogData.toString());
			}else{
				actFlag = true;
			}
			
		}//end of for
		
		if(!actFlag){
			actType = "no Match";
		}
		
		return actType;
	}
}
