/*
 * CMSOpenUpdator.java
 *
 * Created on 2003년 8월 18일 월, 오후 1:31
 */

package pluto.common.log;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import pluto.common.db.NotPooledConnection;
/**
 *
 * @author  Administrator
 */
@Slf4j
public class TargetCheckSwitchUpdator extends LogUpdatorImpl {
	
	
	protected String QUERY_TARGET_CHECK = null;
	
	protected List QUERY_UPDATE_CHECK_FAIL_COMMON_INFO = null;
	protected List QUERY_UPDATE_CHECK_FAIL_LIST_INFO = null;
	
	protected List QUERY_UPDATE_CHECK_OK_COMMON_INFO = null;
	protected List QUERY_UPDATE_CHECK_OK_LIST_INFO = null;
	
	/** Creates a new instance of CMSOpenUpdator */
	public TargetCheckSwitchUpdator() {
		super();
	}
	
	public String update(Object obj) throws Exception {
		int count = executeUpdate( QUERY_TARGET_CHECK , obj );
		
		/**업데이트 할 쿼리들의 Iterator
		 */
		if( count == 0 ){//UNIQUE
			if (log.isDebugEnabled())  log.debug( "UPDATE COUNT == 0" );
			executeUpdateList( QUERY_UPDATE_CHECK_FAIL_COMMON_INFO , obj );
			executeUpdateList( QUERY_UPDATE_CHECK_FAIL_LIST_INFO , obj );
		}
		else{
			if (log.isDebugEnabled())  log.debug( "UPDATE COUNT > 0" );
			executeUpdateList( QUERY_UPDATE_CHECK_OK_COMMON_INFO , obj );
			executeUpdateList( QUERY_UPDATE_CHECK_OK_LIST_INFO , obj );
		}

		return "OK";
	}
}
