/*
 * StringIndexedLogChannel.java
 *
 * Created on 2004년 10월 13일 (수), 오후 5:34
 */

package pluto.common.log;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.Element;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsSizeIndexedOutputStream;
import pluto.util.xml.XMLUtil;

/**
 * 
 * @author EMS
 */
@Slf4j
public class StringIndexedLogChannel extends pluto.log.LogChannel {

	protected Date							DATE_INSTANCE					= new Date();

	protected String						BASE_DIRECTORY					= null;

	protected String						FILE_NAME_PREFIX				= null;

	protected String						FILE_NAME_SURFIX				= null;

	protected String						TIME_STAMP						= null;

	protected SimpleDateFormat				TIME_STAMP_INSTANCE				= null;

	protected String						CURRENT_DATE					= "^^";

	protected eMsSizeIndexedOutputStream	WRITER_INSTANCE					= null;

	protected long							NEXT_CHECK_TIME					= -1;

	protected String						CURRENT_LOG_FILE_NAME			= null;

	protected String						CURRENT_LOG_FILE_SWITCHED_NAME	= null;

	protected Object						__LOCK__						= new Object();

	/** Creates a new instance of StringIndexedLogChannel */
	public StringIndexedLogChannel() {
		this.NEXT_CHECK_TIME = System.currentTimeMillis() - 60 * 60 * 24 * 1000;
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	/**
	 * 초기화
	 */
	protected void setRule(Object info) throws Exception {
		Element LOGGER_ELEMENT = (Element) info;

		this.BASE_DIRECTORY = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "DIRECTORY", "value");
		this.FILE_NAME_PREFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "PREFIX", "value");
		this.FILE_NAME_SURFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "SURFIX", "value");
		this.TIME_STAMP = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "TIMESTAMP", "value");

		this.TIME_STAMP_INSTANCE = new SimpleDateFormat(this.TIME_STAMP);

		final String prefix = this.FILE_NAME_PREFIX;
		final String surfix = this.FILE_NAME_SURFIX.concat(".ing");
		// 전에 처리하던 로그 파일이 있으면 전환을 해줘야한다.
		FilenameFilter filter = new FilenameFilter() {
			public boolean accept(File dir, String name) {
				return (name.startsWith(prefix) && name.endsWith(surfix));
			}
		};

		File base_dir = new File(this.BASE_DIRECTORY);

		String[] files = base_dir.list(filter);

		int idx = -1;

		for (int i = 0; i < files.length; i++) {
			idx = files[i].indexOf(surfix);

			if( idx < 0 ) {
				continue;
			}
			File source = new File(this.BASE_DIRECTORY + "/" + files[i]);
			File target = new File(this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + pluto.util.Cal.getSerialDate() + this.FILE_NAME_SURFIX);
			boolean fileRename = source.renameTo(target);
			if(!fileRename) log.error("File name rename failed");
			try {
				Thread.sleep(2000);
			}
			catch(Exception e) {
				// empty
			}
		}
	}

	/**
	 * 로그를 기록
	 */
	public synchronized void write(String log) throws Exception {
		setTargetFile();
		this.WRITER_INSTANCE.writeString(log);
	}

	/**
	 * 시간을 체크해서 파일을 toggle한다.
	 */
	protected void setTargetFile() throws Exception {
		if( this.NEXT_CHECK_TIME > System.currentTimeMillis() ) {
			return;
		}

		// 매번 체크하는거 보다는 분당 한번 체크해서 바꾸는 것이 조금은 도움이 될거 같다.
		this.NEXT_CHECK_TIME = System.currentTimeMillis() + 60 * 1000;

		this.DATE_INSTANCE.setTime(System.currentTimeMillis());
		if( this.CURRENT_DATE.equals(this.TIME_STAMP_INSTANCE.format(DATE_INSTANCE)) )
			return;

		synchronized (__LOCK__) {
			if( this.WRITER_INSTANCE != null ) {
				try {
					this.WRITER_INSTANCE.close();
				}
				catch(Exception e) {
					// empty
				}
				// 로그파일을 스위칭해야한다.
				File fileSource = new File(this.CURRENT_LOG_FILE_NAME);
				File fileTarget = new File(this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + pluto.util.Cal.getSerialDate() + this.FILE_NAME_SURFIX);

				boolean fileRename = fileSource.renameTo(fileTarget);
				if(!fileRename) log.error("File name rename failed");
			}

			this.CURRENT_DATE = this.TIME_STAMP_INSTANCE.format(DATE_INSTANCE);

			this.CURRENT_LOG_FILE_SWITCHED_NAME = this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + this.CURRENT_DATE;

			this.CURRENT_LOG_FILE_NAME = CURRENT_LOG_FILE_SWITCHED_NAME + this.FILE_NAME_SURFIX + ".ing";
			this.WRITER_INSTANCE = new eMsSizeIndexedOutputStream(this.CURRENT_LOG_FILE_NAME, false);
		}
	}
}
