/*
 * LogUpdatorImpl.java
 *
 * Created on 2003년 11월 17일 (월), 오후 6:17
 */

package pluto.common.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.Name;
import pluto.log.LogUpdator;
import pluto.util.StringConvertUtil;
/**
 *
 * @author  Administrator
 */
public abstract class LogUpdatorImpl extends Name implements LogUpdator {
	
	
	
	
	public static final String OK = "SUCCESS";
	public static final String FAIL = "FAIL";
	
	// FOR COMMON LOG UPDATOR
	public static final String MESSAGE_UPDATE_SUCCESS = "UPDATE SUCCESS";
	public static final String MESSAGE_INVALID_KEY = "KEY IS INVALID";
	
	// FOR TRACKING UPDATE
	public static final String MESSAGE_DUR_OPEN_FAIL = "DURATION OPEN LOG";
	public static final String MESSAGE_OUT_DATE_FAIL = "OUT OF DATE LOG";
	public static final String MESSAGE_OUT_OF_DUR_FAIL = "OUT OF DURATION TIME";
	
	// FOR APP AUTO MAIL
	public static final String MESSAGE_LOG_NULL = "LOG IS NULL";
	
	protected eMsConnection EMS_CONNECTION = null;
	
	protected eMsStatement EMS_UPDATE_STATEMENT = null;
	
	protected LinkedList<LogUpdator> ADDITIONAL_MODULES = null;
	
	protected StringBuffer TMP_WORK_BUFFER = null;
	
	/** Creates a new instance of LogUpdatorImpl */
	public LogUpdatorImpl() {
		super();
		TMP_WORK_BUFFER = new StringBuffer(512);
	}
	
	/** 데이터 베이스 연결을 초기화 한다.
	 */
	public void init_connection(eMsConnection conn) throws Exception {
		this.EMS_CONNECTION = conn;
		
		if( this.EMS_CONNECTION == null ) throw new NullPointerException( getName() +  "CONNECTION IS NULL");
		
		this.EMS_UPDATE_STATEMENT = this.EMS_CONNECTION.createStatement();
		
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator<LogUpdator> iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).init_connection( conn );
			}
		}
	}
	
	/** 데이터 베이스 관련하여 내부적으로 생성한 자원들을 반환한다.
	 */
	public void clear_connection() {
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator<LogUpdator> iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).clear_connection();
			}
		}
		this.EMS_CONNECTION.recycleStatement( this.EMS_UPDATE_STATEMENT );
	}
	/** 데이터 베이스 연결을 재설정하고 자원을 다시 할당한다.
	 */
	public void ensureDBConnection() throws Exception {
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator<LogUpdator> iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).ensureDBConnection();
			}
		}
		
		/**이미 연결이 된 상태에서 하는 것이기 때문에 기존에 있던 녀석을 집어넣고 돌린다.
		 */
//		this.EMS_CONNECTION.recycleStatement( this.EMS_UPDATE_STATEMENT );
//		this.EMS_CONNECTION.recycle();
//		
//		EMS_CONNECTION = ConnectionPool.getConnection();
//		this.EMS_UPDATE_STATEMENT = this.EMS_CONNECTION.createStatement();
	}
	
	/** 업데이트 종료를 세팅한다.
	 */
	public void setEnd() throws Exception {
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator<LogUpdator> iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).setEnd();
			}
		}
	}
	
	/** 업데이트 시작을 세팅한다.
	 */
	public void setStart() throws Exception {
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator<LogUpdator> iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).setStart();
			}
		}
	}
	
	/** 업데이트하는 규칙을 세팅한다.
	 */
	public void setUpdateRules(Object tmp) throws Exception {
		return;
	}
	
	/** 같이 업데이트될 업데이터 들을 등록한다.
	 */
	public void setDefaultUpdator(LogUpdator updator) {
		if( ADDITIONAL_MODULES == null ){
			ADDITIONAL_MODULES = new LinkedList<LogUpdator>();
		}
		ADDITIONAL_MODULES.addLast( updator );
	}
	
	/**리스트로 된 녀석들을 업데이트 한다.
	 * 2017.05.02
	 */
	protected void executeUpdateList( List list , Object obj ) throws Exception{
		List innerList = list;
		
		synchronized( innerList ){
			for( Iterator iter = innerList.iterator() ;  iter.hasNext() ; ){
				String query = iter.next().toString();
				executeUpdate( query , obj );
			}
		}
	}
	
	/**단순쿼리 업데이트 한다.
	 */
	protected int executeUpdate( String query , Object obj ) throws Exception{
		TMP_WORK_BUFFER.setLength( 0 );
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , query , obj , "${" , "}" , true , false );
		return this.EMS_UPDATE_STATEMENT.executeUpdate( TMP_WORK_BUFFER.toString() );
	}
	
	/**단순쿼리 업데이트 한다.
	 */
	protected eMsResultSet executeQuery( String query , Object obj ) throws Exception{
		TMP_WORK_BUFFER.setLength( 0 );
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , query , obj , "${" , "}" , true , false );
		return this.EMS_UPDATE_STATEMENT.executeQuery( TMP_WORK_BUFFER.toString() );
	}
	
	protected void finalize() throws Throwable{
		this.TMP_WORK_BUFFER = null;
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public abstract String update( Object log ) throws Exception;
}
