/*
 * TypeLogUpdatorImpl.java
 *
 * Created on 2003년 11월 17일 (월), 오후 8:23
 */

package pluto.common.log;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

import pluto.common.db.NotPooledConnection;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.log.LogTypeUpdator;
import pluto.log.LogUpdator;
//import pluto.util.StringUtil;

/**
 *
 * @author  Administrator
 */
@Slf4j
public abstract class LogTypeUpdatorImpl extends LogUpdatorImpl implements LogTypeUpdator {
	
	protected Hashtable TYPE_UPDATE_HASH = null;
	
	/** Creates a new instance of TypeLogUpdatorImpl */
	public LogTypeUpdatorImpl() {
		super();
	}
	
	/** 업데이트하는 규칙을 세팅한다.
	 */
	public void setUpdateRules(Object tmp) throws Exception {
		Properties prop = ( Properties ) tmp;
		/**해당 타입의 클래스를 로드한다.
		 */
		TYPE_UPDATE_HASH = new Hashtable();
		for( Enumeration eNum = prop.keys() ; eNum.hasMoreElements() ; ){
			String key = ( String )eNum.nextElement();
			if( key.startsWith( "type." ) && key.endsWith( ".class" ) ){
				log.debug( "LOAD["+key.substring( 5 , key.indexOf( ".class" ) )+"]" , prop.getProperty( key ) );
				TYPE_UPDATE_HASH.put( key.substring( 5 , key.indexOf( ".class" ) ) , Class.forName( prop.getProperty( key ) ).newInstance() );
			}
		}
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public abstract String update(Object log) throws Exception;
	
	/** 데이터 베이스 연결을 초기화 한다.
	 */
	public void init_connection( eMsConnection conn ) throws Exception {
		if( TYPE_UPDATE_HASH != null ) {
			for( Enumeration eNum = TYPE_UPDATE_HASH.elements() ; eNum.hasMoreElements(); ){
				( ( LogUpdator )eNum.nextElement() ).init_connection( conn );
			}
		}

		super.init_connection( conn );
	}
	
	/** 데이터 베이스 관련하여 내부적으로 생성한 자원들을 반환한다.
	 */
	public void clear_connection() {
		if( TYPE_UPDATE_HASH != null ) {
			for( Enumeration eNum = TYPE_UPDATE_HASH.elements() ; eNum.hasMoreElements(); ){
				( ( LogUpdator )eNum.nextElement() ).clear_connection();
			}
		}

		super.clear_connection();
	}
	/** 키로 업데이트할 업데이터를 등록한다.
	 */
	public void setKeyUpdator(String key, LogUpdator updator) {
		if( TYPE_UPDATE_HASH == null ){
			TYPE_UPDATE_HASH = new Hashtable();
		}
		TYPE_UPDATE_HASH.put( key , updator );
	}
}
