/*
 * FixedFileLogChannel.java
 *
 * Created on 2004년 10월 21일 (목), 오후 4:44
 */

package pluto.common.log;

import pluto.io.eMsFileWriter;

/**
 * 
 * @author EMS
 */
public class FixedFileLogChannel extends pluto.log.LogChannel {
	protected eMsFileWriter	WRITER_INSTANCE	= null;

	/** Creates a new instance of FixedFileLogChannel */
	public FixedFileLogChannel(String file) throws Exception {
		this.WRITER_INSTANCE = new eMsFileWriter(file);
	}

	/**
	 * 초기화
	 */
	protected void setRule(Object info) throws Exception {
		// empty
	}

	/**
	 * 로그를 기록
	 */
	public synchronized void write(String log) throws Exception {
		this.WRITER_INSTANCE.println(log);
	}

	public void flush() {
		this.WRITER_INSTANCE.flush();
	}

	public void close() {
		this.WRITER_INSTANCE.flush();
		this.WRITER_INSTANCE.close();
	}
}
