/*
 * ComposerImpl.java
 *
 * Created on 2003년 11월 17일 (월), 오후 5:7
 */

package pluto.common.log;

import pluto.log.Composer;
/**
 *
 * @author  Administrator
 */
public abstract class ComposerImpl extends Composer {
	
	protected Object __LOCK__ = null;
	
	/** Creates a new instance of ComposerImpl */
	public ComposerImpl() {
		super();
		__LOCK__ = new Object();
	}
	
	/** 로그 조립 룰을 정의한다.
	 * @param tmp 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void setComposingRules(Object tmp) throws Exception {
		// empty
	}

	/** 실패한 로그를 반환한다.
	 * @return 작성한 로그
	 */
	public String generate_fail() {
		return generate_full();
	}
	
	/** 일반적인 로그파일에 작성할 로그를 반환한다.
	 * @return 작성한 로그
	 */
	public abstract String generate_full();
	
	/** 성공한 로그를 반환한다.
	 * @return 작성한 로그
	 */
	public String generate_success() {
		return generate_full();
	}
	
	/** 콤포징 파라미터를 세팅할때 간섭을 피할수 있도록 Lock Object를 반환한다.
	 *새롭게 시작하기 때문에 기존 세팅된 설정을 지운다.
	 * @return 작성한 로그
	 */
	public synchronized Object getLock() {
		super.clear();
		return __LOCK__;
	}
}
