/*
 * CommonSendLogParser.java
 *
 * Created on 2003년 11월 17일 (월), 오후 5:36
 */

package pluto.common.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.log.LogParser;
import pluto.log.LogProcessor;
import pluto.util.convert.DelimConvertor;
/**
 *
 * @author  Administrator
 */
@Slf4j
public class CommonSendLogParser extends Properties implements LogParser {
	
	
	protected LinkedList __EXTERNAL_PROCESSOR__ = null;
	
	/** Creates a new instance of StandardLogParser */
	public CommonSendLogParser() {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** 파싱룰을 정의한다.
	 * @param tmp 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void setParsingRules(Object tmp) throws Exception {
		// empty
	}
	
	/** 포그를 파싱하면서 추가로 작업을 해야할 LogProcessor를 지정한다.
	 */
	public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
		if( __EXTERNAL_PROCESSOR__ == null ){
			__EXTERNAL_PROCESSOR__ = new LinkedList();
		}
		
		__EXTERNAL_PROCESSOR__.addLast( tmp );
	}
	
	/** 로그를 파싱해서 결과를 반환한다.<br>
	 * 결과는 다양한 타입을 지원하기 위하여 Object로 한다.
	 * @param src 로그 String
	 * @throws Exception 파싱하면서 에러나면
	 * @return 파싱결과
	 */
	public Object parse(String src) throws Exception {
		super.clear();
		//String tmp = null;
		try {
			int idx1 = src.indexOf("|");
			if( idx1 < 0  ) return null;
			super.setProperty( LOG_T_DATE,  src.substring(0,idx1));
			
			idx1++;
			int idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_SEND_TYPE,  src.substring(idx1,idx2));
			
			// add TMS3.0 SERVER_ID
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty(LOG_SERVER_ID, src.substring(idx1,idx2));
			
			// add TMS3.0 ROWID
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty(LOG_ROWID, DelimConvertor.decode(src.substring(idx1,idx2)));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_MEMBER_ID,  DelimConvertor.decode(src.substring(idx1,idx2)) );
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_T_TYPE,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_T_CODE,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_MAIL_ID,  DelimConvertor.decode(src.substring(idx1,idx2)));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_LIST_TABLE,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_STEP,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_TOKEN_ID,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_MX_RECORD,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_DELAY,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_DOMAIN,  src.substring(idx1,idx2).toLowerCase());
			
			idx1 = idx2 + 1;
			idx2 = src.indexOf("|", idx1);
			if( idx2 < 0  ) return null;
			super.setProperty( LOG_WORKER,  src.substring(idx1,idx2));
			
			idx1 = idx2 + 1;
			super.setProperty( LOG_ETC_LOG,  src.substring(idx1));
			
			if( __EXTERNAL_PROCESSOR__ == null ) return this;
			
			for( Iterator iter = __EXTERNAL_PROCESSOR__.iterator() ; iter.hasNext() ; ) {
				LogProcessor __TMP_PROCESSOR__ = ( LogProcessor )iter.next();
				__TMP_PROCESSOR__.process( this );
			}
		}
		catch( Exception e ) {
			return null;
		}
		
		return this;
	}
}
