/*
 * RecycleableConnection.java
 *
 * Created on 2003년 10월 28일 (화), 오후 1:36
 */

package pluto.common.db;

import lombok.extern.slf4j.Slf4j;
import pluto.util.recycle.RecycleBin;
import pluto.util.recycle.Recycleable;

/**
 * 
 * @author Administrator
 */
@Slf4j
public class RecycleableConnection extends NotPooledConnection implements Recycleable {
	

	public static void init(Object tmp) throws Exception {
		return;
	}

	protected RecycleBin	__BIN__	= null;

	/** Creates a new instance of RecycleableConnection */
	public RecycleableConnection() {
		super();
	}

	/**
	 * 연결의 유효성을 검사한다.
	 * 
	 * @return true : 파기대상 <br>
	 *         false : 파기하면 안됨
	 */
	public boolean expire() {
		return false;
	}

	/**
	 * 더이상 안쓴다고 명시한다.
	 */
	public void setRecycleBin(RecycleBin bin) {
		this.__BIN__ = bin;
	}

	/**
	 * 재활용 되지 않고 삭제 될때 자원 정리
	 */
	public synchronized void destroy() {
		if (log.isDebugEnabled()) {
			log.debug("INTO DESTROY");
		}
		this.lock = null;

		super.recycle();

		this.__BIN__.destroy(this);
	}

	/**
	 * 사용을 마친다. 재활용 일경우에는 이 method를 override하면 된다.
	 */
	public synchronized void recycle() {
		if (log.isDebugEnabled()) {
			log.debug("INTO RECYCLE");
		}

		try {
			this.clean();
		}
		catch(Exception e) {
			// empty
		}

		try {
			// 재활용하기 전에 정상적인지 점검하고 집어 넣는다.
			ensureOpen();
		}
		catch(Exception e) {
			this.__BIN__.destroy(this);
			return;
		}

		if( CONNECTION_MONITOR_PRESENT ) {
			// 점검을 하고
			releaseIdleMonitor();
		}

		this.__BIN__.recycle(this);
		return;
	}

	/**
	 * 더이상 안쓴다고 명시한다.
	 */
	public void setEnd() {
		this.clean();
		destroy();
	}

	protected void log(String log) {
		this.__BIN__.log(this.getName() + ":" + log);
	}
}
