/*
 * RecycleConnectionPool.java
 *
 * Created on 2003년 10월 28일 (화), 오후 1:27
 */

package pluto.common.db;

import java.util.Properties;

import pluto.db.ConnectInfo;
import pluto.db.ConnectionPoolImpl;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.util.recycle.Recycleable;
/**
 *
 * @author  Administrator
 */

@Slf4j
public class RecycleConnectionPool extends pluto.util.recycle.ObjectPool implements ConnectionPoolImpl {
	
	
	/** Creates a new instance of RecycleConnectionPool */
	public RecycleConnectionPool() {
		super();
	}
	
	/** Connection이 생성되면서 invoke된다.<br>
	 * 초기화 로직을 삽입하면 되며 각 Instance별로 실행된다.
	 * @param prop 초기화 파라미터
	 */
	public void inner_init(Properties prop) throws Exception{
		/**내부 로깅 인스턴스 있으면 초기화 없음 말구...
		 */
		String LOGCHANNEL_ID = prop.getProperty("logger.id");
		
		if( LOGCHANNEL_ID == null ){
			log.error("LOGCHANNEL IS NOT SET......." );
		}
		else{
			if (log.isDebugEnabled())  log.debug( "LOGGER=>" + LOGCHANNEL_ID );
			this.LOG_CHANNEL_INSTANCE = LogChannelContainer.get( LOGCHANNEL_ID );
		}
		
		reSize( Integer.parseInt( prop.getProperty( "pool.size" ) ) );
	}
	
	/** EMS내부적으로 사용하는 Connection을 반환한다.
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 */
	public eMsConnection get() throws Exception {
		eMsConnection returnValue = ( eMsConnection )getRecycleable();
		returnValue.ensureOpen();
		returnValue.setName( "caller[" + Thread.currentThread().getName() + "]" );
		return returnValue;
	}
	
	/** EMS내부적으로 사용하는 Connection을 지정된 이름으로 생성하여 반환한다.
	 * @param name Connection이름
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	public eMsConnection get(String name) throws Exception {
		eMsConnection returnValue = ( eMsConnection )getRecycleable();
		returnValue.ensureOpen();
		
		if (log.isDebugEnabled())  log.debug( name , "GET CONN=>" + returnValue.getName() );
		
		return returnValue;
	}
	 */
	
	/** 지정된 ConnectInfo의 Connection을 Default 이름으로 생성하여 반환한다.
	 * @param info 연결 정보
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 */
	public eMsConnection get( ConnectInfo info ) throws Exception {
		eMsConnection returnValue = eMsConnection.getBasicInstance();
		
		returnValue.execute( info );
		returnValue.setName( "Connection[" + info.getDB_NAME() + ":" + Thread.currentThread().getName() + "]" );
		
		return returnValue;
	}
	
	protected Recycleable create(int seq, int level) throws Exception {
		log( "REQUEST CONNECTION CREATE NEW..." );
		eMsConnection returnValue = eMsConnection.getInstance();
		
		Recycleable target = ( Recycleable )returnValue;
		target.setRecycleBin( this );

		returnValue.execute();
		returnValue.setName( "Connection#".concat( String.valueOf( level ) ) );
		
		log( "create Instance=>".concat( returnValue.getClass().getName() ) );
		
		return target;
	}
	
	/**재활용 센터로 들어갈때 연결이 정상인지 체크를 해보고 넣는다.
	 */
	public void recycle( Recycleable src ) {
		if( src instanceof eMsConnection ){
			eMsConnection returnValue = ( eMsConnection )src;
			try{
				returnValue.ensureOpen();
				super.recycle( src );
			}
			catch( Exception e ){
				/**정상이 아닌것으로 판단을 하고 풀에서 제거한다.
				 */
				log( "connection open check error=>" + e.toString() );
				log( "check error=>" + src.getName() );
				returnValue.recycle();
				super.destroy( src );
				return;
			}
		}
		else{
			log( "invalid object recycle=>" + src.getClass().getName() );
		}
	}

	@Override
	public void setLogger(LogChannel logger) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void log(String log) {
		
	}
}
