/*
 * NotPooledConnection.java
 *
 * Created on 2003년 3월 12일 수, 오전 11:24
 */

package pluto.common.db;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author 이상근
 * @version 3.0
 */
@Slf4j
public class NotPooledConnection extends pluto.db.eMsConnection {
	

	/** Creates new NotPooledConnection */
	public NotPooledConnection() {
		super();
	}

	public static void init(Object tmp) throws Exception {
		return;
	}

	/**
	 * 커넥션을 실제적으로 수행한다.
	 */
	public synchronized void ensureOpen() throws SQLException {
		if (log.isDebugEnabled()) {
			log("check ensureOpen");
		}

		Statement stmt = null;
		try {
			if (log.isDebugEnabled()) {
				log("NotPooledConnection ensureOpen #1 CHECK CONNECTION");
			}

			if( this.conn != null && !this.conn.isClosed() ) {
				if (log.isDebugEnabled()) {
					log("NotPooledConnection ensureOpen #2 NOT CLOSE");
				}

				stmt = this.conn.createStatement();

				if (log.isDebugEnabled()) {
					log("NotPooledConnection ensureOpen #2-1 CREATE STATEMENT OK");
				}

				if( this.CONNECT_INFO.getDB_INIT_QUERY() != null ) {
					if (log.isDebugEnabled()) {
						log("NotPooledConnection ensureOpen #2-3 EXEC SQL:" + this.CONNECT_INFO.getDB_INIT_QUERY());
					}

					stmt.execute(this.CONNECT_INFO.getDB_INIT_QUERY());

					if (log.isDebugEnabled()) {
						log("NotPooledConnection ensureOpen #2-4 EXEC SQL:" + this.CONNECT_INFO.getDB_INIT_QUERY() + " =>OK");
					}
				}
				return;
			}
			else if (log.isDebugEnabled()) {
				log("Already Closed...");
			}

			if (log.isDebugEnabled()) {
				log("NotPooledConnection ensureOpen #3 CLOSE continue");

			}
		}
		catch(Exception e) {
			// 기본 쿼리에서 에러가 발생 하였다면 커넥션을 정리하고 신규 커넥션으로 교체한다.
			log(pluto.util.StringConvertUtil.exToString(e));
		}
		finally {
			try {
				if(stmt != null)
					stmt.close();
			}
			catch(Throwable e) {
				//e.printStackTrace();
				log.error(e.getMessage());
			}
		}
		if (log.isDebugEnabled()) {
			log("NotPooledConnection ensureOpen #4 CREATE NEW CONNECTION");
		}

		/**
		 * 만약의 경우에 대비해서 close를 한다. 또한 저장된 Statement를 날려버려야한다.
		 */
		releaseConnection();

		this.cleanRecycleStatements();

		try {
			if(this.conn != null)
				this.conn.close();
		}
		catch(Throwable ignore) {
		}

		if (log.isDebugEnabled()) 
			log("NotPooledConnection ensureOpen #4-1 ENSURE CON CLOSE OK");

		//여기까지 왔다면 위에서 에러가 발생한 것이므로 다시한번 해보구 이때 발생하는 Exception은 그냥 위로 보낸다.
		if( this.CONNECT_INFO.getDB_UID() == null ) {
			this.conn = DriverManager.getConnection(this.CONNECT_INFO.getDB_URL());
		}
		else {
			this.conn = DriverManager.getConnection(this.CONNECT_INFO.getDB_URL(), this.CONNECT_INFO.getDB_UID(), this.CONNECT_INFO.getDB_PASS());
		}

		if (log.isDebugEnabled()) {
			log("NotPooledConnection ensureOpen #4-2 CREAT CONN OK");
		}
		try {
			stmt = this.conn.createStatement();
			if( this.CONNECT_INFO.getDB_INIT_QUERY() != null ) {
				if (log.isDebugEnabled()) {
					log("EXEC INIT QUERY:" + this.CONNECT_INFO.getDB_INIT_QUERY());
				}
				stmt.execute(this.CONNECT_INFO.getDB_INIT_QUERY());
			}
			if (log.isDebugEnabled()) 
				log("NotPooledConnection ensureOpen #4-3 CHECK STATEMENT OK");
		}
		catch(Exception e) {
			log.error(getName(), "CONNECTION CHECK QUERY EXEC ERROR", e);
		}
		finally {
			try {
				if(stmt != null)
					stmt.close();
			}
			catch(Exception ignore) {
			}
		}

		return;
	}

	public boolean expire() {
		return false;
	}
}
