/*
 * DirectConnectionPool.java
 *
 * Created on 2003년 3월 12일 수, 오후 1:30
 */

package pluto.common.db;

import java.util.Properties;

import pluto.db.ConnectInfo;
import pluto.db.ConnectionPoolImpl;
import pluto.db.eMsConnection;

/** Recycling을 하지않고 요청이 있을때 마다 Connection을 생성
 * @author 이상근
 * @version 3.0
 */
public class DirectConnectionPool implements ConnectionPoolImpl {
	/** Creates new DirectConnectionPool
	 */
	public DirectConnectionPool() {
		// empty
	}
	
	/** 아무일도 하지 않는다.
	 * @param prop 초기화 파라미터
	 */
	public void inner_init(Properties prop) throws Exception{
		// empty
	}
	
	/** EMS내부적으로 사용하는 Connection을 반환한다.
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 * @see kr.co.amail.db.eMsConnection#execute()
	 */
	public eMsConnection get() throws Exception {
		eMsConnection returnValue = eMsConnection.getBasicInstance();
		
		returnValue.execute();
		
		returnValue.setName( "Connection[ems:" + Thread.currentThread().getName() + "]" );
		
		return returnValue;
	}
	
	/** 지정된 ConnectInfo의 Connection을 Default 이름으로 생성하여 반환한다.
	 * @param info 연결 정보
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 * @see kr.co.amail.db.eMsConnection#execute( ConnectInfo )
	 */
	public eMsConnection get(ConnectInfo info) throws Exception {
		eMsConnection returnValue = eMsConnection.getBasicInstance();
		
		returnValue.execute( info );
		
		returnValue.setName( "Connection[" + info.getDB_NAME() + ":" + Thread.currentThread().getName() + "]" );
		
		return returnValue;
	}
	
	/** EMS내부적으로 사용하는 Connection을 지정된 이름으로 생성하여 반환한다.
	 * @param name Connection이름
	 * @throws Exception 생성시 에러
	 * @return 생성된 eMsConnection
	 * @see kr.co.amail.db.eMsConnection#execute( String )
	public eMsConnection get(String name) throws Exception {
		eMsConnection returnValue = eMsConnection.getBasicInstance();
		
		returnValue.execute( name );
		
		return returnValue;
	}
	 */
	
	/**지정된 ConnectInfo의 Connection을 지정된 이름으로 생성하여 반환한다.
	 * @param info ConnectInfo
	 * @param name Connection 이름
	 * @throws Exception 연결오류
	 * @return 생성된 eMsConnection
	 * @see kr.co.amail.db.eMsConnection#execute( ConnectInfo , String )
	public eMsConnection get(ConnectInfo info, String name) throws Exception {
		eMsConnection returnValue = eMsConnection.getBasicInstance();
		
		returnValue.execute( info , name );
		
		return returnValue;
	}
	 */
}
