package pluto.common.db;

import java.util.Properties;

import pluto.db.ConnectInfo;
import pluto.db.ConnectionPoolImpl;
import pluto.db.eMsConnection;

public class DBCPConnectionPool implements ConnectionPoolImpl {
	public eMsConnection get() throws Exception {
		// TODO Auto-generated method stub
		eMsConnection returnValue = DBCPConnection.getInstance();
		
		returnValue.execute();
		
		returnValue.setName( "Connection[ems:" + Thread.currentThread().getName() + "]" );
		
		return returnValue;
	}

	public eMsConnection get(ConnectInfo info) throws Exception {
		// TODO Auto-generated method stub
		eMsConnection returnValue = DBCPConnection.getBasicInstance();
		
		returnValue.execute( info );
		
		returnValue.setName( "Connection[" + info.getDB_NAME() + ":" + Thread.currentThread().getName() + "]" );
		
		return returnValue;
	}

	/*
	 * (non-Javadoc)
	 * @see pluto.db.ConnectionPoolImpl#inner_init(java.util.Properties)
	 * DBCP connection 초기 셋팅...
	 */
	public void inner_init(Properties prop) throws Exception {
		// TODO Auto-generated method stub
	}
}

