package pluto.common.db;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;

import javax.sql.DataSource;

import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.impl.GenericObjectPool;

import lombok.extern.slf4j.Slf4j;
import pluto.db.ConnectInfo;
import pluto.db.eMsConnection;

@Slf4j
public class DBCPConnection extends eMsConnection {
	private	static String EVICT_RUN_TIME = "5000";
	private	static String EVICT_IDLE_TIME = "500";
	private static DataSource dataSource;
	private static GenericObjectPool connectionPool;
	
	
	public static void init(Object tmp) throws Exception {
		Properties prop = (Properties)tmp;
		
		String db_name = prop.getProperty("db.name", "ems");
		
		
		ConnectInfo connectInfo = (ConnectInfo)info.get(db_name);
		
		connectionPool = new GenericObjectPool(null);
		connectionPool.setMaxActive(Integer.parseInt(prop.getProperty("max.active", "25")));
		connectionPool.setMaxIdle(Integer.parseInt(prop.getProperty("max.idle", "15")));
		connectionPool.setMaxWait(Integer.parseInt(prop.getProperty("max.wait", "10")));		
		
		
		if(prop.getProperty("test.on.return","false").equals("true")){
			connectionPool.setTestOnReturn(true);
		}
		if(prop.getProperty("test.while.idle","false").equals("true")){
			connectionPool.setTestWhileIdle(true);
		}
		if( prop.getProperty("test.on.borrow","false").equals("true") ){
			connectionPool.setTestOnBorrow(true);
		}
		
		connectionPool.setMinEvictableIdleTimeMillis(Integer.parseInt(prop.getProperty("evict.idle.time", "-1")));
		connectionPool.setTimeBetweenEvictionRunsMillis(Integer.parseInt(prop.getProperty("evict.run.time", "150000")));
		
		ConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectInfo.getDB_URL(), connectInfo.getDB_UID(), connectInfo.getDB_PASS());
		
		PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, null, connectInfo.getDB_INIT_QUERY(), false, true);
		poolableConnectionFactory.setConnectionInitSql(Arrays.asList(   connectInfo.getDB_INIT_QUERY())   );
		
		dataSource = new PoolingDataSource(connectionPool);
		
		return;
	}
	
	public static void printDriverStats() throws Exception {
		log.info("NumActive:{}, NumIdle:{}",
				connectionPool.getNumActive(),
				connectionPool.getNumIdle());
	}
	
	@Override
	public synchronized void ensureOpen() throws SQLException {
		if(this.conn != null){
			this.recycle();
		}
		
		this.conn = dataSource.getConnection();
		
		try {
			printDriverStats();
		} catch (Exception e) {
			log.error("DRIVER STATE : " + e.getMessage());
		}
	}
	
	@Override
	public boolean expire() {
		return false;
	}
}
