package moon.plan.actor;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.common.bean.PlanBean;
import pluto.lang.Name;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.net.communicator.InfoComunicator;
import pluto.util.Cal;

@Slf4j
public class FlowPlanControlActor extends Name implements InfoActor{
	
	
	private static final String HANDLER      = "moon.plan.actor.FlowPlanControlActor";

	
	public FlowPlanControlActor(){
		this.setName( "DomainFilterActor" + Cal.getSerialDate() );
	}
	
	/**
	 * 수신해서 처리하는 부분
	 */
	public void execute(InfoBeans arg) throws Exception {
		log.info("[execute]...[start]" );
		
		Properties prop  = arg.getArgs();
		String actFlag   = prop.getProperty("ACTFLAG");
		String resultStr = "";
		
		if(log.isDebugEnabled()){
			log.info("[ACTFLAG] :"+actFlag );
		}
		
		//code : INIT 초기화
		if(actFlag.equals("INIT")){
			log.info("[INIT]");

			// clean hashTable
			PlanBean.cleanPlanInfo();
			
			resultStr = "CLEAN_OK";
		}
		
		prop.setProperty("RESULT", resultStr);
		
		log.info("[execute]...[end]" );
	}
	
	
	
	
	/**
	 * 통신을 위해 발신 하는 부분
	 * @return
	 * @throws Exception
	 */
	public String flowPlanCleanCommu(ArrayList<String> arry) throws Exception{
		
		if(arry == null || arry.size() ==0){
			return "COMMU list is null";
		}
		
		
		StringBuffer returnBuffer = new StringBuffer();;

		//액션에 필요한 데이터
		Properties prop = new Properties();
		prop.setProperty( "ACTFLAG" , "INIT");
		
		int arrySize      = arry.size();
		String arryStr    = "";
		String serverIp   = "";
		String serverPort = "";
		int    port       = 0;
		String returnStr  = "";
		boolean firstFlag = true;
		
		for(int i=0; i< arrySize; i++){
			arryStr = arry.get(i);
			
			int idx = arryStr.indexOf(":");
			if(idx < 0){
				continue;
			}
			
			serverIp   = arryStr.substring( 0, idx );
			serverPort = arryStr.substring( idx+1  );
			
			try{
				port = Integer.parseInt(serverPort);
			}catch(Exception ex){
				log.error(getName(), ex);
				continue;
			}
			
			returnStr = commu(prop, serverIp, port); 
			
			if( "CLEAN_OK".equals(returnStr)){
				if(firstFlag){
					firstFlag = false;
				}else{
					returnBuffer.append(",");
				}
				returnBuffer.append(arryStr);
			}else{
				log.error("[ERROR-from server] server:"+arryStr+", "+returnStr);
			}
		}
		
		return returnBuffer.toString();
		
	}
	
	
	
	
	
	/**
	 * 실재 통신하는 부분
	 * @param prop
	 * @param serverIp
	 * @param serverPort
	 * @return
	 * @throws Exception
	 */
	private String commu(Properties prop, String serverIp, int serverPort) throws Exception{
		
		String returnMsg = "init"; 
		
		InfoBeans bean   = new InfoBeans();
		bean.setArgs(       prop       );
		bean.setHandler(    HANDLER    );
		bean.setServerIP(   serverIp   );
		bean.setServerPORT( serverPort );

		InfoComunicator commu = new InfoComunicator();
		commu.setInfoBeans(bean);
	
		try{
			bean = commu.execute();
			
		}catch (Exception e){
			if (e instanceof ConnectException){
				returnMsg = "ERROR-Communication : You need to check the engine.";
			}
		}
		
		if(returnMsg.equals("init")){
			returnMsg = bean.getProperty( "RESULT" );
		}
		
		return returnMsg;
	}
	
}
