package moon.logprocess.updator;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ScheduleTblBean { 
	
	public String POST_ID = "";
	public int PUSHED_CNT	= 0;
	public int FAIL_CNT	= 0;
	
	public int TYPE_10_ERROR =0;
	public int TYPE_20_ERROR =0;
	public int TYPE_30_ERROR =0;
	public int TYPE_40_ERROR =0;
	public int TYPE_50_ERROR =0;
	public int TYPE_60_ERROR =0;
	public int TYPE_70_ERROR =0;
	public int TYPE_80_ERROR =0;
	public int TYPE_90_ERROR =0;
	public int TYPE_95_ERROR =0;
	public int TYPE_99_ERROR =0;
	
	public String serverId = "";
	
	public String toString(){
		return "["+POST_ID+"] PUSHED_CNT:"+PUSHED_CNT+",FAIL_CNT:"+FAIL_CNT+"\n"
				+",TYPE_10_ERROR:"+TYPE_10_ERROR+",TYPE_20_ERROR:"+TYPE_20_ERROR+"\n"
				+",TYPE_30_ERROR:"+TYPE_30_ERROR+",TYPE_40_ERROR:"+TYPE_40_ERROR+"\n"
				+",TYPE_50_ERROR:"+TYPE_50_ERROR+",TYPE_60_ERROR:"+TYPE_60_ERROR+"\n"
				+",TYPE_70_ERROR:"+TYPE_70_ERROR+",TYPE_80_ERROR:"+TYPE_80_ERROR+"\n"
				+",TYPE_90_ERROR:"+TYPE_90_ERROR+",TYPE_95_ERROR:"+TYPE_95_ERROR+"\n"
				+",TYPE_99_ERROR:"+TYPE_99_ERROR+"\n";
	}
	
	public ScheduleTblBean(String post_id){
		this.POST_ID = post_id;
	}
	
	public String getName(){
		return POST_ID;
	}
	
	
	public Properties getElement(String engine_type) throws Exception{
		Properties ppt = new Properties();
		
		if(engine_type.equals("MASS")){
			
			ppt.setProperty("POST_ID", POST_ID);
			
		}else if(engine_type.equals("AUTO")){
			
			int IDX_OF_SEP1 = POST_ID.indexOf( "_" );
			
			String WORKDAY = "";
			String SEQNO   = "";
			
			if( IDX_OF_SEP1 > 1 ){
				WORKDAY = POST_ID.substring( 0 , IDX_OF_SEP1 );
				SEQNO   = POST_ID.substring( IDX_OF_SEP1 + 1 );
			}else {
				throw new Exception("AUTO MAIL : syntax is not correct=>"+POST_ID);
			}
			
			ppt.setProperty("WORKDAY", WORKDAY);
			ppt.setProperty("SEQNO", SEQNO);
		}
		
		ppt.setProperty("PUSHED_CNT", ""+PUSHED_CNT);
		ppt.setProperty("FAIL_CNT", ""+FAIL_CNT);
		ppt.setProperty("ERROR_10_CNT", ""+TYPE_10_ERROR);
		ppt.setProperty("ERROR_20_CNT", ""+TYPE_20_ERROR);
		ppt.setProperty("ERROR_30_CNT", ""+TYPE_30_ERROR);
		ppt.setProperty("ERROR_40_CNT", ""+TYPE_40_ERROR);
		ppt.setProperty("ERROR_50_CNT", ""+TYPE_50_ERROR);
		ppt.setProperty("ERROR_60_CNT", ""+TYPE_60_ERROR);
		ppt.setProperty("ERROR_70_CNT", ""+TYPE_70_ERROR);
		ppt.setProperty("ERROR_80_CNT", ""+TYPE_80_ERROR);
		ppt.setProperty("ERROR_90_CNT", ""+TYPE_90_ERROR);
		ppt.setProperty("ERROR_95_CNT", ""+TYPE_95_ERROR);
		ppt.setProperty("ERROR_99_CNT", ""+TYPE_99_ERROR);
		ppt.setProperty("SERVER_ID", serverId);
				
		return ppt;
	}
	
	
	public void addPush(){
		if(log.isDebugEnabled()){log.debug("[  add push cnt]");}
		PUSHED_CNT++;
	}
	
	public void addFailCnt(){
		if(log.isDebugEnabled()){log.debug("[  add fail cnt]");}
		FAIL_CNT++;
	}
	
	public void addErrorCnt(String t_code){
		if(log.isDebugEnabled()){log.debug("[  add error cnt] code:"+t_code);}
		
		int code = Integer.parseInt(t_code);
		switch (code){ 
			case 10: TYPE_10_ERROR ++; break;
			case 20: TYPE_20_ERROR ++; break;
			case 30: TYPE_30_ERROR ++; break;
			case 40: TYPE_40_ERROR ++; break;
			case 50: TYPE_50_ERROR ++; break;
			case 60: TYPE_60_ERROR ++; break;
			case 70: TYPE_70_ERROR ++; break;
			case 80: TYPE_80_ERROR ++; break;
			case 90: TYPE_90_ERROR ++; break;
			case 95: TYPE_95_ERROR ++; break;
			case 99: TYPE_99_ERROR ++; break;		
			default: TYPE_95_ERROR ++; break;	
		}			
	}
	
	public void minusErrorCnt(String t_code){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  minus error cnt] code:"+t_code);}
		
		int code = Integer.parseInt(t_code);
		switch (code){ 
			case 10: TYPE_10_ERROR --; break;
			case 20: TYPE_20_ERROR --; break;
			case 30: TYPE_30_ERROR --; break;
			case 40: TYPE_40_ERROR --; break;
			case 50: TYPE_50_ERROR --; break;
			case 60: TYPE_60_ERROR --; break;
			case 70: TYPE_70_ERROR --; break;
			case 80: TYPE_80_ERROR --; break;
			case 90: TYPE_90_ERROR --; break;
			case 95: TYPE_95_ERROR --; break;
			case 99: TYPE_99_ERROR --; break;		
			default: TYPE_95_ERROR --; break;
		}			
	}	
	
	public void minusFailCnt(){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add fail cnt]");}
		FAIL_CNT--;			
	}
	
	public void compErrorCnt(String minus_code, String add_code){
		minusErrorCnt(minus_code);
		addErrorCnt(add_code);			
	}
	
	
	public void setServerId(String serverId){
		this.serverId = serverId;
	}
}
