
package moon.logprocess.updator;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import moon.logprocess.task.AutoAnalyzerMainTask;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.log.LogUpdator;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

@Slf4j
public class AutoMissSummary extends LogUpdatorImpl {

	// preparestatement query
	public static String	QUERY_SELECT_CURRENT_OLD_ERROR_CODE	= null;
	
	static {
		try {			
			// prepareStatement
			QUERY_SELECT_CURRENT_OLD_ERROR_CODE = SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_SELECT_CURRENT_OLD_ERROR_CODE");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	public AutoMissSummary() {
	}

	public LogUpdator getLogUpdator(String __SEND_TYPE__) {
		return null;
	}
	
	public String summary(Object obj, eMsStatement EMS_STATEMENT) throws Exception {
		Properties __LOG_DATA__ = (Properties) obj;
		
		String __SEND_TYPE__ = __LOG_DATA__.getProperty( LOG_SEND_TYPE );
		
		if(AutoAnalyzerMainTask.PRC_TARGET.indexOf(__SEND_TYPE__) < 0){
			return "NON TARGET LIST";
		}

		String __T_TYPE__ = __LOG_DATA__.getProperty(LOG_T_TYPE);
		String __T_CODE__ = __LOG_DATA__.getProperty(LOG_T_CODE);
		
		
		DomainUpdateBean domainBean = null;
		ScheduleTblBean stBean = (ScheduleTblBean)AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.get(__LOG_DATA__.getProperty(LOG_MAIL_ID));
		
		if(stBean==null){
			stBean = new ScheduleTblBean(__LOG_DATA__.getProperty(LOG_MAIL_ID));
			AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.put(__LOG_DATA__.getProperty(LOG_MAIL_ID), stBean);
		}
		
		String domain_key = "";
		boolean lock= false;
		
		
		try {
			if( !__T_CODE__.equals("--") && !StringUtil.isNull(__LOG_DATA__.getProperty(LOG_DOMAIN))) {
				domain_key=__LOG_DATA__.getProperty(LOG_DOMAIN)+"_"+__LOG_DATA__.getProperty(LOG_T_DATE_YYYYMMDD);
				domainBean = (DomainUpdateBean)AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.get(domain_key);
				
				if(domainBean==null){
					lock = true;
					domainBean = new DomainUpdateBean(__LOG_DATA__.getProperty(LOG_DOMAIN),__LOG_DATA__.getProperty(LOG_T_DATE_YYYYMMDD));	
					AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.put(domain_key, domainBean);
				}	
				
				domainBean.addCodeCnt("MASS", __T_CODE__);
				domainBean.addDur("MASS", __T_CODE__, __LOG_DATA__.getProperty(LOG_DELAY));
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
		}

		int __QUE_STEP__ = 0;

		try {
			__QUE_STEP__ = Integer.parseInt(__LOG_DATA__.getProperty(LOG_STEP));
		}
		catch(Exception _ex) {
		}
		
		/**
		 * 54-00 메일발송시작 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("--") ) {
			if( __QUE_STEP__ != 0 ) {
				return "QUE OR EXT SEND";
			}
			
			stBean.addPush();
			
			return "START";
		}
		
		
		/**
		 * 54-10 발송성공에 대한 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("00") ) {
			
			if( __QUE_STEP__ > 0 ) {
				
				eMsResultSet RS = null;
				try {
					RS = executeQuery(EMS_STATEMENT,QUERY_SELECT_CURRENT_OLD_ERROR_CODE, __LOG_DATA__);
					
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
						String curr = __LOG_DATA__.getProperty("OLD_CODE");
						if( curr.equals("00") )
							return "BEFORE SUCCESS AND NOW SUCCESS?";
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null) {
						RS.close();
					}
				}
			}
			
			if( __QUE_STEP__ > 0 ) {
				stBean.minusErrorCnt(__LOG_DATA__.getProperty("OLD_CODE"));
				return "QUE SUCCESS OK";
			}

			return "1ST OK";
		}

		if( __T_TYPE__.equals("55") && __T_CODE__.equals("00") ) {
			return "OK";
		}

		if( __T_TYPE__.equals("55") ) {
			if( __QUE_STEP__ > 0 ) {
				eMsResultSet RS = null;
				try {
					RS = executeQuery(EMS_STATEMENT,QUERY_SELECT_CURRENT_OLD_ERROR_CODE, __LOG_DATA__);
					
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null) {
						RS.close();
					}
				}
				
				if( __T_CODE__.equals(__LOG_DATA__.getProperty("OLD_CODE")) ) {
					return "QUE SAME ERROR SKIP";
				}
			}

			if( __QUE_STEP__ > 0 ) {
				stBean.minusErrorCnt(__LOG_DATA__.getProperty("OLD_CODE"));
				stBean.addErrorCnt(__T_CODE__);	
				return "QUE DEF ERROR OK";
			}

			stBean.addErrorCnt(__T_CODE__);
			stBean.addFailCnt();
			
			return "FIRST ERROR OK";
		}
		return "NO UPDATE";
	}

	/**
	 */
	protected eMsResultSet executeQuery(eMsStatement EMS_STATEMENT, String query , Object obj ) throws Exception{
		TMP_WORK_BUFFER.setLength( 0 );
		StringConvertUtil.ConvertString( TMP_WORK_BUFFER , query , obj , "${" , "}" , true , false );
		return EMS_STATEMENT.executeQuery( TMP_WORK_BUFFER.toString() );
	}

	public String update(Object log) throws Exception {
		return null;
	}
	
	
}
