/*
 * @(#)SsLifeAutoAnalyzerMainTask.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package moon.logprocess.task;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import moon.logprocess.module.AdditionalAction;
import moon.logprocess.module.BackLogWriter;
import moon.logprocess.module.LogFileFilter;
import moon.logprocess.module.LogFileNamePatch;
import moon.logprocess.module.LogFileNamingRule;
import moon.logprocess.module.LogFileReader;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.live.monitor.MonitorInfoCollector;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.log.LogFilter;
import pluto.log.LogParser;
import pluto.log.LogUpdator;
import pluto.schedule.Task;
import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;

/**
 * Class description :
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public class SsLifeAutoAnalyzerMainTask extends Task {

	private static final String			NULL_LOG_UPDATOR_CLASS_NAME	= "pluto.common.log.NullLogUpdator";

	private static final String			DEFAULT_READER_CLASS_NAME	= "moon.logprocess.module.LineReadLogFileReader";

	protected static long				_CHECK_INTERVAL_			= 1L;

	protected static String				_TARGET_LOG_DIRECTORY_		= null;

	protected static String				_BACK_LOG_DIRECTORY_		= null;

	protected static LogParser			_LOG_PARSER_				= null;

	protected static LogFilter			_LOG_FILTER_				= null;

	protected static LinkedList			_DB_PRE_UPDATOR_			= null;

	protected static LogUpdator			_DB_UPDATOR_				= null;

	protected static LogFileFilter		_TARGET_LOG_FILE_FILTER_	= null;

	protected static LogFileFilter		_BACK_LOG_FILE_FILTER_		= null;

	protected static LogFileReader		_TARGET_LOG_READER_			= null;

	protected static BackLogWriter		_BACK_LOG_WRITER_			= null;

	protected static LogFileNamingRule	_TARGET_LOG_NAMING_RULE_	= null;

	protected static LogFileNamingRule	_BACK_LOG_NAMING_RULE_		= null;

	protected static LogFileNamePatch	_TARGET_LOG_NAME_PATCH_		= null;

	protected static LogFileNamePatch	_BACK_LOG_NAME_PATCH_		= null;

	private static LinkedList			INNER_ADD_ACTIONS			= null;

	protected static LogChannel			ERROR_LOG_CHANNEL_INSTANCE	= null;

	
	
	
	
	
	
	
	protected static String				MOBILE_DEVICE_USEYN					= null;
	
	protected static String 			m_QUERY_SELECT_MOBILE_DEVICE_INFO 	= "";
	
	protected static PreparedStatement	EMS_P_STATEMENT						= null;
	
	protected static ArrayList				MOBILE_DEVICE_LIST					= null;
	
	public static ResultSet				MOBILE_RS							= null;
	
	// 모바일업데이터 수정 2011.05.25
	protected static String MOBILE_DEVICE_UPDATOR_URL = "";
	
	protected static String MOBILE_DEVICE_UPDATOR_FILENAME = "";
	
	protected static String MOBILE_DEVICE_UPDATOR_FILE_DELIM = "";	
	
	//protected static MobileDeviceUpdator MOBILE_DEVICE_UPDATOR = null;
	
	protected static String MOBILE_DEVICE_FILE_PATH = "";	
	
	
	
	
	
	
	public synchronized static void init(Object o_prop) throws Exception {
		Properties prop = (Properties) o_prop;

		Properties __SETUP_PROPERTY__ = new Properties();

		/**
		 * 파서 클래스와 업데이트 클래스 장전.
		 */
		log.debug("[LOAD]LogParser .... ");
		_LOG_PARSER_ = (LogParser) Class.forName(prop.getProperty("parser.class")).newInstance();
		_LOG_PARSER_.setParsingRules(o_prop);
		log.debug("[LOAD]LogParser .... [OK]");

		/**
		 * 메인 업데이트 하기전에 뭔가 업데이트하거나 로그에 대한 처리가 필요할 경우를 위한 일단은 트래킹 업데이트에서 에러로 마킹된 녀석이 들어올때를 대비한기 위한 물론 정의되지 않았다면 아무일도 하지 않는 NullLogUpdator 를 로딩한다.
		 */
		log.debug("[LOAD]Pre Updator .... ");
		_DB_PRE_UPDATOR_ = new LinkedList();
		String pre_class = prop.getProperty("pre.updator.class", NULL_LOG_UPDATOR_CLASS_NAME);
		eMsStringTokenizer TMP_TOKEN = new eMsStringTokenizer();
		TMP_TOKEN.parse(pre_class, ",");

		while (TMP_TOKEN.hasMoreTokens()) {
			String tmp_class = TMP_TOKEN.nextToken();
			log.debug("[LOAD]Pre Updator sub classes=>" + tmp_class);
			LogUpdator tmpUpdator = (LogUpdator) Class.forName(tmp_class).newInstance();
			tmpUpdator.setUpdateRules(o_prop);
			_DB_PRE_UPDATOR_.add(tmpUpdator);
		}
		log.debug("[LOAD]Pre Updator .... [OK]");

		log.debug("[LOAD]LogUpdator .... ");
		_DB_UPDATOR_ = (LogUpdator) Class.forName(prop.getProperty("updator.class")).newInstance();
		_DB_UPDATOR_.setUpdateRules(o_prop);
		log.debug("[LOAD]LogUpdator .... [OK]");

		log.debug("[LOAD]LogFilter .... ");
		_LOG_FILTER_ = (LogFilter) Class.forName(prop.getProperty("filter.class")).newInstance();
		_LOG_FILTER_.setFilteringRules(o_prop);
		log.debug("[LOAD]LogFilter .... [OK]");

		/**
		 * 타겟로드의 정보를 초기화 한다.
		 */
		__SETUP_PROPERTY__.clear();

		log.debug("[INIT]Target Parameters .... ");
		for (Enumeration ENUM = prop.keys(); ENUM.hasMoreElements();) {
			String key = (String) ENUM.nextElement();

			if( key.startsWith("target.") ) {
				__SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
			}
		}
		log.debug("[INIT]Target Parameters ....[OK] ");

		/*
		 * target. 으로 시작 되는 녀석들만 추려서 Properties로 만든다은 NamingRule을 초기화 한다.
		 */
		log.debug("[INIT]Target NamingRule .... ");
		_TARGET_LOG_NAMING_RULE_ = (LogFileNamingRule) Class.forName(prop.getProperty("target.naming.rule")).newInstance();

		_TARGET_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]Target NamingRule ....[OK] ");

		/*
		 * NamingRule 과 마찬가지 방식으로 NamePatch를 초기화 한다.
		 */
		log.debug("[INIT]Target NamePatch .... ");
		_TARGET_LOG_NAME_PATCH_ = (LogFileNamePatch) Class.forName(prop.getProperty("target.name.patch")).newInstance();

		_TARGET_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]Target NamePatch ....[OK] ");

		/*
		 * NamingRule 과 마찬가지 방식으로 로그 파일 필터 초기화
		 */
		log.debug("[INIT]Target LogFileFilter .... ");
		_TARGET_LOG_FILE_FILTER_ = (LogFileFilter) Class.forName(prop.getProperty("target.name.filter")).newInstance();
		_TARGET_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("target.log.dir"));
		_TARGET_LOG_FILE_FILTER_.setNameRule(_TARGET_LOG_NAMING_RULE_);
		_TARGET_LOG_FILE_FILTER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
		log.debug("[INIT]Target LogFileFilter ....[OK] ");

		/*
		 * 로그 리더 초기화
		 */
		log.debug("[INIT]Target LogFileReader .... ");
		_TARGET_LOG_READER_ = (LogFileReader) Class.forName(prop.getProperty("target.reader.class", DEFAULT_READER_CLASS_NAME)).newInstance();
		_TARGET_LOG_READER_.setFileFilter(_TARGET_LOG_FILE_FILTER_);
		_TARGET_LOG_READER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
		_TARGET_LOG_READER_.setNamingRule(_TARGET_LOG_NAMING_RULE_);
		log.debug("[INIT]Target LogFileReader ....[OK] ");

		// 타겟로그쪽 설정 종료

		/**
		 * 백로그쪽 파라미터 초기화
		 */
		__SETUP_PROPERTY__.clear();

		log.debug("[INIT]BackupLog Parameters .... ");
		for (Enumeration ENUM = prop.keys(); ENUM.hasMoreElements();) {
			String key = (String) ENUM.nextElement();

			if( key.startsWith("update.") ) {
				__SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
			}
		}
		log.debug("[INIT]BackupLog Parameters ...[OK]. ");

		/*
		 * update. 으로 시작 되는 녀석들만 추려서 Properties로 만든다은 NamingRule을 초기화 한다.
		 */
		log.debug("[INIT]BackupLog LogFileNamingRule .... ");
		_BACK_LOG_NAMING_RULE_ = (LogFileNamingRule) Class.forName(prop.getProperty("update.naming.rule")).newInstance();
		_BACK_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]BackupLog LogFileNamingRule ....[OK] ");

		/*
		 * NamingRule 과 마찬가지 방식으로 NamePatch를 초기화 한다.
		 */
		log.debug("[INIT]BackupLog LogFileNamePatch .... ");
		_BACK_LOG_NAME_PATCH_ = (LogFileNamePatch) Class.forName(prop.getProperty("update.name.patch")).newInstance();
		_BACK_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]BackupLog LogFileNamePatch ....[OK] ");

		/*
		 * 파일 필터 초기화 한다.
		 */
		log.debug("[INIT]BackupLog LogFileFilter .... ");
		_BACK_LOG_FILE_FILTER_ = (LogFileFilter) Class.forName(prop.getProperty("update.name.filter")).newInstance();
		_BACK_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("update.log.dir"));
		_BACK_LOG_FILE_FILTER_.setNameRule(_BACK_LOG_NAMING_RULE_);
		_BACK_LOG_FILE_FILTER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
		log.debug("[INIT]BackupLog LogFileFilter ....[OK] ");

		/*
		 * 로그 Writer 초기화
		 */
		log.debug("[INIT]BackupLog BackLogWriter .... ");
		_BACK_LOG_WRITER_ = new BackLogWriter();
		_BACK_LOG_WRITER_.setFileFilter(_BACK_LOG_FILE_FILTER_);
		_BACK_LOG_WRITER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
		_BACK_LOG_WRITER_.setNamingRule(_BACK_LOG_NAMING_RULE_);
		log.debug("[INIT]BackupLog BackLogWriter ....[OK] ");

		/**
		 * 추가적인 적업 AdditionalAction이 있는지 체크하여 초기화 한다.
		 */
		String add_action_class = prop.getProperty("addtional.action.class");

		if( add_action_class != null ) {
			TMP_TOKEN = new eMsStringTokenizer();
			TMP_TOKEN.parse(add_action_class, ",");

			INNER_ADD_ACTIONS = new LinkedList();

			while (TMP_TOKEN.hasMoreTokens()) {
				String __CLASS_NAME__ = TMP_TOKEN.nextToken();
				AdditionalAction __ADDITIONAL_ACTION__ = (AdditionalAction) (Class.forName(__CLASS_NAME__).newInstance());
				__ADDITIONAL_ACTION__.init(o_prop);
				INNER_ADD_ACTIONS.addLast(__ADDITIONAL_ACTION__);
			}
		}

		_BACK_LOG_DIRECTORY_ = prop.getProperty("update.log.dir");

		// 에러난 로그들은 저장할 로거를 세팅
		String LOGCHANNEL_ID = prop.getProperty("logger.id");

		if( LOGCHANNEL_ID == null ) {
			log.error("ERROR LOGCHANNEL IS NOT SET.......");
		}
		else {
			if (log.isDebugEnabled()) {
				log.debug("ERROR LOGGER=>" + LOGCHANNEL_ID);
			}
			ERROR_LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
		}

		log.debug("[init]LogUpdateTask .... [OK]");
		
		
		
		
		
		
		if(prop.containsKey("mobile.stat.use"))
		{
			MOBILE_DEVICE_USEYN = prop.getProperty("mobile.stat.use");
			
			if(MOBILE_DEVICE_USEYN.equals("Y"))
			{
				MOBILE_DEVICE_UPDATOR_URL = prop.getProperty("mobile.device.updator.url");
				
				MOBILE_DEVICE_UPDATOR_FILENAME = prop.getProperty("mobile.device.updator.file.name");
				
				MOBILE_DEVICE_UPDATOR_FILE_DELIM = prop.getProperty("mobile.device.updator.file.delim");
				
				MOBILE_DEVICE_FILE_PATH = prop.getProperty("mobile.device.file.path");
				
				// mobile device info update from CS Server... 2011.05.26 htj
				/*
				MobileDeviceUpdator mdu = new MobileDeviceUpdator(MOBILE_DEVICE_UPDATOR_URL, 
						MOBILE_DEVICE_UPDATOR_FILENAME, 
						MOBILE_DEVICE_UPDATOR_FILE_DELIM,
						MOBILE_DEVICE_FILE_PATH);
				
				mdu.deviceListUpdate();
				*/
				m_QUERY_SELECT_MOBILE_DEVICE_INFO = SqlManager.getQuery("MOBILE_DEVICE_CHECK", "QUERY_SELECT_MOBILE_DEVICE_INFO");
			}
		}
		else
		{
			MOBILE_DEVICE_USEYN = "N";
		}
		
		
		
		
		
		
		
		
		
		
	}

	protected eMsConnection	EMS_CONNECTION	= null;

	/** Creates new AnalyzerMainTask */
	public SsLifeAutoAnalyzerMainTask() {
		super(TYPE_INTERVAL, _CHECK_INTERVAL_);
		this.setName("SsLifeAutoAnalyzerMainTask");
		this.setTaskID("SsLifeAutoAnalyzerMainTask");
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {
		EMS_CONNECTION = ConnectionPool.getConnection();
		
		
		
		
		
		
		
		try
		{
			if(MOBILE_DEVICE_USEYN.equals("Y"))
			{
				MOBILE_DEVICE_LIST = new ArrayList<String>();
				
				EMS_P_STATEMENT = EMS_CONNECTION.prepareStatement(m_QUERY_SELECT_MOBILE_DEVICE_INFO);
				
				MOBILE_RS = EMS_P_STATEMENT.executeQuery();
				
				while(MOBILE_RS.next())
				{
					String mobile_entry = MOBILE_RS.getString("MB_DEVICE");
					
					MOBILE_DEVICE_LIST.add(mobile_entry);
				}
				
				EMS_P_STATEMENT.close();
			}
		}
		catch(Exception e)
		{
			log.error(e.getMessage());
		}
		finally
		{
			if(EMS_P_STATEMENT != null)
			{
				EMS_P_STATEMENT.close();
			}
		}
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(getName(), thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다. execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.close();
		SsLifeAutoAnalyzerMainTask._BACK_LOG_WRITER_.close();
		SsLifeAutoAnalyzerMainTask._DB_UPDATOR_.clear_connection();
		for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
			LogUpdator tmpUpdator = (LogUpdator) iter.next();
			tmpUpdator.clear_connection();
		}
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycle();
		}
	}

	public synchronized void execute() throws Exception {
		SsLifeAutoAnalyzerMainTask._DB_UPDATOR_.init_connection(EMS_CONNECTION); //SendLogTypeUpdator
		SsLifeAutoAnalyzerMainTask._DB_UPDATOR_.setStart();

		for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) { //NullLogUpdator
			LogUpdator tmpUpdator = (LogUpdator) iter.next();
			tmpUpdator.init_connection(EMS_CONNECTION);
			tmpUpdator.setStart();
		}

		if (log.isDebugEnabled()) 
			log.debug(" get Connection  INIT OK ");

		work(EMS_CONNECTION);

		if( SsLifeAutoAnalyzerMainTask.INNER_ADD_ACTIONS != null ) {
			for (Iterator iter = SsLifeAutoAnalyzerMainTask.INNER_ADD_ACTIONS.iterator(); iter.hasNext();) {
				AdditionalAction __INNER_ADDITIONAL_ACTION__ = (AdditionalAction) iter.next();
				if( __INNER_ADDITIONAL_ACTION__.isValidTime() ) {
					try {
						__INNER_ADDITIONAL_ACTION__.init_connection(EMS_CONNECTION);
						__INNER_ADDITIONAL_ACTION__.execute();
					}
					catch(Throwable e) {
						log.error(e.getMessage());
					}
					finally {
						__INNER_ADDITIONAL_ACTION__.clean();
					}
				}
			}
		}
		SsLifeAutoAnalyzerMainTask._DB_UPDATOR_.setEnd();
		for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
			LogUpdator tmpUpdator = (LogUpdator) iter.next();
			tmpUpdator.setEnd();
		}
	}

	protected void work(eMsConnection EMS_CONNECTION) throws Exception {
		if (log.isDebugEnabled()) {
			log.debug(" Start work ");
		}

		String __START_LOG_FILE_NAME__ = null;
		String __LAST_LOG_STRING__ = null;

		long __START_LOG_FILE_POINT__ = 0L;

		String __FINAL_BACK_LOG_FILE__ = SsLifeAutoAnalyzerMainTask._BACK_LOG_FILE_FILTER_.getLastFilename();

		// 백로그가 존재하고 대상이 되는 타겟로그가 없는 경우를 체크해야한다. 만일 타겟 로그가 존재하지 않는다면 백로그를 지우고
		// 한스텝을 종료한다.
		if( __FINAL_BACK_LOG_FILE__ != null ) {
			__START_LOG_FILE_NAME__ = SsLifeAutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInverseInfo(SsLifeAutoAnalyzerMainTask._BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));

			log.info("Target Back Log File => ".concat(__FINAL_BACK_LOG_FILE__));

			if( !(new File(SsLifeAutoAnalyzerMainTask._TARGET_LOG_FILE_FILTER_.getFullName(__START_LOG_FILE_NAME__))).exists() ) {
				log.info("Target Log File Not Exist.... so Delete BackLog ");
				boolean fileDel = (new File(__FINAL_BACK_LOG_FILE__)).delete();
				if(!fileDel) log.error("File deletion failed");				
				log.debug( "Miss Match BackLog Delete => ".concat(__FINAL_BACK_LOG_FILE__));
				return;
			}
		}

		if( __FINAL_BACK_LOG_FILE__ == null ) {
			// 백업파일이 존재하지 않는 경우
			if (log.isDebugEnabled()) 
				log.debug("Backup Log File Not Exist.... so Check First Target Log File.. ");
			__START_LOG_FILE_NAME__ = SsLifeAutoAnalyzerMainTask._TARGET_LOG_FILE_FILTER_.getNextFilename();

			if( __START_LOG_FILE_NAME__ == null ) {
				if (log.isDebugEnabled()) 
					log.debug("Start Target Log File is Not Exist.. so return... ");
				return;
			}

			try {
				if (log.isDebugEnabled()) 
					log.debug("Open Target Log File [0] : " + __START_LOG_FILE_NAME__);
				SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, 0L);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}
		}
		else {
			// 백로그 파일이 존재할경우
			__START_LOG_FILE_NAME__ = SsLifeAutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInverseInfo(SsLifeAutoAnalyzerMainTask._BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
			// 마지막 백로그 파일에서 마지막라인을 가져온다.
			if (log.isDebugEnabled()) 
				log.debug("Choose Target Log File : " + __START_LOG_FILE_NAME__);
			try {
				__LAST_LOG_STRING__ = LogFileReader.getLastLine(SsLifeAutoAnalyzerMainTask._BACK_LOG_DIRECTORY_ + "/" + __FINAL_BACK_LOG_FILE__);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}

			// 백업파일의 마지막 라인을 읽어서 원본의 포인터를 찾는다.
			try {
				__START_LOG_FILE_POINT__ = LogFileReader.getFileID(__LAST_LOG_STRING__);
			}
			catch(Exception _ex) {
				__START_LOG_FILE_POINT__ = 0L;
			}

			if (log.isDebugEnabled()) 
				log.debug("Choose Target Log File Pointer: " + String.valueOf(__START_LOG_FILE_POINT__));

			try {
				SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, __START_LOG_FILE_POINT__);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}
		}

		if (log.isDebugEnabled()) {
			log.debug("Set Start log file : " + __START_LOG_FILE_NAME__);
			log.debug("Set Last log String : " + __LAST_LOG_STRING__);
			log.debug("Set Work BackLogFile : " + __FINAL_BACK_LOG_FILE__);
		}

		try {
			SsLifeAutoAnalyzerMainTask._BACK_LOG_WRITER_.openFile(SsLifeAutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInfo(__START_LOG_FILE_NAME__));
		}
		catch(Throwable e) {
			log.error(e.getMessage());
			return;
		}

		Object _LOG_INFO_ = null;

		// int __UPDATE_COUNT__ = 0;

		String __UPDATE_RESULT_STRING__ = null;

		do {
			__LAST_LOG_STRING__ = SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.readLine();

			__START_LOG_FILE_POINT__ = SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.getFilePoint();

			if( __LAST_LOG_STRING__ == null ) {
				if (log.isDebugEnabled()) {
					log.debug("Check Next LogFile .... ");
				}

				if( SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.next() ) {
					if (log.isDebugEnabled()) 
						log.debug("Switch Next LogFile .... ".concat(SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName()));
					SsLifeAutoAnalyzerMainTask._BACK_LOG_WRITER_.openFile(SsLifeAutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInfo(SsLifeAutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName()));
					continue;
				}

				return;
			}
			else if( __LAST_LOG_STRING__.trim().length() >= 2 ) {
				// 업데이트한 라인수를 스테이터스에 업되이트 한다.
				pluto.net.communicator.ServerStatusInfo.plusUpdateCnt();
				MonitorInfoCollector.addCntUpdate(); // 엡데이트시도하는 모든 카운트

				try {
					if (log.isDebugEnabled()) {
						log.debug(__LAST_LOG_STRING__);
					}
					// 로그를 파싱하고
					_LOG_INFO_ = SsLifeAutoAnalyzerMainTask._LOG_PARSER_.parse(__LAST_LOG_STRING__);

					if( _LOG_INFO_ == null ) {
						// 로그정보가 파싱이 안되므로 그냥 스킵
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", "invalid log");
						MonitorInfoCollector.addCntUpdateFail(); // 엡데이트실패하는 모든 카운트
						continue;
					}

					if( _LOG_INFO_ instanceof String ) {
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", _LOG_INFO_.toString());
						MonitorInfoCollector.addCntUpdateFail(); // 엡데이트실패하는 모든 카운트
						continue;
					}

					// 로그를 필터링 하면서 바꾸고
					_LOG_INFO_ = SsLifeAutoAnalyzerMainTask._LOG_FILTER_.convert(_LOG_INFO_);

					if( _LOG_INFO_ instanceof String ) {
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", _LOG_INFO_.toString());
						MonitorInfoCollector.addCntUpdateFail(); // 엡데이트실패하는 모든 카운트
						continue;
					}

					//전처리기를 돌려준다.
					for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
						LogUpdator tmpUpdator = (LogUpdator) iter.next();
						try {
							tmpUpdator.update(_LOG_INFO_);
						}
						catch(Throwable _ex) {
							log.error("Exception",_ex);
						}
					}

					try {
						// 필터링이 종료되고 실제 업데이트 하는 로직이 들어감..
						__UPDATE_RESULT_STRING__ = SsLifeAutoAnalyzerMainTask._DB_UPDATOR_.update(_LOG_INFO_);
					}
					catch(Throwable ex_) {
						if( ERROR_LOG_CHANNEL_INSTANCE != null ) {
							ERROR_LOG_CHANNEL_INSTANCE.write(__LAST_LOG_STRING__);
						}
						log.error(getName(), ex_);
						if (log.isDebugEnabled()) 
							log.error("Exception",ex_);
						if( ex_ instanceof SQLException ) {
							SsLifeAutoAnalyzerMainTask._DB_UPDATOR_.ensureDBConnection();
						}
						__UPDATE_RESULT_STRING__ = ex_.toString().replace('\r', ' ').replace('\n', ' ');
					}
					appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", __UPDATE_RESULT_STRING__);
				}
				catch(Throwable e) {
					log.error(getName(), e);
					try {
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", StringUtil.nl2blank(e.toString().trim()));
					}
					catch(Throwable _ex) {
						log.error(getName(), _ex);
					}

					MonitorInfoCollector.addCntUpdateFail(); // 엡데이트실패하는 모든 카운트
					return;
				}
			}
		} while (true);
	}

	protected void appendBackLog(long __START_LOG_FILE_POINT__, String __LAST_LOG_STRING__, String result, String ext) throws Throwable {
		SsLifeAutoAnalyzerMainTask._BACK_LOG_WRITER_.append(String.valueOf(__START_LOG_FILE_POINT__), __LAST_LOG_STRING__.concat(result).concat(ext));
	}
}
