package moon.logprocess.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

import moon.logprocess.bean.AutoRemainBean;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import mars.tracking.parser.TrackingApacheLogParser;
import pluto.log.LogChannel;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

/**
 * Class description :
 * 
 * @version
 * @author joo
 *  
 */
@Slf4j
public class AutoRemainSendTask extends Task {

	protected static long				_CHECK_INTERVAL_			= 1L;

	protected static LogChannel			ERROR_LOG_CHANNEL_INSTANCE	= null;
	
	protected static ArrayList		REMAIN_CAMP_LIST = null;
	
	protected static ArrayList		REMAIN_OLD_CAMP_LIST = null;
	
	protected static Properties	DO_ACT_CAMP = null;//재발송을 한번이라도 했던 캠페인
	
	private String now_time = "";
	
	private String before_30min = "";
	
	protected static StringBuffer TMP_WORK_BUFFER = null;
	
	public static int REMAIN_ACT_CNT = 0;
	
	public static int WAIT_TIME = 0;
	
	//-- DB --
	protected eMsConnection	EMS_CONNECTION	= null;
	protected eMsStatement	EMS_UPDATE_STATEMENT = null;
	protected eMsStatement	EMS_RESEND_STATEMENT = null;
	protected eMsResultSet EMS_RESULTSET = null;
	//--------
	
	public static String			QUERY_REMAIN_MAIL_LIST	= null;
	public static String			QUERY_REMAIN_RESEND_UPDATE	= null;	
	
	
	public synchronized static void init(Object o_prop) throws Exception {

		Properties prop = (Properties) o_prop;
		
		REMAIN_ACT_CNT = Integer.parseInt( prop.getProperty("remain.act.cnt", "2") )-1;
		log.debug("[init] REMAIN_ACT_CNT .... "+REMAIN_ACT_CNT);
		
		WAIT_TIME = Integer.parseInt( prop.getProperty("wait.time", "30") )*(-1);
		log.debug("[init] WAIT_TIME .... "+WAIT_TIME);
		
		try {
			QUERY_REMAIN_MAIL_LIST = SqlManager.getQuery("REMAIN_SEND_QUERY", "QUERY_REMAIN_MAIL_LIST");
			QUERY_REMAIN_RESEND_UPDATE = SqlManager.getQuery("REMAIN_SEND_QUERY", "QUERY_REMAIN_RESEND_UPDATE");
			
			log.debug("[init] query .... [OK]");
		}
		catch(Exception e) {
			log.error("Exception",e);
			System.exit(1);
		}
		
		REMAIN_CAMP_LIST = new ArrayList();
		DO_ACT_CAMP = new Properties();
		
		TMP_WORK_BUFFER = new StringBuffer();
		
		log.debug("[init]RemainSendTask .... [OK]");
	}

	
	/** Creates new RemainSendTask */
	public AutoRemainSendTask() {
		super(TYPE_INTERVAL, _CHECK_INTERVAL_);
		this.setName("AutoRemainSendTask");
		this.setTaskID("AutoRemainSendTask");
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {		
		EMS_CONNECTION = ConnectionPool.getConnection();
		if(log.isDebugEnabled()) log.debug("[execute_initiate] connection .... [OK]");
		
		EMS_UPDATE_STATEMENT = EMS_CONNECTION.createStatement();
		if(log.isDebugEnabled()) log.debug("[execute_initiate] update statement .... [OK]");
		
		EMS_RESEND_STATEMENT = EMS_CONNECTION.createStatement();
		if(log.isDebugEnabled()) log.debug("[execute_initiate] resend statement .... [OK]");
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(getName(), thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다. execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		
		if(EMS_UPDATE_STATEMENT != null){
			EMS_CONNECTION.recycleStatement(EMS_UPDATE_STATEMENT);
			if(log.isDebugEnabled()) log.debug("[release_Resource] update statement .... [OK]");
		}
		
		if(EMS_RESEND_STATEMENT != null){
			EMS_CONNECTION.recycleStatement(EMS_RESEND_STATEMENT);
			if(log.isDebugEnabled()) log.debug("[release_Resource] resend statement .... [OK]");
		}
		
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycle();
			if(log.isDebugEnabled()) log.debug("[release_Resource] connection .... [OK]");
		}
	}

	public synchronized void execute() throws Exception {
	
		// 다시 REMAIN_CAMP_LIST 를 구성하기 위해  REMAIN_OLD_CAMP_LIST으로 값을 넘기고 새로이 생성한다.
		REMAIN_OLD_CAMP_LIST =REMAIN_CAMP_LIST;
		REMAIN_CAMP_LIST= new ArrayList();
		
		now_time =Cal.getSerialDate();
		before_30min =AutoRemainSendTask.getAddMin(WAIT_TIME);
		
		
		if(log.isDebugEnabled()){
			log.debug("[now_time]:"+now_time+" [before_"+WAIT_TIME+"min]:"+before_30min);
		}
		
		//----------------------------------
		AutoRemainBean bean = null;
		String bean_id = "";
		Properties bean_info = new Properties();
		int update_return = 0;
		int while_cnt=0;
		
		EMS_RESULTSET = EMS_UPDATE_STATEMENT.executeQuery( QUERY_REMAIN_MAIL_LIST );
		
		while(EMS_RESULTSET.next()){
			if (log.isDebugEnabled()) {
				log.debug("[EMS_UPDATE_STATEMENT] ACT_CNT:"+(++while_cnt));
			}
			
			bean_id = EMS_RESULTSET.getString("WORKDAY")+"_"+EMS_RESULTSET.getString("SEQNO");
			
			// 3번 실행했다면 더이상 실행하지 않는다.
			//------------------------------------------------------------------------------
			String doActCamp_str = DO_ACT_CAMP.getProperty(bean_id);
			if(doActCamp_str!=null && doActCamp_str.equals(""+REMAIN_ACT_CNT)){
				if(log.isDebugEnabled()) log.debug("["+bean_id+"] - 3times ACT : SKIP!!");
				continue;
			}
			//------------------------------------------------------------------------------
			
			bean = isBeanInList(bean_id);
			
			//이전 타임에 존재했다면 비교한다.
			if(bean!=null){
				if(log.isDebugEnabled()) log.debug("["+bean_id+"] - before list:match. [ACT:COMPARE]");
				
				//pushed_cnt 가 같다. 즉 변화가 없다. 관심을 가져야할 상황이다.
				if(bean.samePushCnt(EMS_RESULTSET.getString("PUSHED_CNT"))){
					if(log.isDebugEnabled()) log.debug("["+bean_id+"] - pushed_cnt:no change. [ACT:ATTANTION]");
					
					if(bean.doActTime(before_30min)){ //변화가 없어진지 30분이 지났다면 재발송을 해야한다.
						log.debug("["+bean_id+"] - check_time: over 30minute. [ACT: RESEND(job_status-35)]");
						
						
						//mapping info
						bean_info.clear();	
						bean_info.setProperty("WORKDAY", bean.getWorkday());
						bean_info.setProperty("SEQNO", bean.getSeqno());
						
						//set query
						TMP_WORK_BUFFER.setLength( 0 );
						StringConvertUtil.ConvertString( TMP_WORK_BUFFER , QUERY_REMAIN_RESEND_UPDATE , bean_info , "${" , "}" , true , false );						
						if (log.isDebugEnabled())  log.debug( "update_exec=>" + TMP_WORK_BUFFER.toString() );
						
						//executeUpdate
						update_return = EMS_RESEND_STATEMENT.executeUpdate( TMP_WORK_BUFFER.toString() );
						
						if(update_return>0){//성공일 경우 실행했던 리스트에 등록한다.
							log.debug("[RESEND] ID:"+bean.getBeanId()+"<SUCCESS>");
							
							String act_cnt = DO_ACT_CAMP.getProperty(bean.getBeanId());
							
							if(act_cnt==null){
								DO_ACT_CAMP.setProperty(bean.getBeanId(), "1");
								log.debug("[DO_ACT_CAMP-ADD] ID:"+bean.getBeanId()+" [CNT]:1");
							}else{//존재했다면...
								DO_ACT_CAMP.setProperty(bean.getBeanId(), ""+(Integer.parseInt(act_cnt)+1) );
								log.debug("[DO_ACT_CAMP-MODY] ID:"+bean.getBeanId()+" [CNT]:"+ DO_ACT_CAMP.getProperty(bean.getBeanId()));
							}
						}else {
							log.debug("[RESEND] ID:"+bean.getBeanId()+"<FAIL>");
						}
						
//						REMAIN_CAMP_LIST.add(bean);
						// 다음 bean에 추가하지 않는다.
						
					}else{ // 30분이 지나지 않았다면 다시 두고 본다.
						if(log.isDebugEnabled()) log.debug("["+bean_id+"] - check_time: yet "+WAIT_TIME+"minute. [ACT: PASS & ATTANTION]");
						if(log.isDebugEnabled()) log.debug("\t\t\tcheck_time:"+bean.getCheck_time());
						REMAIN_CAMP_LIST.add(bean);
					}
					
				}else{//변화가 있다면 UPDATE가 진행중인것이다. 다시 세팅한 후 관리 list에 추가한다. 
					if(log.isDebugEnabled()) log.debug("["+bean_id+"] - pushed_cnt: change. [ACT: PASS & LOOK]");
					
					bean.setPushed_cnt(EMS_RESULTSET.getString("PUSHED_CNT")); //현재 push_cnt를 세팅한다.
					bean.setCheck_time(now_time);  //현재 시간을 세팅한다.
					log.debug("\t\t[~ING] ID:"+bean.getBeanId()+" PUSH:"+EMS_RESULTSET.getString("PUSHED_CNT")+" CHECK_TIME:"+now_time);
					
					REMAIN_CAMP_LIST.add(bean);
				}
				
			}else {//새로이 생성됐다면 비교없이 관리 list에 추가한다.
				bean = new AutoRemainBean();
				
				bean.setWorkday(EMS_RESULTSET.getString("WORKDAY"));
				bean.setSeqno(EMS_RESULTSET.getString("SEQNO"));
				bean.setCycle_type(EMS_RESULTSET.getString("CYCLE_TYPE"));
				bean.setEnd_date(EMS_RESULTSET.getString("END_DATE"));
				bean.setTarget_cnt(EMS_RESULTSET.getString("TARGET_CNT"));
				bean.setPushed_cnt(EMS_RESULTSET.getString("PUSHED_CNT"));
				bean.setCheck_time(now_time);
				
				REMAIN_CAMP_LIST.add(bean);
				if(log.isDebugEnabled()) log.debug("["+bean_id+"] - before list: no match. [ACT:ADD REMAIN_CAMP_LIST]");
			}
		}
		
		//resultset 반환
		if(EMS_RESULTSET != null){
			EMS_RESULTSET.close();
		}
		
		//2일이 지난 것들은 리스트에서 삭제한다.
		int now_before_2day = Integer.parseInt(Cal.getAddDayDate(-1));
		cleanList(now_before_2day);
		//----------------------------------
		if (log.isDebugEnabled()) {
			log.debug("[execute] end");
		}
	}

	
	/**
	 * WORKING
	 * @param EMS_CONNECTION
	 * @throws Exception
	 */
	protected void work(eMsConnection EMS_CONNECTION) throws Exception {
		/**
		 * JOO - [RemainSendTask:4] work ACT
		 */
	}
	
	
	
	//-- UTIL --------------------------------------------------------------------------------
	/**
	 * TIME UTIL
	 * @param add_min
	 * @return
	 */
	public static String getAddMin(int add_min) {
		return Cal.getSerialDate(System.currentTimeMillis() + add_min * 1000 * 60);
	}	
	
	public static AutoRemainBean isBeanInList(String id){		
		if(REMAIN_OLD_CAMP_LIST.isEmpty()){
			return null;
		}else {
			int list_size = REMAIN_OLD_CAMP_LIST.size();
			AutoRemainBean extr = null;
			
			for(int i=0;i<list_size;i++){
				extr = (AutoRemainBean)REMAIN_OLD_CAMP_LIST.get(i);
				if(id.equals(extr.getBeanId())){
					return extr;
				}
			}
			
			return null;
		}
	}
	
	/**
	 * workday가 yyyymmdd인 campaign의 정보는 중복 액션 list에서 삭제한다. 
	 * @param yyyymmdd : 삭제 기준일
	 */
	public static void cleanList(int yyyymmdd){
		
		if(DO_ACT_CAMP.size() < 1){
			log.debug("[cleanList ACTION SKIP] - DUP LIST is Null");
			return;
		}
		
		int workday;
		String id_str="";
		for (Enumeration e = DO_ACT_CAMP.propertyNames() ; e.hasMoreElements() ;) {
			id_str = (String)e.nextElement();
			
			workday = Integer.parseInt( id_str.substring(0,8) );
			
			if(workday<yyyymmdd){
				DO_ACT_CAMP.remove(id_str);
				log.debug("[cleanList]  ID:"+id_str+" - remove in DO_ACT_CAMP ");
			}
	        
	     }		
	}
	
}
