
package moon.logprocess.task;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import moon.logprocess.module.AdditionalAction;
import moon.logprocess.module.BackLogWriterPps;
import moon.logprocess.module.LogFileFilterPps;
import moon.logprocess.module.LogFileNamePatch;
import moon.logprocess.module.LogFileNamingRule;
import moon.logprocess.module.LogFileReaderPps;
import moon.logprocess.updator.AutoMissSummary;
import moon.logprocess.updator.DomainUpdateBean;
import moon.logprocess.updator.ScheduleTblBean;
import pluto.common.bean.PlanBean;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.eMsFileWriter;
import pluto.log.Log;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.log.LogFilter;
import pluto.log.LogParser;
import pluto.log.LogUpdator;
import pluto.schedule.Task;
import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;

/**
 * Class description :
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public class AutoAnalyzerMainTask extends Task {

	private static final String			NULL_LOG_UPDATOR_CLASS_NAME	= "pluto.common.log.NullLogUpdator";

	private static final String			DEFAULT_READER_CLASS_NAME	= "moon.logprocess.module.LineReadLogFileReaderPps";

	protected static long				_CHECK_INTERVAL_			= 1L;

	protected static String				_TARGET_LOG_DIRECTORY_		= null;

	protected static String				_BACK_LOG_DIRECTORY_		= null;

	protected static LogParser			_LOG_PARSER_				= null;

	protected static LogFilter			_LOG_FILTER_				= null;

	protected static LinkedList			_DB_PRE_UPDATOR_			= null;

	protected static LogUpdator			_DB_UPDATOR_				= null;

	protected static LogFileFilterPps		_TARGET_LOG_FILE_FILTER_	= null;

	protected static LogFileFilterPps		_BACK_LOG_FILE_FILTER_		= null;

	protected static LogFileReaderPps		_TARGET_LOG_READER_			= null;

	protected static BackLogWriterPps		_BACK_LOG_WRITER_			= null;

	protected static LogFileNamingRule	_TARGET_LOG_NAMING_RULE_	= null;

	protected static LogFileNamingRule	_BACK_LOG_NAMING_RULE_		= null;

	protected static LogFileNamePatch	_TARGET_LOG_NAME_PATCH_		= null;

	protected static LogFileNamePatch	_BACK_LOG_NAME_PATCH_		= null;

	private static LinkedList			INNER_ADD_ACTIONS			= null;

	protected static LogChannel			ERROR_LOG_CHANNEL_INSTANCE	= null;
	
	
	//======= by joo ====================
	protected static int ACT_CNT = 0;	
	protected static long LAST_FILE_POINT = 0L;
	protected static String LAST_FILE_NAME = "";
	protected static eMsFileWriter LOG_PRC_CHANNEL = null;
	protected static String LOG_PRC_DIR = "";
	
	// summary type
	public static String	PRC_TARGET = null;
	
	protected static AutoMissSummary	AUTO_SUMMARY = null;
	
	// summary query
	protected static String QUERY_UPDATE_SEND_SUMMARY = SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_UPDATE_SEND_SUMMARY");
	protected static String QUERY_INSERT_SEND_SUMMARY = SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_INSERT_SEND_SUMMARY");	
	protected static String QUERY_UPDATE_70_SUMMARY	= SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_UPDATE_70_SUMMARY");	
	
	//flow plan data
	private static eMsPreparedStatement PPS_SELECT_FLOW_DATA = null;
	private static eMsPreparedStatement PPS_INSERT_FLOW_DATA = null;
	
	protected static String QUERY_SELECT_PLAN_INFO	  = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
	protected static String QUERY_INSERT_FLOW_DATA	  = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");
	
	protected StringBuffer LOG_WORK_BUFFER = new StringBuffer(512);
	
	// update count
	public static Hashtable AUTO_DOMAIN_PPT = new Hashtable();
	public static Hashtable AUTO_SCHEDULE_PPT = new Hashtable();
	
	// 한꺼번에 집계할 라인수
	public static int SUMMARY_CNT = 1000;
	//==================================
	
	public eMsPreparedStatement PPS_UPDATE_SEND_SUMMARY = null;
	public eMsPreparedStatement PPS_INSERT_SEND_SUMMARY = null;
	public eMsPreparedStatement PPS_UPDATE_70_SUMMARY = null;

	
	
	public synchronized static void init(Object o_prop) throws Exception {
		Properties prop = (Properties) o_prop;

		Properties __SETUP_PROPERTY__ = new Properties();

		
		
		SUMMARY_CNT = Integer.parseInt(prop.getProperty("summary.cnt","1000"));
		/**
		 * 파서 클래스와 업데이트 클래스 장전.
		 */
		log.debug("[LOAD]LogParser .... ");
		_LOG_PARSER_ = (LogParser) Class.forName(prop.getProperty("parser.class")).newInstance();
		
		//아무것도 하는일이 없음
		_LOG_PARSER_.setParsingRules(o_prop);
		log.debug("[LOAD]LogParser .... [OK]");
		
		/**
		 * 메인 업데이트 하기전에 뭔가 업데이트하거나 로그에 대한 처리가 필요할 경우를 위한 
		 * 일단은 트래킹 업데이트에서 에러로 마킹된 녀석이 들어올때를 대비한기 위한 
		 * 물론 정의되지 않았다면 아무일도 하지 않는 NullLogUpdator 를 로딩한다.
		 */
		log.debug("[LOAD]Pre Updator .... ");
		_DB_PRE_UPDATOR_ = new LinkedList();		
		//NullLogUpdator : 아무것도 하지 않는 빈 updator
		String pre_class = prop.getProperty("pre.updator.class", NULL_LOG_UPDATOR_CLASS_NAME);//pluto.common.log.NullLogUpdator
		eMsStringTokenizer TMP_TOKEN = new eMsStringTokenizer();
		TMP_TOKEN.parse(pre_class, ",");

		while (TMP_TOKEN.hasMoreTokens()) {
			String tmp_class = TMP_TOKEN.nextToken();
			log.debug("[LOAD]Pre Updator sub classes=>" + tmp_class);
			LogUpdator tmpUpdator = (LogUpdator) Class.forName(tmp_class).newInstance();
			tmpUpdator.setUpdateRules(o_prop);
			_DB_PRE_UPDATOR_.add(tmpUpdator);
		}
		log.debug("[LOAD]Pre Updator .... [OK]");

		
		
		log.debug("[LOAD]LogUpdator .... ");
		//pluto.common.log.SendLogTypeUpdator
		_DB_UPDATOR_ = (LogUpdator) Class.forName(prop.getProperty("updator.class")).newInstance();
		_DB_UPDATOR_.setUpdateRules(o_prop);//TYPE_UPDATE_HASH 세팅
		log.debug("[LOAD]LogUpdator .... [OK]");

		
		log.debug("[LOAD]LogFilter .... ");
		//jupiter.auto.log.filter.AutoSendLogFilter
		_LOG_FILTER_ = (LogFilter) Class.forName(prop.getProperty("filter.class")).newInstance();
		_LOG_FILTER_.setFilteringRules(o_prop); //아무작업도 없다.
		log.debug("[LOAD]LogFilter .... [OK]");

		
		/**
		 * 타겟로드의 정보를 초기화 한다.
		 */
		__SETUP_PROPERTY__.clear();

		log.debug("[INIT]Target Parameters .... ");
		for (Enumeration eNum = prop.keys(); eNum.hasMoreElements();) {
			String key = (String) eNum.nextElement();
			if( key.startsWith("target.") ) {
				__SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
			}
		}
		log.debug("[INIT]Target Parameters ....[OK] ");

		/*
		 * target. 으로 시작 되는 녀석들만 추려서 Properties로 만든다은 NamingRule을 초기화 한다.
		 */
		log.debug("[INIT]Target NamingRule .... ");//moon.logprocess.module.HeadTailLogFileNamingRule
		_TARGET_LOG_NAMING_RULE_ = (LogFileNamingRule) Class.forName(prop.getProperty("target.naming.rule")).newInstance();
		//초기화 : 추려낼 파일의 header 와 tail 을 세팅한다.
		_TARGET_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]Target NamingRule ....[OK] ");

		/*
		 * NamingRule 과 마찬가지 방식으로 NamePatch를 초기화 한다.
		 */
		log.debug("[INIT]Target NamePatch .... ");//moon.logprocess.module.HeadTailLogNamePatch
		_TARGET_LOG_NAME_PATCH_ = (LogFileNamePatch) Class.forName(prop.getProperty("target.name.patch")).newInstance();
		//초기화 : 추려낼 파일의 header 와 tail 을 세팅한다.
		_TARGET_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]Target NamePatch ....[OK] ");

		/*
		 * NamingRule 과 마찬가지 방식으로 로그 파일 필터 초기화
		 */
		log.debug("[INIT]Target LogFileFilterPps .... ");//moon.logprocess.module.LogFileFilterPps
		_TARGET_LOG_FILE_FILTER_ = (LogFileFilterPps) Class.forName(prop.getProperty("target.name.filter")).newInstance();
		//rule 과 pach 그리고 dir 을 세팅한다.
		_TARGET_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("target.log.dir"));
		_TARGET_LOG_FILE_FILTER_.setNameRule(_TARGET_LOG_NAMING_RULE_);
		_TARGET_LOG_FILE_FILTER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
		log.debug("[INIT]Target LogFileFilterPps ....[OK] ");

		/*
		 * 로그 리더 초기화
		 */
		log.debug("[INIT]Target LogFileReaderPps .... ");//moon.logprocess.module.LineReadLogFileReaderPps
		_TARGET_LOG_READER_ = (LogFileReaderPps) Class.forName(prop.getProperty("target.reader.class", DEFAULT_READER_CLASS_NAME)).newInstance();
		//filter patch rule 을 세팅한다.
		_TARGET_LOG_READER_.setFileFilter(_TARGET_LOG_FILE_FILTER_);
		_TARGET_LOG_READER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
		_TARGET_LOG_READER_.setNamingRule(_TARGET_LOG_NAMING_RULE_);
		log.debug("[INIT]Target LogFileReaderPps ....[OK] ");

		// 타겟로그쪽 설정 종료

		/**
		 * 백로그쪽 파라미터 초기화
		 */
		__SETUP_PROPERTY__.clear();

		log.debug("[INIT]BackupLog Parameters .... ");
		for (Enumeration eNum = prop.keys(); eNum.hasMoreElements();) {
			String key = (String) eNum.nextElement();

			if( key.startsWith("update.") ) {
				__SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
			}
		}
		log.debug("[INIT]BackupLog Parameters ...[OK]. ");

		/*
		 * update. 으로 시작 되는 녀석들만 추려서 Properties로 만든다은 NamingRule을 초기화 한다.
		 */
		log.debug("[INIT]BackupLog LogFileNamingRule .... ");
		_BACK_LOG_NAMING_RULE_ = (LogFileNamingRule) Class.forName(prop.getProperty("update.naming.rule")).newInstance();
		_BACK_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]BackupLog LogFileNamingRule ....[OK] ");

		/*
		 * NamingRule 과 마찬가지 방식으로 NamePatch를 초기화 한다.
		 */
		log.debug("[INIT]BackupLog LogFileNamePatch .... ");
		_BACK_LOG_NAME_PATCH_ = (LogFileNamePatch) Class.forName(prop.getProperty("update.name.patch")).newInstance();
		_BACK_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
		log.debug("[INIT]BackupLog LogFileNamePatch ....[OK] ");

		/*
		 * 파일 필터 초기화 한다.
		 */
		log.debug("[INIT]BackupLog LogFileFilterPps .... ");
		_BACK_LOG_FILE_FILTER_ = (LogFileFilterPps) Class.forName(prop.getProperty("update.name.filter")).newInstance();
		_BACK_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("update.log.dir"));
		_BACK_LOG_FILE_FILTER_.setNameRule(_BACK_LOG_NAMING_RULE_);
		_BACK_LOG_FILE_FILTER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
		log.debug("[INIT]BackupLog LogFileFilterPps ....[OK] ");

		/*
		 * 로그 Writer 초기화
		 */
		log.debug("[INIT]BackupLog BackLogWriterPps .... ");
		_BACK_LOG_WRITER_ = new BackLogWriterPps();
		_BACK_LOG_WRITER_.setFileFilter(_BACK_LOG_FILE_FILTER_);
		_BACK_LOG_WRITER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
		_BACK_LOG_WRITER_.setNamingRule(_BACK_LOG_NAMING_RULE_);
		log.debug("[INIT]BackupLog BackLogWriterPps ....[OK] ");
		
		/**
		 * 추가적인 적업 AdditionalAction이 있는지 체크하여 초기화 한다. 
		 */
		String add_action_class = prop.getProperty("addtional.action.class"); //값이 없다.

		if( add_action_class != null ) {
			TMP_TOKEN = new eMsStringTokenizer();
			TMP_TOKEN.parse(add_action_class, ",");

			INNER_ADD_ACTIONS = new LinkedList();

			while (TMP_TOKEN.hasMoreTokens()) {
				String __CLASS_NAME__ = TMP_TOKEN.nextToken();
				AdditionalAction __ADDITIONAL_ACTION__ = (AdditionalAction) (Class.forName(__CLASS_NAME__).newInstance());
				__ADDITIONAL_ACTION__.init(o_prop);
				INNER_ADD_ACTIONS.addLast(__ADDITIONAL_ACTION__);
			}
		}

		_BACK_LOG_DIRECTORY_ = prop.getProperty("update.log.dir");

		// 에러난 로그들은 저장할 로거를 세팅
		String LOGCHANNEL_ID = prop.getProperty("logger.id");

		if( LOGCHANNEL_ID == null ) {
			log.error("ERROR LOGCHANNEL IS NOT SET.......");
		}
		else {
			if (log.isDebugEnabled()) {
				log.debug("ERROR LOGGER=>" + LOGCHANNEL_ID);
			}
			ERROR_LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
		}
		
		//==== joo =================================
		//엔진 다운시 처리한 통계 위치기록 로그
		AUTO_SUMMARY = (AutoMissSummary) Class.forName(prop.getProperty("auto.summary")).newInstance();
		LOG_PRC_DIR = prop.getProperty("check.summary.dir");
		LOG_PRC_CHANNEL = new eMsFileWriter(LOG_PRC_DIR+File.separator+"update_point.info",true);
		//summary type list
		PRC_TARGET = prop.getProperty("auto.summary.type");
		//=====================================

		log.debug("[init]LogUpdateTask .... [OK]");
	}

	protected eMsConnection	EMS_CONNECTION	= null;

	/** Creates new AutoAnalyzerMainTask */
	public AutoAnalyzerMainTask() {
		super(TYPE_INTERVAL, _CHECK_INTERVAL_);
		this.setName("AutoAnalyzerMainTask");
		this.setTaskID("AutoAnalyzerMainTask");
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {
		
		//log.debug("[METHOD]<execute_initiate()>");
		EMS_CONNECTION = ConnectionPool.getConnection();
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		
		//log.debug("[METHOD]<execute_initiateError()>");
		log.error("execute init error", thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다. execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		
		//log.debug("[METHOD]<release_Resource()>");
		
		AutoAnalyzerMainTask._TARGET_LOG_READER_.close();
		AutoAnalyzerMainTask._BACK_LOG_WRITER_.close();
		AutoAnalyzerMainTask._DB_UPDATOR_.clear_connection();
		for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
			LogUpdator tmpUpdator = (LogUpdator) iter.next();
			tmpUpdator.clear_connection();
		}
		
		
		if(PPS_UPDATE_SEND_SUMMARY != null){
			PPS_UPDATE_SEND_SUMMARY.close();
			PPS_UPDATE_SEND_SUMMARY= null;
		}
		if(PPS_INSERT_SEND_SUMMARY != null){
			PPS_INSERT_SEND_SUMMARY.close();
			PPS_INSERT_SEND_SUMMARY = null;
		}
		
		if(PPS_UPDATE_70_SUMMARY != null){
			PPS_UPDATE_70_SUMMARY.close();
			PPS_UPDATE_70_SUMMARY = null;
		}
		
		//flow plan data
		if(PPS_SELECT_FLOW_DATA != null){
			PPS_SELECT_FLOW_DATA.close();
			PPS_SELECT_FLOW_DATA = null;
		}
		if(PPS_INSERT_FLOW_DATA != null){
			PPS_INSERT_FLOW_DATA.close();
			PPS_INSERT_FLOW_DATA = null;
		}
				
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycle();
		}
	}

	public synchronized void execute() throws Exception {
		
		//log.debug("[METHOD]<execute()>");		
		
		//DB UPDATOR DBCONNECTION setting
		AutoAnalyzerMainTask._DB_UPDATOR_.init_connection(EMS_CONNECTION);//LogTypeUpdatorImpl
		
		log.debug("DB UPDATOR DBCONNECTION setting OK");
		//ADDITIONAL_MODULES setStart()
		AutoAnalyzerMainTask._DB_UPDATOR_.setStart();

		log.debug("[_DB_PRE_UPDATOR_] size:"+_DB_PRE_UPDATOR_.size());
		
		for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
			LogUpdator tmpUpdator = (LogUpdator) iter.next();
			tmpUpdator.init_connection(EMS_CONNECTION);
			tmpUpdator.setStart();
		}

		if (log.isDebugEnabled())  log.debug(" get Connection  INIT OK ");
		
		
		
		
		
		// 처리하지 못한 summary 를 처리하는 부분 ===
		if(ACT_CNT==0){// 구동할때 한번만 실행한다.		
			if (log.isDebugEnabled()) log.debug("*****[ MISS SUMMARY  START ]***************************************");
			
			// 마지막 summary 정보를 세팅함. 정상이면 진행
			if(getMissSummaryInfo()){
				
				// 수집 HASH TABLE에 세팅한다.
				setMissSummary(EMS_CONNECTION);
			
				if (log.isDebugEnabled()) log.debug("\n[ miss SUMMARY DB UPDATE start]");
				int domain_result_cnt = summaryDomain(EMS_CONNECTION);
				int schedule_result_cnt = summarySchedule(EMS_CONNECTION);
				if (log.isDebugEnabled()) log.debug("[ miss SUMMARY DB UPDATE end]\n");
				
				if(domain_result_cnt <0 || schedule_result_cnt<0){
					if(domain_result_cnt <0){
						log.debug("[MISS DOMAIN SUMMARY ERROR !!! ]");
					}
					if(schedule_result_cnt <0){
						log.debug("[MISS SCHEDULE SUMMARY ERROR !!! ]");
					}			
					// summary 부분에서 오류 발생 
					System.exit(1);
				}
				// HASH TABLE 초기화
				AUTO_DOMAIN_PPT.clear();
				AUTO_SCHEDULE_PPT.clear();
			}
			
			// 진행 횟수
			if (log.isDebugEnabled()) log.debug("*****[ MISS SUMMARY  END ]*****************************************");
		}
		//========================================		
		
		// 실재로 발송된 데이터들을 업데이트 하는 부분  ===============================================================================
		work(EMS_CONNECTION);
		//=============================================================================================================================
		
		
		
		//수집한 결과를 업데이트 하는 부분 ======
		if (log.isDebugEnabled()) log.debug("*****[ SUMMARY  START ]***************************************");
		int domain_result_cnt = summaryDomain(EMS_CONNECTION);
		int schedule_result_cnt = summarySchedule(EMS_CONNECTION);
		
		if(domain_result_cnt <0 || schedule_result_cnt<0){
			if(domain_result_cnt <0){
				log.debug("[DOMAIN SUMMARY ERROR !!! ]");
			}
			if(schedule_result_cnt <0){
				log.debug("[SCHEDULE SUMMARY ERROR !!! ]");
			}			
			// summary 부분에서 오류 발생 
			System.exit(1);
		}
		if (log.isDebugEnabled()) log.debug("*****[ SUMMARY  END ]*****************************************");
		//=======================================
		
		

		// 현재 실행되지 않는다. => 값이 없기 때문에...
		if( AutoAnalyzerMainTask.INNER_ADD_ACTIONS != null ) {
			for (Iterator iter = AutoAnalyzerMainTask.INNER_ADD_ACTIONS.iterator(); iter.hasNext();) {
				AdditionalAction __INNER_ADDITIONAL_ACTION__ = (AdditionalAction) iter.next();
				if( __INNER_ADDITIONAL_ACTION__.isValidTime() ) {
					try {	
						__INNER_ADDITIONAL_ACTION__.init_connection(EMS_CONNECTION);
						__INNER_ADDITIONAL_ACTION__.execute();
					}
					catch(Throwable e) {
						log.error(e.getMessage());
					}
					finally {
						__INNER_ADDITIONAL_ACTION__.clean();
					}
				}
			}
		}else {
			if (log.isDebugEnabled())  log.debug(" INNER_ADD_ACTIONS IS NULL  <SKIP> ");
		}
		
		AutoAnalyzerMainTask._DB_UPDATOR_.setEnd();
		
		for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
			LogUpdator tmpUpdator = (LogUpdator) iter.next();
			tmpUpdator.setEnd();
		}
		
		log.info("End Log Update....");
		if (log.isDebugEnabled()) log.debug("[LOG ENGINE ACT CNT :"+ACT_CNT+"]");
		ACT_CNT++;		
	}
	
	
	
	/**
	 * 마지막 summary가 된 라인의 정보를 가져오는 메소드
	 * @return
	 */
	protected boolean getMissSummaryInfo(){
		String last_string = "";
		boolean act_flag = true;
		
		try {
			// update_point.info 의 마지막라인이다.
			last_string = LogFileReaderPps.getLastLine(LOG_PRC_DIR + "/" + "update_point.info");
		}
		catch(Throwable e) {
			log.error("Exception",e);
			log.error(e.getMessage());
		}

		if(last_string==null){
			LAST_FILE_POINT = 0L;
			LAST_FILE_NAME = AutoAnalyzerMainTask._TARGET_LOG_FILE_FILTER_.getNextFilename(false);
		}else{
			try {
				LAST_FILE_POINT = LogFileReaderPps.getFileID(last_string);
				LAST_FILE_NAME = LogFileReaderPps.getFileName(last_string);
			}
			catch(Exception _ex) {
				act_flag = false;
				log.error("error", _ex);
			}
		}
		
		if (log.isDebugEnabled()) log.debug("----------------------------------[getMissSummaryInfo][LOG point]:"+LAST_FILE_POINT+" [FILE_NAME]:"+LAST_FILE_NAME);
		
		return act_flag;
	}
	
	
	
	protected void setMissSummary(eMsConnection EMS_CONNECTION) throws Exception {
		if (log.isDebugEnabled()) {
			log.debug("[----------------- setMissSummary start------------------]\n");
		}
		
		
		String __SUMMARY_END_FILE_NAME__ = null;
		long __SUMMARY_END_FILE_POINT__ = 0L;
		
		String __START_LOG_FILE_NAME__ = null;		
		String __LAST_LOG_STRING__ = null;
		long __START_LOG_FILE_POINT__ = 0L;

		//bak log 폴더의 마지막 index의 파일
		String __FINAL_BACK_LOG_FILE__ = AutoAnalyzerMainTask._BACK_LOG_FILE_FILTER_.getLastFilename();
  
		log.info("Target Back Log File => "+__FINAL_BACK_LOG_FILE__);

		// bak log가 존재하지 않으면 그냥 넘어간다.
		if( __FINAL_BACK_LOG_FILE__ == null ) {
			return;
			
		}else{// bak log가 존재한다
			
			//bak 로그의 마지막 파일에서의 index 부분을 추출하여 log파일의 header와 tail을 붙여 bak log에 해당하는 log 파일명을 제작한다.
			__SUMMARY_END_FILE_NAME__ = AutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInverseInfo(AutoAnalyzerMainTask._BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
			
			// 유추한 log파일명이 실제로 존재하는지 확인한다.
			if( !(new File(AutoAnalyzerMainTask._TARGET_LOG_FILE_FILTER_.getFullName(__SUMMARY_END_FILE_NAME__))).exists() ) {
				//파일이 없다면...
				return;
			}
			
			
			try {
				__LAST_LOG_STRING__ = LogFileReaderPps.getLastLine(AutoAnalyzerMainTask._BACK_LOG_DIRECTORY_ + "/" + __FINAL_BACK_LOG_FILE__);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}

			try {
				__SUMMARY_END_FILE_POINT__ = LogFileReaderPps.getFileID(__LAST_LOG_STRING__);
			}
			catch(Exception _ex) {
				__SUMMARY_END_FILE_POINT__ = 0L;
			}

			// summary 한 곳과 bak log의 마지막이 일치한다면 그냥 통과한다.
			if(    __SUMMARY_END_FILE_POINT__==LAST_FILE_POINT 
				&& __SUMMARY_END_FILE_NAME__.equals(LAST_FILE_NAME)){
				log.debug("[SUMMARY NOTING!]");
				return;
			}
			
			
			if (log.isDebugEnabled()) {log.debug("Choose final Pointer: " + String.valueOf(__SUMMARY_END_FILE_POINT__));}

			try {
				//update_point.info에서 마지막으로 summary가 된 파일과 포인터 정보를 알아올 수 있다.
				//이곳에서부터 __START_LOG_FILE_NAME__파일의 __START_LOG_FILE_POINT__포인터까지 summary를 진행해야한다.
				
				// update_point.info 의 정보로 log 파일을 오픈한다.
				AutoAnalyzerMainTask._TARGET_LOG_READER_.openFile(LAST_FILE_NAME, LAST_FILE_POINT);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}
		}
		
		///////////////////////////// UPDATE ///////////////////////////////////////////////////////////////////////////////////////
		log.info("Start Log Update....");

		Object _LOG_INFO_ = null;		
		String __UPDATE_RESULT_STRING__ = null;
		eMsStatement EMS_UPDATE_STATEMENT 	= null;
		
		try{
			EMS_UPDATE_STATEMENT = EMS_CONNECTION.createStatement();
		
			do {
				__LAST_LOG_STRING__ = AutoAnalyzerMainTask._TARGET_LOG_READER_.readLine();
				__START_LOG_FILE_NAME__ = AutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName();
				AutoAnalyzerMainTask.LAST_FILE_NAME = __START_LOG_FILE_NAME__;
				log.debug("[LAST_FILE_NAME]:"+LAST_FILE_NAME);	
				
				__START_LOG_FILE_POINT__ = AutoAnalyzerMainTask._TARGET_LOG_READER_.getFilePoint();
				AutoAnalyzerMainTask.LAST_FILE_POINT = __START_LOG_FILE_POINT__;
				log.debug("[LAST_FILE_POINT]:"+LAST_FILE_POINT);
				
	
				if( __LAST_LOG_STRING__ == null ) {
					if( AutoAnalyzerMainTask._TARGET_LOG_READER_.next() ) { //다음 log 파일이 존재한다면 그 파일로 이동하고 포인터는 0 부터 시작하도록 세팅
						__START_LOG_FILE_NAME__ = AutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName();						
						AutoAnalyzerMainTask.LAST_FILE_NAME = __START_LOG_FILE_NAME__;
						log.debug("[LAST_FILE_NAME]:"+LAST_FILE_NAME);	
						
						__START_LOG_FILE_POINT__ = 0L;
						AutoAnalyzerMainTask.LAST_FILE_POINT = __START_LOG_FILE_POINT__;
						log.debug("[LAST_FILE_POINT]:"+LAST_FILE_POINT);
						
						if (log.isDebugEnabled()) {log.debug("summary Switch Next LogFile .... ".concat(AutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName()));}
						continue;
					}
					return;
					
				}else if( __LAST_LOG_STRING__.trim().length() >= 2 ) {
	
					try {
//						if (log.isDebugEnabled()) {
//							log.debug(__LAST_LOG_STRING__);
//						}
						_LOG_INFO_ = AutoAnalyzerMainTask._LOG_PARSER_.parse(__LAST_LOG_STRING__);
						
						if( _LOG_INFO_ == null ||  _LOG_INFO_ instanceof String ) {
							continue;
						}
	
						_LOG_INFO_ = AutoAnalyzerMainTask._LOG_FILTER_.convert(_LOG_INFO_);
	
						////////////// SUMMARY 정보를 수집하는 부분이다. ///////////////////////////////////
						try {
							// 필터링이 종료되고 실제 업데이트 하는 로직이 들어감..
							__UPDATE_RESULT_STRING__ = AutoAnalyzerMainTask.AUTO_SUMMARY.summary(_LOG_INFO_,EMS_UPDATE_STATEMENT);
						}
						catch(Throwable ex_) {
							if( ERROR_LOG_CHANNEL_INSTANCE != null ) {
								ERROR_LOG_CHANNEL_INSTANCE.write(__LAST_LOG_STRING__);
							}
							log.error(getName(), ex_);
							if (log.isDebugEnabled()) {
								log.error("Exception",ex_);
							}
						}
						/////////////////////////////////////////////////////////////////////////////////////////////////									
					}
					catch(Throwable e) {
						log.error("Exception",e);
						return;
					}
					
				}
			} while (  (__START_LOG_FILE_POINT__!=__SUMMARY_END_FILE_POINT__) 
					||  (!__START_LOG_FILE_NAME__.equals(__SUMMARY_END_FILE_NAME__)) );		
		}catch(SQLException se){
			log.error("error", se);
		}finally{
			EMS_UPDATE_STATEMENT.releaseStmt(EMS_UPDATE_STATEMENT);
		}
	}

	
	
	/**
	 * 실재로 작업하는 메소드
	 * @param EMS_CONNECTION
	 * @throws Exception
	 */
	protected void work(eMsConnection EMS_CONNECTION) throws Exception {
		if (log.isDebugEnabled()) {
			log.debug("[----------------- work start------------------]\n");
		}

		//log 폴더의 파일명
		String __START_LOG_FILE_NAME__ = null;
		
		//bak log 의 마지막 라인
		String __LAST_LOG_STRING__ = null;

		//bak log의 마지막 라인의 원본인 log 파일의 포인터
		long __START_LOG_FILE_POINT__ = 0L;

		//bak log 폴더의 마지막 index의 파일
		String __FINAL_BACK_LOG_FILE__ = AutoAnalyzerMainTask._BACK_LOG_FILE_FILTER_.getLastFilename();
  
		log.info("Target Back Log File => "+__FINAL_BACK_LOG_FILE__);

		// bak log가 존재하지 않는다.
		if( __FINAL_BACK_LOG_FILE__ == null ) {
			
			if (log.isDebugEnabled()) { log.debug("Backup Log File Not Exist.... so Check First Target Log File.. ");}
			
			//log 폴더의 index 중 가장 작은 값을 갖는 파일명을 가져온다.
			__START_LOG_FILE_NAME__ = AutoAnalyzerMainTask._TARGET_LOG_FILE_FILTER_.getNextFilename(false);
			AutoAnalyzerMainTask.LAST_FILE_NAME = __START_LOG_FILE_NAME__;
			

			//log 폴더에도 파일이 없을 경우
			if( __START_LOG_FILE_NAME__ == null ) {
				if (log.isDebugEnabled()) {log.debug("Start Target Log File is Not Exist.. so return... ");}
				return;
			}

			try {
				if (log.isDebugEnabled()) {log.debug("Open Target Log File [0] : " + __START_LOG_FILE_NAME__);}
				
				// 파일의 포인터 0인 부분을 오픈한다.(처음부터 처리하기 위함.)
				AutoAnalyzerMainTask._TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, 0L);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}
		}
		
		// bak log가 존재한다
		else {
			
			//bak 로그의 마지막 파일에서의 index 부분을 추출하여 log파일의 header와 tail을 붙여 bak log에 해당하는 log 파일명을 제작한다.
			__START_LOG_FILE_NAME__ = AutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInverseInfo(AutoAnalyzerMainTask._BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
			
			AutoAnalyzerMainTask.LAST_FILE_NAME = __START_LOG_FILE_NAME__;
			log.debug("[LAST_FILE_NAME]:"+LAST_FILE_NAME);
			
			
			// 유추한 log파일명이 실제로 존재하는지 확인한다.
			if( !(new File(AutoAnalyzerMainTask._TARGET_LOG_FILE_FILTER_.getFullName(__START_LOG_FILE_NAME__))).exists() ) {
				//파일이 없다면...
				log.info("Target Log File Not Exist.... so Delete BackLog ");
				//bak log를 삭제한다.
				boolean fileDel = (new File(__FINAL_BACK_LOG_FILE__)).delete();
				if(!fileDel) log.error("File deletion failed");
				
				log.debug( "Miss Match BackLog Delete => ".concat(__FINAL_BACK_LOG_FILE__));
				return;
			}
			
			
			// 마지막 백로그 파일에서 마지막라인을 가져온다.
			if (log.isDebugEnabled()) {log.debug("Choose Target Log File : " + __START_LOG_FILE_NAME__);}
			try {
				// bak log 의 마지막라인이다.
				__LAST_LOG_STRING__ = LogFileReaderPps.getLastLine(AutoAnalyzerMainTask._BACK_LOG_DIRECTORY_ + "/" + __FINAL_BACK_LOG_FILE__);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}

			// 백업파일의 마지막 라인을 읽어서 원본의 포인터를 찾는다.
			try {
				// 포인터가 bak log 앞에 [] 에 의해서 쌓여있다. 이를 가져온다.
				__START_LOG_FILE_POINT__ = LogFileReaderPps.getFileID(__LAST_LOG_STRING__);
			}
			catch(Exception _ex) {
				__START_LOG_FILE_POINT__ = 0L;
			}

			if (log.isDebugEnabled()) {log.debug("Choose Target Log File Pointer: " + String.valueOf(__START_LOG_FILE_POINT__));}

			try {
				//이제까지 bak log에 의해서 유추한 파일이 존재했고 bak log의 마지막 라인이 원본 log의 해당 포인터를 알았다.
				//원본 log 파일의 해당 포인터 부터의 데이터는 처리가 안된 정보이기 대문에 이를 처리하기 위해서 
				//log 파일의 해당 포인터에서 오픈을 한다.
				AutoAnalyzerMainTask._TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, __START_LOG_FILE_POINT__);
			}
			catch(Throwable e) {
				log.error(e.getMessage());
				return;
			}
		}

		if (log.isDebugEnabled()) {
			log.debug("\nSet Start log file : " + __START_LOG_FILE_NAME__);
			log.debug("Set Last log String : " + __LAST_LOG_STRING__);
			log.debug("Set Work BackLogFile : " + __FINAL_BACK_LOG_FILE__+"\n");
		}

		try {
			//bak log 폴더의 마지막 파일을 오픈하고 eMsFileWriter를 생성한다.
			AutoAnalyzerMainTask._BACK_LOG_WRITER_.openFile(AutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInfo(__START_LOG_FILE_NAME__));
		}
		catch(Throwable e) {
			log.error(e.getMessage());
			return;
		}

		
		
		
		///////////////////////////// UPDATE ///////////////////////////////////////////////////////////////////////////////////////
		log.info("Start Log Update....");

		Object _LOG_INFO_ = null;
		
		// int __UPDATE_COUNT__ = 0;	
		
		// by joo
		int act_line_cnt = 0;
		
		String __UPDATE_RESULT_STRING__ = null;		
		
		do {
			// log 폴더에서 포인터 이후의 라인을 가져온다.
			__LAST_LOG_STRING__ = AutoAnalyzerMainTask._TARGET_LOG_READER_.readLine();
			//변동된 해당 포인터를 가져온다.
			__START_LOG_FILE_POINT__ = AutoAnalyzerMainTask._TARGET_LOG_READER_.getFilePoint();
			
			AutoAnalyzerMainTask.LAST_FILE_POINT=__START_LOG_FILE_POINT__;
			//추가된 정보가 log에 없다면...
			if( __LAST_LOG_STRING__ == null ) {
				if (log.isDebugEnabled()) {
					log.debug("Check Next LogFile .... ");
				}

				//다음 index 파일이 존재하는지 확인 
				if( AutoAnalyzerMainTask._TARGET_LOG_READER_.next() ) { //다음 log 파일이 존재한다면 그 파일로 이동하고 포인터는 0 부터 시작하도록 세팅					
					if (log.isDebugEnabled()) {log.debug("Switch Next LogFile .... ".concat(AutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName()));}
					
					AutoAnalyzerMainTask.LAST_FILE_NAME = AutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName();
					log.debug("[LAST_FILE_NAME]:"+LAST_FILE_NAME);
					
					
					AutoAnalyzerMainTask.LAST_FILE_POINT = 0L;
					
					//다음 파일이 있다면 bak log파일을 생성한다.
					AutoAnalyzerMainTask._BACK_LOG_WRITER_.openFile(AutoAnalyzerMainTask._TARGET_LOG_NAME_PATCH_.getInfo(AutoAnalyzerMainTask._TARGET_LOG_READER_.getWorkingFileName()));
					
					//그리고 계속 진행한다.
					continue;
				}
				
				if (log.isDebugEnabled()) {log.debug("[NON BAK LOG FILE]");}
				//다음 파일이 존재하지 않는다면 여기서 사이클을 마친다.
				return;
			}
			
			// 추가된 정보가 log에 기록되어 있고 크기가 2 이상이면 ... 일을 해야한다.  //그렇지 않으면 무시하고 다음을 진행한다.
			else if( __LAST_LOG_STRING__.trim().length() >= 2 ) {
				try {
					if (log.isDebugEnabled()) {
						log.debug(__LAST_LOG_STRING__);
					}
					// 로그를 파싱한다. 
					//log 폴더의 라인을 '|'에 의해서 나누어서 properties에 저장해서 object 형으로 리턴한다.
					_LOG_INFO_ = AutoAnalyzerMainTask._LOG_PARSER_.parse(__LAST_LOG_STRING__);

					if( _LOG_INFO_ == null ) {//null 일 경우는 형식에 맞지 않을 경우이므로 그냥 넘어간다.
						// 로그정보가 파싱이 안되므로 업데이트는 넘어가고 bak log에 표기만 한다.
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", "invalid log"); //log 형식오류
						continue;
					}

					if( _LOG_INFO_ instanceof String ) {//String 형태로 리턴되었다면...
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", _LOG_INFO_.toString());
						continue;
					}

					// 로그를 필터링 하면서 바꾸고
					// 필터에서 54|10 => 54|00, 54|00 => 54|--  으로 수정
					_LOG_INFO_ = AutoAnalyzerMainTask._LOG_FILTER_.convert(_LOG_INFO_);

					//전처리기를 돌려준다.  //현재 null  이다.
					for (Iterator iter = _DB_PRE_UPDATOR_.iterator(); iter.hasNext();) {
						LogUpdator tmpUpdator = (LogUpdator) iter.next();
						try {
							tmpUpdator.update(_LOG_INFO_);
						}
						catch(Throwable _ex) {
							log.error("Exception",_ex);
						}
					}
					
					// 한번에 작업할 갯수를 정한다.
					act_line_cnt++;
					////////////// DB와의 연결을 통해서 UPDATE  가 되는 부분이다. ///////////////////////////////////
					try {
						// 필터링이 종료되고 실제 업데이트 하는 로직이 들어감..
						__UPDATE_RESULT_STRING__ = AutoAnalyzerMainTask._DB_UPDATOR_.update(_LOG_INFO_);
						
						// ### auto flow plan ###
						String actResult = insertFlowPlanData(_LOG_INFO_);
						if(log.isDebugEnabled()){
							log.debug("[insertFlowPlanData]"+actResult);
						}
						// ######################
						
					}
					catch(Throwable ex_) {
						if( ERROR_LOG_CHANNEL_INSTANCE != null ) {
							ERROR_LOG_CHANNEL_INSTANCE.write(__LAST_LOG_STRING__);
						}
						log.error(getName(), ex_);
						if (log.isDebugEnabled()) {
							log.error("Exception",ex_);
						}
						if( ex_ instanceof SQLException ) {
							AutoAnalyzerMainTask._DB_UPDATOR_.ensureDBConnection();
						}
						__UPDATE_RESULT_STRING__ = ex_.toString().replace('\r', ' ').replace('\n', ' ');
					}
					
					appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", __UPDATE_RESULT_STRING__);
					/////////////////////////////////////////////////////////////////////////////////////////////////
				}
				catch(Throwable e) {
					log.error(e.getMessage());
					try {
						appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", StringUtil.nl2blank(e.toString().trim()));
					}
					catch(Throwable _ex) {
						log.error("error", _ex);
					}
					return;
				}
				
			}
		} while (act_line_cnt < SUMMARY_CNT);				
	}

	/*
	[table : PLAN_ACT_LIST]
	
	create table PLAN_ACT_LIST(
			SRC_WORKDAY       varchar(8) NOT NULL, 
			SRC_SEQNO         decimal(9,0) NOT NULL,
			SRC_MEMBER_ID     varchar(20) NOT NULL,
			SRC_MEMBER_ID_SEQ varchar(10) NOT NULL,
			SRC_LIST_TABLE    varchar(100) DEFAULT NULL,
			MSG_TYPE          varchar(3) NOT NULL,
			MSG_TYPE_SEQ      varchar(3) NOT NULL,
			PLAN_STATUS       varchar(2) NOT NULL,
			PLAN_DAY          varchar(5) ,
			PLAN_HOUR         varchar(10) ,
			T_DATE            datetime,  -- 로그 일시
			ACT_DATE          datetime,  -- 작업할 일시
			REG_DATE          datetime,  -- 등록일시
			SEND_FLAG_DATE    datetime   -- 발송 완료시 update
	)
	*/
	/**
	 * 
	 * @param target
	 * @return
	 * @throws Exception 
	 */
	protected String insertFlowPlanData(Object target) throws Exception{
		Properties propLogData = ( Properties )target;
		
		String sendType  = propLogData.getProperty( Log.LOG_SEND_TYPE );
		String tType     = propLogData.getProperty( Log.LOG_T_TYPE );
		String tCode     = propLogData.getProperty( Log.LOG_T_CODE );
		int    tStep     = Integer.parseInt(propLogData.getProperty( Log.LOG_STEP ));
		
		String postId    = propLogData.getProperty( Log.LOG_MAIL_ID );
		
		if(log.isDebugEnabled()){
			log.debug("[insertFlowPlanData] propLogData : \n"+propLogData.toString());
		}
		
//		String workday   = propLogData.getProperty( Log.LOG_WORKDAY );
//		String seqNo     = propLogData.getProperty( Log.LOG_SEQNO );
//		String mId       = propLogData.getProperty( Log.LOG_MEMBER_ID );
//		String mIdSeq    = propLogData.getProperty( Log.LOG_MEMBER_ID_SEQ );
//		String listTable = propLogData.getProperty( Log.LOG_LIST_TABLE );
		
		String actType   = "SKIP";
		
		if( !sendType.equals("AUTO") && !sendType.equals("AUTORESEND") ){
			if(log.isDebugEnabled()){
				log.debug("[insertFlowPlanData] skip : !auto && ! autoresend ");
			}
			return "SKIP";
		}
		
		if( tType.equals( "54" ) ){
			if( tCode.equals("00") ){
				if( tStep == 0 ){
					if(log.isDebugEnabled()){
						log.debug("[insertFlowPlanData] SUCCESS_FIRST");
					}
					actType = "SUCCESS_FIRST";
				}else{
					if(log.isDebugEnabled()){
						log.debug("[insertFlowPlanData] SUCCESS_RETRY");
					}
					actType = "SUCCESS_RETRY";
				}
			}else{
				if(log.isDebugEnabled()){
					log.debug("[insertFlowPlanData] skip : 54 / !00");
				}
				return "SKIP";
			}
		}else if( tType.equals( "55" ) ){
			if( tStep == 0 ){
				if(log.isDebugEnabled()){
					log.debug("[insertFlowPlanData] FAIL");
				}
				actType = "FAIL";
			}else{
				if(log.isDebugEnabled()){
					log.debug("[insertFlowPlanData] skip : 55 / step >0");
				}
				return "SKIP";
			}
		}else{
			return "SKIP";
		}
		
		//static hashtable에서 post_id에 해당하는 bean을 가져옴
		PlanBean bean = PlanBean.getPlanBean(postId);
		if(bean == null){
			bean = new PlanBean();
			
			/*
			SELECT B.MSG_TYPE     AS MSG_TYPE,
				   B.MSG_TYPE_SEQ AS MSG_TYPE_SEQ,
				   B.PLAN_DAY     AS PLAN_DAY,
				   B.PLAN_HOUR    AS PLAN_HOUR,
				   B.PLAN_STATUS  AS PLAN_STATUS
			  FROM TMS_AUTO_SCHD_INFO A, 
			       TMS_AUTO_MSG_INFO B
			 WHERE A.WORKDAY = '${WORKDAY}'
			   AND A.SEQNO = '${SEQNO}'
			   AND A.MSG_TYPE = B.PLAN_PARENT_MSG_TYPE
			   AND A.MSG_TYPE_SEQ = B.PLAN_PARENT_MSG_TYPE_SEQ
			   AND B.CHANNEL_TYPE= 'EM' 
			 */
			//preparedStatement를 생성
			if(PPS_SELECT_FLOW_DATA == null){
				PPS_SELECT_FLOW_DATA = EMS_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO,"${","}");
			}
			
			eMsResultSet rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
			
			ArrayList    arrTarget  = new ArrayList();
			
			while(rsFlowData.next()){
				Properties prop = new Properties();
				
				prop.setProperty("MSG_TYPE",    rsFlowData.getString("MSG_TYPE"));
				prop.setProperty("MSG_TYPE_SEQ",rsFlowData.getString("MSG_TYPE_SEQ"));
				prop.setProperty("PLAN_DAY",    rsFlowData.getString("PLAN_DAY"));
				prop.setProperty("PLAN_HOUR",   rsFlowData.getString("PLAN_HOUR"));
				prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
				
				arrTarget.add(prop);
			}
			
			bean.setPostId(postId);
			bean.setArrTarget(arrTarget);
			
			//static hashtable에 저장
			PlanBean.setPlanBean(bean);
		}
		
		//plan 이 아닐경우 skip
		if(!bean.isPlanYn()){
			return "SKIP";
		}

		ArrayList<Properties> dataList = bean.getArrTarget();
		int dataCnt       = dataList.size();
		String msgType    = "";
		String msgTypeSeq = "";
		String planStatus = "";
		String planDay    = "";
		String planHour   = "";
		
		boolean actFlag   = false;
		
		//insert
		for(int i=0; i< dataCnt; i++){
			Properties propPlanData = dataList.get(i);
			msgType      = propPlanData.getProperty("MSG_TYPE");
			msgTypeSeq   = propPlanData.getProperty("MSG_TYPE_SEQ");
			planStatus   = propPlanData.getProperty("PLAN_STATUS");
			planDay      = propPlanData.getProperty("PLAN_DAY");
			planHour     = propPlanData.getProperty("PLAN_HOUR");
						
			propLogData.setProperty("MSG_TYPE",     msgType);
			propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
			propLogData.setProperty("PLAN_STATUS",  planStatus);
			propLogData.setProperty("PLAN_DAY",     StringUtil.isNull(planDay)?"0":planDay );
			propLogData.setProperty("PLAN_HOUR",    StringUtil.isNull(planHour)?"0":planHour);
			
			if(log.isDebugEnabled()){
				log.debug("[planStatus]"+planStatus+"[actType]"+actType);
			}
			
			if( "A".equals(planStatus)){ //전체
				if( "SUCCESS_FIRST".equals(actType) || "FAIL".equals(actType) ){ //첫번째 성공, 첫번째 실패 건 합
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:ALL> SUCCESS_FIRST / FAIL");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[insertFlowPlanData] A : ! succ first or ! fail");
					}
					continue;
				}
			}else if( "S".equals(planStatus)){ //성공
				if( "SUCCESS_FIRST".equals(actType) || "SUCCESS_RETRY".equals(actType) ){ //모든 성공
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:SUCCESS> SUCCESS_FIRST / SUCCESS_RETRY");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[insertFlowPlanData] S : ! succ");
					}
					continue;
				}
			}else if( "F".equals(planStatus)){ //실패
				if( "FAIL".equals(actType) ){ // 첫번째 실패만 처리
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:FAIL> FAIL_FIRST");
					}
				}else{
					if(log.isDebugEnabled()){
						log.debug("[insertFlowPlanData] F : ! fail");
					}
					continue;
				}
			}else{
				if(log.isDebugEnabled()){
					log.debug("[TARGET_AREA]<no Type> SKIP");
				}
				continue;
			}

			/*
			INSERT INTO PLAN_ACT_LIST(
				SRC_WORKDAY, SRC_SEQNO, SRC_MEMBER_ID, SRC_MEMBER_ID_SEQ, SRC_LIST_TABLE,
				MSG_TYPE, MSG_TYPE_SEQ,
				PLAN_STATUS, PLAN_DAY, PLAN_HOUR,
				T_DATE, 
				ACT_DATE, 
				REG_DATE )
			VALUES (
				'${WORKDAY}','${SEQNO}','${M_ID}','${M_ID_SEQ}','${LIST_TABLE}',
				'${MSG_TYPE}','${MSG_TYPE_SEQ}',
				'${PLAN_STATUS}','${PLAN_DAY}','${PLAN_HOUR}',
				DATE_FORMAT( '${T_DATE}' , '%Y-%m-%d %H:%i:%S' ),
				DATE_SUB(DATE_SUB(DATE_FORMAT( '${T_DATE}', '%Y-%m-%d %H:%i:%S' ), INTERVAL (-1*${PLAN_DAY}) DAY), INTERVAL (-1*${PLAN_HOUR}) HOUR),
				NOW() )
			 */
			//preparedStatement를 생성
			if(PPS_INSERT_FLOW_DATA == null){
				PPS_INSERT_FLOW_DATA = EMS_CONNECTION.prepareStatement(this.QUERY_INSERT_FLOW_DATA,"${","}");
			}
			
			int cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData);
			if(cnt_insert != 1){
				log.debug("[ERROR] insert fail <FLOW_DATA> "+propLogData.toString());
			}else{
				actFlag = true;
			}
			
		}//end of for
		
		if(!actFlag){
			actType = "no Match";
		}
		
		return actType;
	}
	
	
	/**
	 * bak log 파일을 쓰는 액션이다.
	 * @param __START_LOG_FILE_POINT__ : file point(random access에 사용한다.)
	 * @param __LAST_LOG_STRING__ : 처리한 라인
	 * @param result : 결과에 합쳐질 String
	 * @param ext : 처리 결과 String
	 * @throws Throwable 
	 */
	protected void appendBackLog(long __START_LOG_FILE_POINT__, String __LAST_LOG_STRING__, String result, String ext) throws Throwable {
		AutoAnalyzerMainTask._BACK_LOG_WRITER_.append(String.valueOf(__START_LOG_FILE_POINT__), __LAST_LOG_STRING__.concat(result).concat(ext));
	}
	
	
	/**
	 * summary domain 을 수집한 bean 들을 update 하는 액션
	 * @param EMS_CONNECTION
	 * @return 오류 발생시 -1 을 리턴한다.
	 * @throws Exception 
	 */
	protected int summaryDomain(eMsConnection EMS_CONNECTION) throws Exception{
		DomainUpdateBean domainBean 		= null;
		
		int result=0;
		int count=0;
		
		if (log.isDebugEnabled()) log.debug("[summaryDomain START] AUTO_DOMAIN_PPT size==>"+AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.size());
		
		
		
		try{
			if(AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.size() <= 0){
				return result;
			}
			
			Enumeration e = AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.elements();			
			while(e.hasMoreElements())	{

				result = 0;
				domainBean = (DomainUpdateBean)e.nextElement();		
				if(log.isDebugEnabled()){log.debug("[domainBean content]\n\t"+domainBean.toAutoString());}
				
				
				
				
				if(PPS_UPDATE_SEND_SUMMARY == null){
					PPS_UPDATE_SEND_SUMMARY = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SEND_SUMMARY, "${", "}");
				}
				result = PPS_UPDATE_SEND_SUMMARY.executeUpdate(domainBean.getElement("AUTO"));
				
				
				
				
				/**
				 * 업데이트가 되지 않으면 인서트 하고 업데이트 한다.
				 */
				if( result < 1 ) {
					if(log.isDebugEnabled()){log.debug("[update fail==> insert domain]"+domainBean.getName());}
					
					

					//인서트하고나서
					if(PPS_INSERT_SEND_SUMMARY == null){
						PPS_INSERT_SEND_SUMMARY = EMS_CONNECTION.prepareStatement(QUERY_INSERT_SEND_SUMMARY, "${", "}");
					}
					PPS_INSERT_SEND_SUMMARY.executeUpdate(domainBean.getElement("AUTO"));
					
					//다시 업데이트한다.
					result = PPS_UPDATE_SEND_SUMMARY.executeUpdate(domainBean.getElement("AUTO"));
					
					
					
					
					if( result >= 1 ) {
						if(log.isDebugEnabled()){log.debug("[update OK]");}
					}
					
				}	
				
				if(result <= 0){
					log.debug("[DOMAIN SUMMARY FAIL]:"+domainBean.getName());
				}else{
					count++;
				}
			}
			
			if(AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.size()>0){
				log(LAST_FILE_POINT,LAST_FILE_NAME);
			}
			
		}catch(SQLException sq_e){
			log.error("error", sq_e);
			// 프로세스 종료되는 위치 로그에 명시
			log.error("ERROR AUTO SCHD SUMMARY : PONINT {} , FILENAME", LAST_FILE_POINT, LAST_FILE_NAME);

			result = -1;
		}
		return result;
	}

	/**
	 * 켐패인의 발송 및 오류 데이터를 수집한 bean 들을 update 하는 액션
	 * @param EMS_CONNECTION
	 * @return 오류 발생시 -1 을 리턴한다.
	 * @throws Exception 
	 */
	protected int summarySchedule(eMsConnection EMS_CONNECTION) throws Exception{
		ScheduleTblBean stBean 		= null;
		
		String UPDATE_QUERY = "";
		int result=0;
		int count=0;
		
		
		if (log.isDebugEnabled()) log.debug("[summarySchedule START]AUTO_SCHEDULE_PPT size==>"+AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.size());
		
		
		
		try{		
			if(AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.size() <= 0){
				return result;
			}
			
			Enumeration e = AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.elements();				
			while(e.hasMoreElements())	{
				
				stBean = (ScheduleTblBean)e.nextElement();
				if(log.isDebugEnabled()){log.debug("[stBean content]\n\t"+stBean.toString());}

				
				
				
				//preparedStatement가 없다면 생성해준다.
				if(PPS_UPDATE_70_SUMMARY == null){
					PPS_UPDATE_70_SUMMARY = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_70_SUMMARY, "${", "}");
				}
				result = PPS_UPDATE_70_SUMMARY.executeUpdate(stBean.getElement("AUTO"));
				
				
				
				
				if(result<1){
					log.debug("[SCHEDULE SUMMARY FAIL]:"+stBean.getName());
				}else{
					count++;
				}
			}
			
			if( count == AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.size() ) {log.debug("\t\t\t\t[SCHEDULE SUMMARY SUCCESS !!!]");}
		}catch(SQLException sq_e){
			log.error("error", sq_e);
			// 프로세스 종료되는 위치 로그에 명시
			log.error("ERROR AUTO SCHD SUMMARY : PONINT {} , FILENAME", LAST_FILE_POINT, LAST_FILE_NAME);
			result = -1;
		}
		
		// 업데이트한 bean이 있다면 집계한 마지막 라인의 내용을 기록한다.
		if(AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.size()>0){
			log(LAST_FILE_POINT,LAST_FILE_NAME);
		}
		
		return result;
	}
	
	
	protected static void log( long point, String file_name ){
		try{
			log.debug("[LOG point]:"+point+" [FILE_NAME]:"+file_name);
			LOG_PRC_CHANNEL.write("["+point+"]");
			LOG_PRC_CHANNEL.write( "\t" );
			LOG_PRC_CHANNEL.println( "["+file_name+"]" );
		}
		catch( Throwable e ){
			log.error("Exception",e);
		}
	}
}
