/*
 * ZeusHeadTailLogFileNamingRule.java
 *
 * Created on 2004년 12월 18일 (토), 오전 11:30
 */

package moon.logprocess.module;

import java.io.File;
import java.util.Properties;

import moon.logprocess.module.LogFileNamingRule;

/**
 * 
 * @author 이상근
 */
public class ZeusHeadOnlyLogFileNamingRule extends LogFileNamingRule {
	protected String	START_INDEX	= null;

	protected int		SIZE_INDEX	= 0;

	/** Creates a new instance of ZeusHeadTailLogFileNamingRule */
	public ZeusHeadOnlyLogFileNamingRule() {
		super();
	}

	public void init(Object obj) {
		Properties prop = (Properties) obj;

		this.START_INDEX = prop.getProperty("log.head");
		
		this.SIZE_INDEX = this.START_INDEX.length();
	}

	public boolean accept(File p1, String name) {
		boolean __TMP_ACCEPT__ = _LAST_FILE_NAME_ == null;

		if( !__TMP_ACCEPT__ ) {
			if( !name.startsWith(this.START_INDEX) ) {
				return false;
			}

			int iLength = name.length();

			String name_index = name.substring(iLength - 4) + name.substring(iLength - 8, iLength - 4);
			String last_index = _LAST_FILE_NAME_.substring(iLength - 4) + _LAST_FILE_NAME_.substring(iLength - 8, iLength - 4); 

			__TMP_ACCEPT__ = name_index.compareTo(last_index) > 0;
		}

		return name.startsWith(this.START_INDEX) && __TMP_ACCEPT__;
	}
}
