/*
 * ZeusLogFileFilter.java
 *
 * Created on 2003년 9월 22일 (월), 오후 9:0
 */

package moon.logprocess.module;

import java.util.Collections;
import java.util.LinkedList;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author 이상근
 */
@Slf4j
public class ZeusHeadOnlyLogFileFilter extends LogFileFilter {
	

	/** Creates a new instance of ZeusLogFileFilter */
	public ZeusHeadOnlyLogFileFilter() {
	}

	public String getLastFilename() {
		// 대상이 되는 로그리스트를 받아온다.
		String _LOG_FILE_LIST_[] = this._TARGET_DIRECTORY_FILE_.list(this._LOG_NAME_RULE_);

		LinkedList list = new LinkedList();
		String tmp = null;
		String tmp2 = null;

		if( _LOG_FILE_LIST_.length > 0 ) {
			for (int i = 0; i < _LOG_FILE_LIST_.length; i++) {
				// 원본에 있는 날짜 인덱스를 가지고 온다.
				tmp = this._LOG_NAME_PATCH_.getInfo(_LOG_FILE_LIST_[i]);
				// 년도와월일이 순서가 바뀌었으므로 그걸 바꿔서 소트를 해야한다.
				tmp2 = tmp.substring(4).concat(tmp.substring(0, 4));

				list.add(tmp2);
			}

			Collections.sort(list);
			tmp = (String) list.getLast();
			// 소트된것이 순서가 바뀐 것이므로 다시 바꿔서 reverse 정보를 얻어야 한다.
			return this._LOG_NAME_PATCH_.getInverseInfo(tmp.substring(4).concat(tmp.substring(0, 4)));
		}
		else {
			return null;
		}
	}

	public String getNextFilename() {
		if (log.isDebugEnabled()) {
			log.debug("Log Filter Select base filename", this._CURRENT_LOG_FILENAME_);
		}
		this._LOG_NAME_RULE_.setLastFile(this._CURRENT_LOG_FILENAME_);

		String _LOG_FILES_[] = this._TARGET_DIRECTORY_FILE_.list(this._LOG_NAME_RULE_);

		this._LOG_NAME_RULE_.setLastFile(null);

		LinkedList list = new LinkedList();

		if( _LOG_FILES_.length > 0 ) {
			String tmp = null;
			String tmp2 = null;
			for (int i = 0; i < _LOG_FILES_.length; i++) {
				tmp = this._LOG_NAME_PATCH_.getInfo(_LOG_FILES_[i]);
				tmp2 = tmp.substring(4).concat(tmp.substring(0, 4));
				list.add(tmp2);
			}

			Collections.sort(list);
			tmp = (String) list.getFirst();
			this._CURRENT_LOG_FILENAME_ = this._LOG_NAME_PATCH_.getInverseInfo(tmp.substring(4).concat(tmp.substring(0, 4)));

			return this._CURRENT_LOG_FILENAME_;
		}
		else {
			return null;
		}
	}
}
