/*
 * @(#)SizeIndexedBlockLogFileReader.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.io.FileInputStream;
import java.io.IOException;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsSizeIndexedInputStream;
/**
 * 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class SizeIndexedBlockLogFileReader extends LogFileReader {
	
	
	protected eMsSizeIndexedInputStream _LOG_FILE_READER_ = null;
	
	
	
	/** Creates a new instance of SizeIndexedBlockLogFileReader */
	public SizeIndexedBlockLogFileReader() {
		super();
		setName( "LineReadLogFileReader" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** 현재 파일 포인터를 반환한다
	 */
	public long getFilePoint() throws IOException {
		return _LOG_FILE_READER_.getFilePointer();
	}
	
	/** 다음파일을 오픈한다
	 */
	public void openFile(String filename, long filepoint) throws IOException {
		if( _LOG_FILE_READER_ != null ) {
			try{_LOG_FILE_READER_.close();}catch(Exception _ex) { }
		}
		
		this._CURRENT_LOG_FILENAME_ = filename;
		
		this._LOG_FILE_READER_ = new eMsSizeIndexedInputStream( new FileInputStream( this._LOG_FILE_FILTER_.getTargetDir() + "/" + this._CURRENT_LOG_FILENAME_ ) );
		filepoint = filepoint < 0L ? 0L : filepoint;
		_LOG_FILE_READER_.skip(filepoint);
		this._LOG_FILE_FILTER_.setCurrFilename(this._CURRENT_LOG_FILENAME_);
	}
	
	/** 현재 열린 파일을 닫는다.
	 */
	public void close() {
		try{ this._LOG_FILE_READER_.close(); }catch( Exception ignore ){}
		this._LOG_FILE_READER_ = null;
		this._CURRENT_LOG_FILENAME_ = null;
	}
	
	/** 다음 레코드를 반환한다.
	 */
	public String readLine() throws IOException {
		return this._LOG_FILE_READER_.next();
	}
	
	/** 다음 대상파일로 전환한다.
	 */
	public boolean next() {
		String tmpFile = this._LOG_FILE_FILTER_.getNextFilename();
		
		if(tmpFile == null) {
			return false;
		}
		
		try {
			openFile(tmpFile, 0L);
		}
		catch(Exception _ex) {
			return false;
		}
		return true;
	}
}
