/*
 * @(#)LogProcessor.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.Name;

/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j

public class LogProcessorPps extends Name {
	
	
	protected LogFileFilterPps _LOG_FILE_FILTER_ = null;
	
	protected LogFileNamingRule _LOG_FILE_NAMING_RULE_ = null;
	
	protected LogFileNamePatch _LOG_FILE_NAME_PATCH_ = null;
	
	protected String _CURRENT_LOG_FILENAME_ = null;
	
	
	
	/** Creates a new instance of LogProcessor */
	public LogProcessorPps() {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public void setFileFilter(LogFileFilterPps myFilter) {
		this._LOG_FILE_FILTER_ = myFilter;
	}
	
	public void setNamePatch(LogFileNamePatch tmpNamePatch) {
		this._LOG_FILE_NAME_PATCH_ = tmpNamePatch;
	}
	
	public void setNamingRule(LogFileNamingRule tmpNamingRule) {
		this._LOG_FILE_NAMING_RULE_ = tmpNamingRule;
	}
	
	public boolean init() throws Exception {
		return this.init( null );
	}
	
	public boolean init(Object initial) throws Exception {
		if(initial == null) {
			this._CURRENT_LOG_FILENAME_ = this._LOG_FILE_FILTER_.getNextFilename();
		}
		else {
			this._CURRENT_LOG_FILENAME_ = this._LOG_FILE_NAME_PATCH_.getInverseInfo((String)initial);
		}
		
		return this._CURRENT_LOG_FILENAME_ != null;
	}
	
	public String getWorkingFileName() {
		return this._CURRENT_LOG_FILENAME_;
	}
	
}
