/*
 * @(#)LogFileReader.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import lombok.extern.slf4j.Slf4j;

/**
 * 로그 파일을 읽을 여러가지 메소드를 제공한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public abstract class LogFileReaderPps extends LogProcessorPps {
	
	
	
	/** Creates new LogFileReader */
	public LogFileReaderPps() {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/**현재 파일 포인터를 반환한다
	 */
	public abstract long getFilePoint() throws IOException;
	
	/**다음파일을 오픈한다
	 */
	public abstract void openFile(String filename, long filepoint) throws IOException;
	
	/**현재 열린 파일을 닫는다.
	 */
	public abstract void close();
	
	/**다음 레코드를 반환한다.
	 */
	public abstract String readLine() throws IOException;
	
	/**다음 대상파일로 전환한다.
	 */
	public abstract boolean next();
	
	/**처리로그 파일에서 파일의 인덱스를 추출한다.
	 */
	public static long getFileID(String log) {
		int idx1 = log.indexOf("[");
		
		if(idx1 < 0) {
			return -1L;
		}
		
		int idx2 = log.indexOf("]");
		
		if(idx2 < 0 || idx1 + 1 > idx2) {
			return -1L;
		}
		
		String pointer = log.substring(idx1 + 1, idx2);
		
		try {
			return Long.parseLong(pointer);
		}
		catch(Exception _ex) {
			return -1L;
		}
	}
	
	/**지정파일의 마지막 라인을 읽어온다.
	 */
	public static String getLastLine(String filename) throws IOException {
		File targetFile = new File( filename );
		RandomAccessFile AccessFile = null;
		String __RETURN_VALUE__ = null;
		try{
			AccessFile = new RandomAccessFile( targetFile , "r" );
			long length = targetFile.length();
			if(  length > 4096 ){
				AccessFile.seek( length - 4096 );
			}
			
			String tmp = null;
			while( true ) {
				tmp = AccessFile.readLine();
				
				if( tmp == null ) break;
				if( tmp.trim().length() < 1 ) continue;
				__RETURN_VALUE__ = tmp;
			}
		}
		finally{
			if(AccessFile != null) {
				AccessFile.close();
			}
		}
		
		return __RETURN_VALUE__;
	}
	/**
	 * update
	 * @param log
	 * @return
	 */
	public static String getFileName(String log) {
		int idx1 = log.indexOf("[",2);
				
		if(idx1 < 0) {
			return "";
		}
		
		int idx2 = log.indexOf("]",log.indexOf("]")+1);
		
		if(idx2 < 0 || idx1 + 1 > idx2) {
			return "";
		}
		
		return log.substring(idx1+1,idx2);
	}
}
