/*
 * @(#)LogFileFilter.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;

import lombok.extern.slf4j.Slf4j;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class LogFileFilter {
	
	
	protected File _TARGET_DIRECTORY_FILE_ = null;
	protected String _TARGET_DIRECTORY_ = null;
	protected String _CURRENT_LOG_FILENAME_ = null;
	protected LogFileNamingRule _LOG_NAME_RULE_ = null;
	protected LogFileNamePatch _LOG_NAME_PATCH_ = null;
	
	
	
	/** Creates a new instance of LogFileFilter */
	public LogFileFilter() {
		super();
	}
	
	public void setTargetDir(String dir) {
		this._TARGET_DIRECTORY_ = dir;
		this._TARGET_DIRECTORY_FILE_ = new File( dir );
	}
	
	public void setNameRule(LogFileNamingRule filter) {
		this._LOG_NAME_RULE_ = filter;
	}
	
	public void setNamePatch(LogFileNamePatch patcher) {
		this._LOG_NAME_PATCH_ = patcher;
	}
	
	public String getLastFilename() {
		String _LOG_FILE_LIST_[] = this._TARGET_DIRECTORY_FILE_.list(this._LOG_NAME_RULE_);
		
		LinkedList list = new LinkedList();
		
		if(_LOG_FILE_LIST_.length > 0) {
			for(int i = 0; i < _LOG_FILE_LIST_.length; i++) {
				list.add(_LOG_FILE_LIST_[i]);
			}
			
			Collections.sort(list);
			return (String)list.getLast();
		}

		return null;
	}
	
	public String getTargetDir() {
		return this._TARGET_DIRECTORY_;
	}
	
	public synchronized String getTargetFile(String last_file_id) {
		this._CURRENT_LOG_FILENAME_ = this._LOG_NAME_PATCH_.getInverseInfo(last_file_id);
		return this.getWorkingFile();
	}
	
	public String getWorkingFile() {
		return this._CURRENT_LOG_FILENAME_;
	}
	
	public String getNextFilename() {
		if (log.isDebugEnabled())  log.debug(" Log Filter Select base filename : " + this._CURRENT_LOG_FILENAME_ );
		this._LOG_NAME_RULE_.setLastFile( this._CURRENT_LOG_FILENAME_ );
		
		String _LOG_FILES_[] = this._TARGET_DIRECTORY_FILE_.list(this._LOG_NAME_RULE_ );
		
		this._LOG_NAME_RULE_.setLastFile( null );
		
		LinkedList list = new LinkedList();
		
		if(_LOG_FILES_.length > 0) {
			for(int i = 0; i < _LOG_FILES_.length; i++) {
				list.add(_LOG_FILES_[i]);
			}
			
			Collections.sort(list);
			this._CURRENT_LOG_FILENAME_ = (String)list.getFirst();
			log.debug("Log Filter Select filename : " + this._CURRENT_LOG_FILENAME_);
			
			return this._CURRENT_LOG_FILENAME_;
		}

		return null;
	}
	
	public void setCurrFilename(String filename) {
		this._CURRENT_LOG_FILENAME_ = filename;
	}
	
	public String getFullName(String filename) {
		return this._TARGET_DIRECTORY_.concat( "/" ).concat( filename );
	}
}
