/*
 * @(#)LineReadLogFileReader.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.io.IOException;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsRandomReader;
/**
 * 로그 파일을 읽을 때 Line별로 파일을 읽기 편리한 메소드를 제공 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class LineReadLogFileReaderPps extends LogFileReaderPps {
	
	
	protected eMsRandomReader _LOG_FILE_READER_ = null;
	
	
	
	/** Creates a new instance of LineReadLogFileReader */
	public LineReadLogFileReaderPps() {
		super();
		setName( "LineReadLogFileReader" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public long getFilePoint() throws IOException {
		return _LOG_FILE_READER_.getFilePointer();
	}
	
	public void openFile(String filename, long filepoint) throws IOException {
		if( _LOG_FILE_READER_ != null ) {
			try{_LOG_FILE_READER_.close();}catch(Exception _ex) { }
		}
		
		this._CURRENT_LOG_FILENAME_ = filename;
		
		this._LOG_FILE_READER_ = new eMsRandomReader(this._LOG_FILE_FILTER_.getTargetDir() + "/" + this._CURRENT_LOG_FILENAME_);
		filepoint = filepoint < 0L ? 0L : filepoint;
		_LOG_FILE_READER_.seek(filepoint);
		this._LOG_FILE_FILTER_.setCurrFilename(this._CURRENT_LOG_FILENAME_);
	}
	
	public void close() {
		try{ this._LOG_FILE_READER_.close(); }catch( Exception ignore ){}
		this._LOG_FILE_READER_ = null;
		this._CURRENT_LOG_FILENAME_ = null;
	}
	
	public String readLine() throws IOException {
		return this._LOG_FILE_READER_.ConvertReadLine();
	}
	
	public boolean next() {
		String tmpFile = this._LOG_FILE_FILTER_.getNextFilename();
		
		if(tmpFile == null) {
			return false;
		}
		
		try {
			openFile(tmpFile, 0L);
		}
		catch(Exception _ex) {
			return false;
		}
		return true;
	}
	
	public static long getFileID(String log) {
		int idx1 = log.indexOf("[");
		
		if(idx1 < 0) {
			return -1L;
		}
		
		int idx2 = log.indexOf("]");
		
		if(idx2 < 0 || idx1 + 1 > idx2) {
			return -1L;
		}
		
		String pointer = log.substring(idx1 + 1, idx2);
		
		try {
			return Long.parseLong(pointer);
		}
		catch(Exception _ex) {
			return -1L;
		}
	}
}
