package moon.logprocess.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

import lombok.extern.slf4j.Slf4j;
import mars.tracking.parser.TrackingApacheLogParser;

/**
 * @author 이상근
 */
@Slf4j
public class IISLogFileFilter extends LogFileFilter {
	

	/** Creates a new instance of LogFileFilter */
	public IISLogFileFilter() {
		super();
	}

	/**
	 * 대상 디렉토리에서 마지막 파일의 이름을 반환한다. IIS는 마지막 파일은 읽으면 안되기 때문에 인덱스 하나를 배야한다.
	 * 
	 * @return 마지막 파일 이름
	 */
	public String getLastFilename() {
		String _LOG_FILE_LIST_[] = this._TARGET_DIRECTORY_FILE_.list(this._LOG_NAME_RULE_);

		if( _LOG_FILE_LIST_ == null || _LOG_FILE_LIST_.length < 2 ) {
			return null;
		}

		ArrayList list = new ArrayList();

		if( _LOG_FILE_LIST_.length > 0 ) {
			for (int i = 0; i < _LOG_FILE_LIST_.length; i++) {
				list.add(_LOG_FILE_LIST_[i]);
			}

			Collections.sort(list);
			return (String) list.get(list.size() - 2);
		}
		else {
			return null;
		}
	}

	/**
	 * 다음 파일 이름을 가져온다.
	 * 
	 * @return 대상 다음 파일
	 */
	public String getNextFilename() {
		if (log.isDebugEnabled()) {
			log.debug("Log Filter Select base filename", this._CURRENT_LOG_FILENAME_);
		}

		this._LOG_NAME_RULE_.setLastFile(this._CURRENT_LOG_FILENAME_);

		String _LOG_FILES_[] = this._TARGET_DIRECTORY_FILE_.list(this._LOG_NAME_RULE_);

		this._LOG_NAME_RULE_.setLastFile(null);

		if( _LOG_FILES_ == null || _LOG_FILES_.length < 2 ) {
			return null;
		}

		LinkedList list = new LinkedList();

		if( _LOG_FILES_.length > 0 ) {
			for (int i = 0; i < _LOG_FILES_.length; i++) {
				list.add(_LOG_FILES_[i]);
			}

			Collections.sort(list);
			this._CURRENT_LOG_FILENAME_ = (String) list.getFirst();
			log.debug("Log Filter Select filename : " + this._CURRENT_LOG_FILENAME_);

			return this._CURRENT_LOG_FILENAME_;
		}
		else {
			return null;
		}
	}
}
