/*
 * @(#)HeadTailLogFileNamingRule.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.io.File;
import java.util.Properties;
/**
 * 로그 파일명이 접두어, 접미어를 가지는 경우 파일명의 유효성을 검사 
 * 
 * @version		
 * @author 		dragon
 *
 */
public class HeadTailLogFileNamingRule extends LogFileNamingRule {
	
	
	protected String _START_INDEX_ = null;
	protected String _END_INDEX_ = null;
	
	/** Creates new HeadTailLogFileNamingRule */
	public HeadTailLogFileNamingRule() {
		super();
	}
	
	public void init(Object obj) {
		Properties prop = ( Properties )obj;
		
		this._START_INDEX_ = prop.getProperty( "log.head" );
		this._END_INDEX_ = prop.getProperty( "log.tail" );
	}
	
	public boolean accept(File p1, String name)
	{
		boolean __TMP_ACCEPT__ = _LAST_FILE_NAME_ == null;
		
		if(!__TMP_ACCEPT__)
		{
			__TMP_ACCEPT__ = name.compareTo( _LAST_FILE_NAME_ ) > 0;
		}
		
		return name.startsWith(this._START_INDEX_) 
					&& name.endsWith(this._END_INDEX_) 
					&& __TMP_ACCEPT__;
	}
}
