/*
 * @(#)HeadOnlyNamePatch.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.util.Properties;

/**
 * 로그 파일 명이 일정한 접두어를 가질 경우
 * 
 * @version		
 * @author 		dragon
 *
 */
public class HeadOnlyNamePatch extends LogFileNamePatch {
	
	
	protected String _START_INDEX_ = null;

	/** Creates new HeadOnlyNamePatch */
	public HeadOnlyNamePatch() {
		super();
	}

	public void init(Object obj) {
		
		Properties prop = ( Properties )obj;
		this._START_INDEX_ = prop.getProperty( "log.head" );
	}
	
	public String getInfo(String name)
	{
		if(!name.startsWith(this._START_INDEX_))
		{
			return null;
		}
		
		return name.substring( this._START_INDEX_.length() );
	}
	
	public String getInverseInfo(String id)
	{
		return this._START_INDEX_.concat( id );
	}
}
