 
package moon.logprocess.module;

import java.io.IOException;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsFileWriter;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class BackLogWriterPps extends LogProcessorPps {
	
	
	
	protected eMsFileWriter _BACK_LOG_WRITER_ = null;
	
	/** Creates a new instance of BackLogWriterPps */
	public BackLogWriterPps() {
		super();
		setName( "BackLogWriterPps" );
		if(log.isDebugEnabled()){
			// foo
		}
	}

	public boolean init(Object initial) throws Exception {
		return true;
	}
	
	public void openFile(String id) throws IOException {
		if( this._BACK_LOG_WRITER_ != null ) {
			try{this._BACK_LOG_WRITER_.flush();}catch(Exception _ex) { }
		}
		
		try {
			if(this._BACK_LOG_WRITER_ != null) {
				this._BACK_LOG_WRITER_.close();
			}
		}
		catch(Exception _ex) { }
		
		this._CURRENT_LOG_FILENAME_ = this._LOG_FILE_NAME_PATCH_.getInverseInfo(id);
		
		open();
	}
	
	protected void open() throws IOException {
		this._BACK_LOG_WRITER_ = new eMsFileWriter(this._LOG_FILE_FILTER_.getTargetDir() + "/" + this._CURRENT_LOG_FILENAME_, true);
	}
	
	public void append(String info, String log) throws IOException {
		this._BACK_LOG_WRITER_.write("[" + info + "]\t[" + log + "]");
		this._BACK_LOG_WRITER_.newLine();
		this._BACK_LOG_WRITER_.flush();
	}
	
	public void close() {
		try{ this._BACK_LOG_WRITER_.flush(); }catch( Exception ignore ){}
		try{ this._BACK_LOG_WRITER_.close(); }catch( Exception ignore ){}
		this._BACK_LOG_WRITER_ = null;
		this._CURRENT_LOG_FILENAME_=null;
	}
}
