/*
 * @(#)BackLogWriter.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package moon.logprocess.module;

import java.io.IOException;

import lombok.extern.slf4j.Slf4j;
import pluto.io.eMsFileWriter;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class BackLogWriter extends LogProcessor {
	
	
	
	protected eMsFileWriter _BACK_LOG_WRITER_ = null;
	
	/** Creates a new instance of BackLogWriter */
	public BackLogWriter() {
		super();
		setName( "BackLogWriter" );
		if(log.isDebugEnabled()){
			// foo
		}
	}

	public boolean init(Object initial) throws Exception {
		return true;
	}
	
	public void openFile(String id) throws IOException {
		if( this._BACK_LOG_WRITER_ != null ) {
			try{this._BACK_LOG_WRITER_.flush();}catch(Exception _ex) { }
		}
		
		try {
			if(this._BACK_LOG_WRITER_ != null) {
				this._BACK_LOG_WRITER_.close();
			}
		}
		catch(Exception _ex) { }
		
		this._CURRENT_LOG_FILENAME_ = this._LOG_FILE_NAME_PATCH_.getInverseInfo(id);
		
		open();
	}
	
	protected void open() throws IOException {
		this._BACK_LOG_WRITER_ = new eMsFileWriter(this._LOG_FILE_FILTER_.getTargetDir() + "/" + this._CURRENT_LOG_FILENAME_, true);
	}
	
	public void append(String info, String log) throws IOException {
		this._BACK_LOG_WRITER_.write("[" + info + "]\t[" + log + "]");
		this._BACK_LOG_WRITER_.newLine();
		this._BACK_LOG_WRITER_.flush();
	}
	
	public void close() {
		try{ this._BACK_LOG_WRITER_.flush(); }catch( Exception ignore ){}
		try{ this._BACK_LOG_WRITER_.close(); }catch( Exception ignore ){}
		this._BACK_LOG_WRITER_ = null;
		this._CURRENT_LOG_FILENAME_=null;
	}
}
